package sema;

import modelling.Selector;

/**
 * Signal that can be broadcast through the world.
 * 
 * A signal is a piece of information broadcast for some elements of an {@link Area}.
 * <br>This is a very generalist concept that can be used to communicate or to send an order, for example.
 */
public interface Signal {
    
    /**
     * Returns the area of the signal.
     */
    public Area getArea();
    
    /**
     * Returns the contents of the signal
     */
    public String getContents();
    
    /**
     * Computes whether an element can receive the signal.
     */
    public Selector getSelector();
    
}
