package sema;

import java.util.Vector;


/**
 * Map of the simulated world. It contains the rectangular matrix of boxes.
 */
public class Map {
    
    /**
     * Constructs a Map from the number of boxes on the x and the y coordinate, from their length and the matrix of boxes.
     */
    public Map(int x_boxes, int y_boxes, float box_length, Box[][] boxes) {
        this.xBoxes = x_boxes;
        this.yBoxes = y_boxes;
        this.boxLength = box_length;
        this.xLength = x_boxes * box_length;
        this.yLength = y_boxes * box_length;
        this.boxes = boxes;
    }
    
    /**
     * Number of boxes along the x-axis.
     */
    public final int xBoxes;
    /**
     * Length of map along the x-axis.
     */
    public final int yBoxes;
    /**
     * xLenght of the map ( in simulated unit ).
     */
    public final float xLength;
    
    /**
     * Length of map along the y-axis.
     */
    public final float yLength;
    
    /**
     * Length of a box.
     */
    public final float boxLength;
    
    /**
     * Matrix of the boxes.
     */
    public final Box[][] boxes;
    
    /**
     *Returns a vector containing the boxes covering the given rectangle ( given by it's top left corner and its dimensions )
     */
    public Vector getCoveringBoxes(float x, float y, float x_length, float y_length) {
        Vector covering = new Vector();
        int imin = (int)Math.max((Math.floor(x/boxLength)),0);
        int jmin = (int)Math.max((Math.floor(y/boxLength)),0);
        double imax = Math.min(Math.ceil((x+x_length)/boxLength),xBoxes);
        double jmax = Math.min(Math.ceil((y+y_length)/boxLength), yBoxes);
        for (int i= imin; i<imax; i++) {
            for (int j= jmin; j<jmax; j++) {
                {
                    try {
                        covering.add(boxes[i][j]);
                    } catch (Exception e) {}
                }
            }
        }
        return covering;
    }
    
    /**
     * Returns the properties of the map.
     * @see Engine#getProperties()
     * @return the element's properties.
     */
    protected String[][] getProperties() {
        String[][] ret = new String[5][2];
        String[] p1 = {"xBoxes",new Integer(xBoxes).toString()};
        String[] p2 = {"yBoxes",new Integer(yBoxes).toString()};
        String[] p4 = {"boxLength",new Float(boxLength).toString()};
        String[] p5 = {"xLength",new Float(xLength).toString()};
        String[] p6 = {"yLength",new Float(yLength).toString()};
        ret[0] = p1; ret[1] = p2; ret[2] = p4; ret[3] = p5; ret[4] = p6;
        return(ret);
    }
    
    /**
     * Try to sets the value to the property of the map.
     * The new value is ignored if the property is read_only or if the value isn't valid.
     * @see Engine#setProperties
     * @param property the property to change.
     * @param value the new value for the property.
     */
    protected void setProperties(String property, String value) {
    }
    
}