package sema;

/**
 * An event is used to plan the execution of a task in the futur.
 * <br>An <code>Event</code> is linked with an <code>Engine</code>.
 * It contains a 'whatToDo' and a date at which to execute the task.
 */
public abstract class Event implements java.lang.Comparable {
    
    /**
     *Constructs an event at the given date and ask that it is registered in the given engine.
     */
    public Event(double date, Engine e) {
        this.date = new Double(date);
        e.add(this);
    }
    
    /**
     * the date in milliseconde of simulated secs.
     */
    public Double date;
    
    /**
     * The action to override in order to execute something.
     */
    protected abstract void whatToDo();
    
    /**
     * It is the method called by the engine at run time.
     * before executing the todo, it verify it is still enable
     * Returns true if the task is done, false otherwise.
     */
    public boolean execute() {
        if (enabled) {
            whatToDo();
            return true;} else return false;
    }
    
    private boolean enabled = true; //variable interne pour dsactiver l'vnement
    
    /**
     * Delete the event.
     */
    protected void delete() {
        enabled = false; //dsactive l'vnement pour le supprimer
    }
    
    /**
     * The comparable interface is used to sort events by date.
     */
    public int compareTo(Object o) {
        Event ev = null;
        try { ev=(Event)o;} catch (Exception e) {return(-1);};
        return this.date.compareTo(ev.date);
    }
    
}
