package modelling;

import java.util.Vector;
import sema.Element;
import modelling.Selector;



/**
 * Ability, for an element implementing the interface, to see other elements.
 */
public interface Vision {
    
    
    /**
     * Determinates whether the given element can be seen, with the restrictions of the vision ability.
     */
    public boolean canSee(Element e);
    
    /**
     * Returns the visible elements, with the restrictions of the vision ability.
     */
    public Vector watch();
    
    /**
     * Searchs for the nearest visible element,
     * with the restrictions of the vision ability. Returns <code>null</code> if not found.
     */
    public Element watchNearest();
    
    /**
     * Searchs for all the visible elements fiting a given selector,
     * with the restrictions of the vision ability. Returns <code>null</code> if not found.
     */
    public Vector watchFor(Selector selector);
    
    /**
     * Searchs for the nearest visible element fiting a given selector,
     * with the restrictions of the vision ability. Returns <code>null</code> if not found.
     */
    public Element watchForNearest(Selector selector);
    
}
