
package modelling;

import sema.*;


/**
 * Selects elements.
 * It is a simple encapsulation of a boolean method taking an Element in argument.
 * A selector is useful to give methods in argument.
 */
public abstract class Selector {
    
    /**
     * Computes whether the given element is fiting the requirement of the selector.
     */
    public abstract boolean isFiting(Element el);
    
    
    
    
    
    
    /**
     * Executes the logical fonction or between the current selector and the given one.
     */    
    public Selector or(final Selector sel){
        return new Selector(){
            public boolean isFiting(Element el){
                return isFiting(el) || sel.isFiting(el);
            }
            
        };
        
        
    }
    
    
    /**
     * Executes the logical fonction and between the current selector and the given one.
     */    
    public Selector and(final Selector sel){
        return new Selector(){
            public boolean isFiting(Element el){
                return isFiting(el) && sel.isFiting(el);
            }
            
        };
        
        
        
        
    }
    
    /**
     * Executes the logical fonction not on that selector.
     */
    public Selector not(){
        return new Selector(){
            public boolean isFiting(Element el){
                return !isFiting(el);
            }
            
        };
    }
}
