package modelling;



/**
 * Encapsulates a boolean method and an heuristic.
 * Useful to manage goals within actions.
 */
public abstract class Satisfactor {
    
    /**
     * Checks whether the current state is satisfaying.
     */
    public abstract boolean isSatisfying();
    
    
    /**
     * Give an estimated heuristic distance to the goal.
     */
    public int heuristic(){
        if (isSatisfying()){
            return 1;}
        
        return 0;
    }
    

    /**
     * Executes the logical fonction or between the current satisfactor and the given one.
     */    
    public final Satisfactor or(final Satisfactor sel) {
        return new Satisfactor() {
            public final boolean isSatisfying() {
                
                return (isSatisfying() || sel.isSatisfying());
            }
            
        };
    }
    
    
    /**
     * Executes the logical fonction and between the current satisfactor and the given one.
     */    
    public final Satisfactor and(final Satisfactor sel) {
        return new Satisfactor() {
            public boolean isSatisfying() {
                return (this.isSatisfying() && sel.isSatisfying());
            }
            
        };
    }
    
    
    /**
     * Executes the logical fonction not on the simulator.
     */    
    public final Satisfactor not() {
        return new Satisfactor() {
            public boolean isSatisfying() {
                return (!this.isSatisfying());
            }
            
        };
    }
}






