package modelling;

import sema.Element;

/**
 * Ability to reproduce.
 */
public interface Reproducing {
    
    /**
     * Returns the sex of the Reproducer.
     */
    
    public String getSex();
    
    
    /**
     * Begins the coit.
     */
    public int beginCoit(Element el);
    
    /**
     * Ends the coit.
     */
    public int endCoit(Element el);
    
    
    /**
     * Keeps on reproducing...
     */
    public int continueCoit(Element el);
    
    
    public static final int ACCEPT_COIT = 1;
    public static final int REFUSE_COIT = 0;
    
    public static final int CONTINUE_COIT = 1;
    
    public static final int STOP_COIT = 0;
    public static final int SUCCES_COIT = 1;
    
    
}
