package modelling;

import java.awt.Image;
import java.util.TreeMap;
import sema.Area;
import sema.Signal;
import sema.World;
import sema.Agent;
import sema.Event;

/**
 * Agent able to receive signals.
 */
public class ReceptiveAgent extends Agent implements Receptive {
    
    /**
     * Creates a new agent able to catch signals, with the same parameters than agent.
     */
    public ReceptiveAgent(World world, Area area, float delay, Image image) {
        super(world, area, delay, image);
        
    }
    
    /**
     * Determinates whether the agent is currentyle able to receive this signal.
     */
    protected boolean canCatch(Signal sig){
        return true;
    }
    
    /**
     * Known signals and actions corresponding.
     */
    protected TreeMap sigToAction = new TreeMap();
    
    /**
     * Executes the corresponding action.
     * If signal is unknown, does nothing.
     */
    protected void sigToAction(Signal sig){
        Action a = (Action)sigToAction.get(sig.getContents());
        a.start();
    }
    
    /**
     * Receives a signal.
     * Eventually dismisses it if cannot be catch (canCatch method).
     */
    public void receiveSignal(Signal sig){
        if (canCatch(sig)) {
            sigToAction(sig);
        }
    }
    
}