
package modelling;

import java.awt.Image;
import sema.Area;
import sema.Element;
import modelling.Selector;
import sema.Signal;
import sema.World;


/**
 * The pheromona acts as a fix signal, that may be percieved and may return its content.
 */
public class Pheromone extends Element implements Signal {
    
    /**
     * Creates a new pheromone that may be percieved by the element satisfying the selector.
     */
    public Pheromone(World world, Area area, Image image, String contents, double during, Selector selector) {
        super(world, area, image);
        this.kind = "pheromone";
        this.contents = contents;
        new EndOfPerceptibility(during);
        this.selector = selector;
    }
    /**
     * Creates a new pheromone percieved by the elements of the given kind.
     */
    public Pheromone(World world, Area area, Image image, String contents, double during, String kind){
        super(world, area, image);
        this.kind = "pheromone";
        this.contents = contents;
        new EndOfPerceptibility(during);
        this.selector = world.nature.getGoodKind(kind);
    }
    
    private String kind;
    private String contents;
    private Selector selector;
    
    /** 
     * Returns the message contained.
     */
    public String getContents(){
        return contents;
    }
    
    /**
     * Returns the selector.
     */
    public Selector getSelector(){
        return selector;
    }
    
    /**
     * Limits the life time of the pheromona.
     */
    private class EndOfPerceptibility extends ElementEvent{
        
        private EndOfPerceptibility(double during){
            super(during);
        }

        public void whatToDo(){
            death();
        }
    }
}
