package modelling;

import java.awt.Color;
import java.awt.Image;
import sema.Box;
import sema.Drawing;
import sema.Element;
import sema.Map;

/**
 * Box impossible to run on when checking for collisions.
 */
public class ObstacleBox extends Box{
    
    public ObstacleBox(Map map, Drawing drawing, int x, int y, float height, String kind, Image image) {
        super(map,drawing,x,y,height,kind,image);
    }
    
    public boolean isFreeFor(Element e){
        return false;
    }
    
        /**
     * Draws the <code>Box</code>.
     * if the image is set it draw the image.
     */    
    public void draw() {
        float bl = map.boxLength;
        g.setColor(Color.BLACK);
        g.fillRect(x*bl,y*bl,bl,bl);
        g.drawImage(image,x*bl,y*bl,bl,bl);
    }

    
}
