/*
 **************************************
 * HOW TO BUILD A NEW AGENT WITH SEMA *
 **************************************
 */
package modelling;
/*
 * Importation des packages sema et base.
 */
import sema.*;
import sema.Agent;

/**
 * Structure dpouille d'un fichier .java pour implmenter un nouveau type d'agent.
 * Pour etre utilisable, le fichier doit tre compil, puis plac dans un rpertoire
 * accessible  Java (typiquement java/lib).
 * On peut prciser en option les capacits de l'individu, par l'intermdiaire d'interfaces.
 * Pour prciser qu'un individu est communiquant et peut voir, on crira:
 * <code>implements Communicating, Vision</code>.<br>
 */
public class NewAgent extends Agent /*implements interfaceName1, interfaceName2*/ {
    
    /**
     * Le constructeur de l'agent prend ncessairement le monde d'acceuil en argument.
     * Ce monde est cast en sema.World par le lecteur de fichiers SIM.
     * Pour inclure cet lment dans une simulation, il faut l'ajouter dans la section "ELEMENTS:"
     * d'un fichier SIM, ou dans l'interface par "Add Element", avec la ligne suivante:
     * <code>NewAgent(YourType1 yourArg1Value, .., YourTypeN yourArgNValue)</code>.
     */
    public NewAgent(World world /*, YourType1 yourArg1, .., YourTypeN yourArgN*/) {
        super(world, null /*une Area, forme de l'individu*/, 1 /*un flottant, dlai caractristique de l'individu*/, null /*java.awt.Image de l'individu*/);
        /*
         * Mettre ici le code  excuter  l'instanciation d'un NewAgent.
         * Celui-ci s'ajoute automatiquement au monde (lors de l'appel au constructeur de sa classe mre <code>Agent</code>).
         */
    }
    
    /*
     * Remarque technique:
     * pour utiliser explicitement un monde d'un type World2 hrit de sema.World,
     * il faut caster dans le constructeur de NewAgent 'world' en World2 et le stocker.
     * L'lment ne pourra tre instanci dans Sema s'il prend directement un World2 en argument.
     * Ce cast n'est ncessaire que si World2 ajoute de nouvelles mthodes ou champs de donnes
     *  World, auquel cas il faudra caster le monde en World2 pour pouvoir y accder.
     * Il faut prendre garde  ce genre de cast: l'utilisation d'un tel lment dans un monde
     * utilisant une carte par dfaut sema.Map provoquera une erreur...
     * Il convient donc de vrifier que le cast est possible, par un try {...} catch ...
     */
    
    
    /**
     * Pour les ventuelles classes qui hriteront de NewAgent,
     * il est conseill de remettre en protected certains accesseurs
     * de la classe mre, devenus privs avec l'hritage.
     */
    
    
    /**
     * Eventuellement, rendre 'protected', en les redfinissant, les classes et mthodes
     * qui sont maintenant prives dans NewAgent ( l'hritage, protected -> private).
     *
     * Exemple:
     * protected class Action extends super.Action{
     * ...
     * }
     */
    
    
    /**
     * Ici, rajouter de nouveaux champs, de nouvelles mthodes, de nouvelles classes internes
     */
    
    /**
     * Nouvelles actions, gnralement dfinies en protected
     */
    protected class NewAction  extends Agent.Action{
        public NewAction(double t){
            super(t);
        }
        public float step(){
            //code de NewAction ici
            /*
             * continue, end, pause
             */
            return -1; //
        }
    }
    
    /**
     * Mettre  jour l'heuristique de dcision.
     */
    public boolean acceptAction(Action action){
        return super.acceptAction(action); // changer
    }
    
}