package modelling;

import java.awt.Image;
import sema.Agent;
import sema.Area;
import sema.World;

/**
 * Agent whose size keeps increasing until a maximum size il reached.
 */
public class GrowingAgent extends Agent{
    
    /**
     * Creates a new growing agent, with a given time to incrase his size by a factor of 1.1,
     * and the reachable size, with the convention that the initial size of the agent is 1.
     */
    public GrowingAgent(World world, Area area, float delay, Image image, float reachableSize, float timeToGrow) {
        super(world, area , delay, image);
        this.growing = new Growing (reachableSize, timeToGrow);
    }
    
    /**
     * Action of growing of that element, with his personnal parameters.
     */
    protected Growing growing ;
    
    /**
     * Action of growing. Works by steps of growing by 1.1;
     */
    protected class Growing extends Action {
        
        public Growing(float reachableSize , float timeToGrow){
            super(timeToGrow);
            this.reachableSize = reachableSize;
            this.timeToGrow = timeToGrow;
        }
        
        /**
         * The initial size will be conventionaly 1.
         */
        private float size = 1;
        
        public final float reachableSize;
        public final float timeToGrow;
        
        /**
         * Returns the current size.
         */
        public float getSize(){
            return size;
        }
        /**
         * Fonction of growing.
         */
        protected boolean rescaleSize(float a){
            if (size * a <= reachableSize){
                size = size * a ;
                GrowingAgent.this.getArea().rescale(a, a);
                return true;
            }
            return false;
        }
        
        protected float step(){
            if (rescaleSize ( 1.1f))
                return timeToGrow;
            return -1;
        }
    }
  
}
