package modelling;

import sema.Agent;
import sema.Element;

/**
 * Agent eatable, and giving amongs of food.
 */
public class EatableAgent extends Agent implements Eatable {
    
    /**
     * Creates a new instance of eatable agent with the same arguments than an agent.
     */
    public EatableAgent(sema.World world, sema.Area area, float delay, java.awt.Image image) {
        super(world, area, delay, image);
    }
    
    
    private float nutritiveReserves;
    
    public float getNutritiveReserves(){
        return nutritiveReserves;
    }
    
    protected void setNutritiveReserves(float newValue){
        nutritiveReserves = newValue;
    }
    
    protected void decreaseNutritiveReserves(float decreaseValue){
        nutritiveReserves -= decreaseValue;
    }
    
    /**
     * Determinates if the agent may eat it by the given agent.
     */
    public boolean canEat(Element element){
        return true;
    }
    
    
    /**
     * Returns the among of food get.
     */
    
    public float eaten(Agent agent){
        float a = (float) Math.min( 10*Math.random(), getNutritiveReserves());
        decreaseNutritiveReserves(a);
        if (getNutritiveReserves() <= 0){
            death();
        }
        return ((float) a)*10.f;
    }
    
}
