package modelling;


/**
 * Discussion between two agents.
 */
public interface Communicating {
    
    
    /**
     * Receives the partner's speech. Returns whether we plan to respond.
     */
    public boolean hear(String speech, Communicating Speaker);
    
    
    /**
     * Current discussion of the agent (returns <code>null</code> if none).
     */
    public Discussion getCurrentDiscussion();
    
    
    /**
     * Implemented by {@link modelling.CommunicatingAgent.Discussion},
     * who extends {@link sema.Agent.Action}.
     */
    public interface Discussion {};
    
    
    
    
    
    
}
