/*
 * Bulle.java
 *
 * Created on 21 mai 2005, 15:35
 */

package examples;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.Vector;
import sema.Element;
import modelling.MovingAgent;
import sema.Box;
import sema.World;


public class TriBulleAgent extends Element{
    public TriBulleAgent(World world, int n){
        super(world,new modelling.RectangularArea(world.map,1,1,1,1),(new BufferedImage(1,1,1)));
        for(int i = 0; i<=n;i++){
            new Bulle(world,n,i, this);
        }
        setDrawingPriority(100);
    }
    
    protected int echanges = 0;
    
    public void draw(){
        world.drawing.setColor(new Color(0,1,0));
       world.drawing.drawString("Nombre d'changes: "+echanges,0,0);
    }
    
}

/**
 *
 * @author Boris
 */
class Bulle extends MovingAgent2{
    
    /** Creates a new instance of Bulle */
    public Bulle(World world,int n, int i, TriBulleAgent generator) {
        super(world, new modelling.CircularArea(world.map, .5f, .5f, .5f,0),1, (new BufferedImage(1,1,1)),1);
        this.i = i;
        this.n = n;
        this.generator = generator;
        this.iCourant = n-i;
        new Ameliorate();
        getArea().setX((float)Math.random()*(world.map.xLength-1)+.5f);
        getArea().setY((float)Math.random()*(world.map.yLength-1)+.5f);
    }
    
    protected int i, n, iCourant;
    protected TriBulleAgent generator;
    
    private class Ameliorate extends MovingAgent2.Errer{
        public Ameliorate(){
            super(1f);
        }
        public float step(){
            float a = super.step();
            Vector v = getArea().getIntersectedBoxes();
            int bestBenef = 0;
            Bulle bestEl = Bulle.this;
            for (int k = 0; k<v.size(); k++){
                Box b = (Box) v.get(k);
                Iterator it =b.getContents().iterator();
                while (it.hasNext()) {
                    try { //on ne considre que les Bulle
                        Bulle e = (Bulle) it.next();
                        int currentBenef = Math.abs(i-iCourant)+Math.abs(e.i-e.iCourant) - (Math.abs(i-e.iCourant)+Math.abs(e.i-iCourant));
                        if (currentBenef>bestBenef) {
                            bestBenef = currentBenef;
                            bestEl = e;
                        }
                    } catch (Exception e) {};
                }
            }
            int iC2 = iCourant;
            iCourant = bestEl.iCourant;
            bestEl.iCourant = iC2;
            if (bestEl!=Bulle.this)
                generator.echanges = generator.echanges +1;
            if (i==iCourant) {Bulle.this.setDrawingPriority(-1); return -1;}
            else return a;
        }
        public void whenEnd(){
            if (i!=iCourant)
                new Ameliorate();
            else (new MoveTo(i*(world.map.xLength-1)/n+.5f,.5f)).start();
        }
    }
    
    public void draw(){
        getArea().highlight(world.drawing,new Color(1-1f/(Math.abs(i-iCourant)+1),0,0));
        world.drawing.setColor(Color.GREEN);
        //world.drawing.drawString("A"+String.valueOf(i)+": "+String.valueOf(iCourant),getArea().getX(),getArea().getY());
    }
    
}
