/*
 * Tas.java
 *
 * Created on 24 mai 2005, 22:06
 */

package examples;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.Vector;
import modelling.RectangularArea;
import modelling.Selector;
import sema.Agent;
import sema.Agent.Action;
import sema.Box;
import sema.Element;
import sema.World;

/**
 *
 * @author Boris
 */
public class Tas extends Agent {
    
    
    /** Creates a new instance of Tas */
    public Tas(World world, int n, float proba, Image image) {
        super(world,new RectangularArea(world.map,-3,-3,1,1),5,new BufferedImage(1,1,1));
        (new Generate()).start();
        this.proba = proba;
        this.n = n;
        this.image = image;
    }
    
    Image image;
    int n; float proba;
    class Generate extends Action{
        public float step(){
            new Grain(world,24,0,proba,image);
            return getDelay();
        }
    }
    
}

class Grain extends MovingAgent2{
    static class NoElements extends Selector{
        public boolean isFiting(Element e){
            return false;
        }
    }
    
    public Grain(World world, float x, float y, float proba, Image image){
        super(world,new RectangularArea2(world.map,(x+.5f)*world.map.boxLength,(y+.5f)*world.map.boxLength,world.map.boxLength,world.map.boxLength,(float)Math.PI/2),1,image,1,new NoElements());
        (new Fall()).start();
    }
    
    protected boolean isCrashingElements2() {
        Vector v = getArea().getIntersectedBoxes();
        for (int i = 0; i<v.size(); i++){
            Box b = (Box) v.get(i);
            if (!b.isFreeFor(this)) return true;
            Iterator it =b.getContents().iterator();
            while (it.hasNext()) {
                Element a = (Element) it.next();
                if (a!=this && !compatibleElements.isFiting(a) && this.getArea().isIn(a.getArea().getX(),a.getArea().getY()))
                    return true;
            }
        }
        return(false);
    }
    
    protected boolean translate2(float x, float y){
        if (getArea().translate(x,y)) {
            if (isCrashingElements2() || !getArea().inMap())
                getArea().translate(-x, -y);
            else
                return true;
        }
        return false;
    }
    
    
    protected boolean walk(float f){
        return walk(f,getArea().getAngle());
    }
    
    protected boolean walk(float f, float a){
        if (translate2(f*(float)Math.cos(a),f*(float)Math.sin(a)))
            return true;
        return false;
    }
    
    class Fall extends Action{
        
        public float step(){
            if (walk(world.map.boxLength)) {
                walk(world.map.boxLength,(int)(Math.random()*2)*(float)Math.PI);
                return getDelay();
            } else return -1;
        }/**
        public void whenEnd(){
            int i = (int)(Math.random()*2);
            if (walk(world.map.boxLength,i*(float)Math.PI))
                if (walk(world.map.boxLength))
                    (new Fall()).start();
                else {
                if (walk(world.map.boxLength,(1-i)*(float)Math.PI)) {
                    if (walk(world.map.boxLength))
                        (new Fall()).start();
                }
                }
        }*/
    }
}