/*
 * Ruche.java
 *
 * Created on 23 mai 2005, 22:02
 */

package examples;

import java.awt.Image;
import sema.Agent;
import sema.Box;
import sema.Element;
import sema.World;

/**
 *
 * @author Boris
 */
public class Ruche extends Element {
    
    public Ruche(World world, Image image) {
        super(world,new RectangularArea2(world.map,0,0,0,0),image);
        for (int i=0; i<world.map.xLength; i++){
            for (int j=0; j<world.map.yLength; j++){
                if (Math.sqrt((i-25)*(i-25)+(j-25)*(j-25))<20)
                    new Alveole(world,i,j,image);
            }
        }
    }
    
}


class Alveole extends Agent{
    
    /** Creates a new instance of Alveole */
    public Alveole(World world, float x, float y,Image image) {
        super(world, new DefinitiveRectangularArea2(world.map,(x+.5f)*world.map.boxLength,(y+.5f)*world.map.boxLength,world.map.boxLength,world.map.boxLength),1,image);
        setDrawingPriority(-2);
        bl = world.map.boxLength;
        new Construct();
    }
    
    class Construct extends Action{
        public Construct(){
            start();
        }
        public float step(){
            occupantsCumuls = occupantsCumuls + 3*(((Box)getArea().getIntersectedBoxes().get(0)).getContents().size()-1)-1;
            if (occupantsCumuls>1000*Math.random()+50) drawable = true;
            if (occupantsCumuls<0) drawable = false;
            return getDelay();
        }
    }
    
    private boolean drawable = false;
    private float bl;
    private int occupantsCumuls= 0;
    
    public void draw(){
        if (drawable)
            world.drawing.drawImage(getImage(),getArea().getX()-.5f,getArea().getY()-.5f,1,1);
    }
    
    
}