package examples;

import java.awt.Color;
import java.awt.Image;
import sema.Box;
import sema.Drawing;
import sema.Element;
import sema.Map;

/**
 * Box impossible to run on when checking for collisions.
 */
public class RandomObstacleBox extends Box{
    
    public RandomObstacleBox(Map map, Drawing drawing, int x, int y, float height, String kind, Image image) {
        super(map,drawing,x,y,height,kind,image);
        if (Math.random()<.1) machin = false;
    }
    
    private boolean machin = true;
    
    public boolean isFreeFor(Element e){
        return machin;
    }
    
    /**
     * Draws the <code>Box</code>.
     * if the image is set it draw the image.
     */
    public void draw() {
        g.setColor(Color.WHITE);
        float bl = map.boxLength;
        if (!machin)
            g.setColor(Color.BLACK);
        g.fillRect(x*bl,y*bl,bl,bl);
        g.drawImage(image,x*bl,y*bl,bl,bl);
    }
    
    
}
