/*
 * MoucheSuiveuse.java
 *
 * Created on 25 mai 2005, 01:26
 */

package examples;

import java.awt.Image;
import java.awt.image.BufferedImage;
import sema.Area;
import sema.Element;
import sema.World;

/**
 *
 * @author Boris
 */
public class MouchesSuiveuses2 extends MovingAgent2 {
    
    /** Creates a new instance of MoucheSuiveuse */
    public MouchesSuiveuses2(World world,int n, Image image) {
        super(world,new RectangularArea2(world.map,-5,-5,2,2),.5f,image,1);
        Element lastE = new RandomGoalsAgent(world,new RectangularArea2(world.map,.9f*world.map.xLength,world.map.yLength*(.5f),2,2),1,image,.5f,new AllElements());
        Element firstE = lastE;
        for (int i = 1; i<n; i++){
            float angle = 2*(float)Math.PI*(float)i/n;
            lastE = new MoucheSuiveuse2(world,world.map.xLength*(.5f+.4f*(float)Math.cos(angle)),world.map.yLength*(.5f+.4f*(float)Math.sin(angle)),lastE,image);
        }
    }
    
}

class MoucheSuiveuse2 extends MovingAgent2 {
    protected boolean walk(float f){
        return walk(f,getArea().getAngle());
    }
    
    protected boolean walk(float f, float a){
        if (translate(f*(float)Math.cos(a),f*(float)Math.sin(a)))
            return true;
        return false;
    }
    
    /** Creates a new instance of MoucheSuiveuse */
    MoucheSuiveuse2(World world,float x, float y,Element e, Image image) {
        super(world,new RectangularArea2(world.map,x,y,2,2),.2f,image,1);
        (new Follow()).start();
        this.e = e;
    }
    Element e;
    
    class Marque extends Element{
        public Marque(World world, Area area){
            super(world,area,new BufferedImage(1,1,1));
            new Death(170);
        }
        class Death extends ElementEvent{
            public Death(double d){
                super(d);
            }
            public void whatToDo(){
                death();
            }
        }
    }
    
    class Follow extends Action{
        public float step(){
            orientate(e.getArea().getX(), e.getArea().getY());
            new Marque(world,new RectangularArea2(world.map,getArea().getX(),getArea().getY(),.1f,.1f));
            walk();
            return getDelay();
        }
    }
}
