package examples;

import modelling.CircularArea;
import sema.Signal;
import sema.Map;
import sema.Area;
import modelling.Selector;



/**
 * Signal with a circulary diffusion from an origin point.
 */
public class Message2 implements Signal {
    
    /**
     * Creates a new message with a given satisfactor
     */
    public Message2(Map map, String contents, float radius, float x, float y, Selector selector){
        this.contents = contents;
        this.radius = radius;
        this.x = x;
        this.y = y;
        this.map = map;
        this.selector = selector;
    }
    
    
    /** 1st coordonate of the message origin point */
    private float x;
    /* 2nd coordonate of the message origin point */
    private float y;
    /* Action radius of the message */
    private float radius;
    
    /**
     * The receiver must be able to detect the origin point of the message.
     * This gives him the first coordonate.
     */
    public float getX(){
        return x;
    }
    
    /**
     * Second coordonate.
     */
    public float getY() {
        return y;
    }
    
    /** Map in which the message take place */
    private Map map;
    /** Message contents */
    private String  contents;
    
    
    /**
     * Determinates which elements are able to perceive that message.
     */
    private Selector selector;
    
    /**
     * Returns the {@link modelling.Selector } selector
     */
    public Selector getSelector(){
        return selector;
    }
    
    /**
     * Determinates the Area covered by the signal.
     * The message localisation may be precised by the {@link modelling.Selector } selector.
     */
    public Area getArea(){
        return new CircularArea(map, x ,y , (float) radius, 1f);
    }
    
    /**
     * Returns the message contents.
     */
    public String getContents() {
        return contents;
    }
}