

package examples;

import java.awt.Color;
import java.awt.Image;
import modelling.Eatable;
import sema.Agent;
import sema.Area;
import sema.Element;
import sema.World;




public class Herbe extends Element implements Eatable {
    
    /** Creates a new instance of Herbe */
    public Herbe(World world, Area area, Image image) {
        super(world, area, image);
        this.image = image;
        setKind("herbe");
        this.nutritiveReserves = 100f;
        //new Growing(250);
        setDrawingPriority(0);
    }
    
    
    
    
    private float nutritiveReserves;
    
    private Image image;
    
    public float getNutritiveReserves(){
        return nutritiveReserves;
    }
    
    protected void setNutritiveReserves(float newValue){
        nutritiveReserves = newValue;
    }
    
    protected void decreaseNutritiveReserves(float decreaseValue){
        nutritiveReserves -= decreaseValue;
    }
    
    /**
     * Determinates if the agent may eat it by the given agent.
     */
    public boolean canEat(Element element){
        return (nutritiveReserves > 0.1);
    }
    
    
    /**
     * Returns the among of food get.
     */
    
    public float eaten(Agent agent){
        float a = (float) Math.min( 20*Math.random(), getNutritiveReserves());
        decreaseNutritiveReserves(a);
        if (getNutritiveReserves() <= 0.1){
            death();
        }
        return ((float) a);
    }
    
    
    protected class Growing extends ElementEvent {
        
        public Growing(double t){
            super(t);
        }
        
        protected void whatToDo(){
            setNutritiveReserves(getNutritiveReserves()+10f);
            //new Growing(360);
        }
    }
    
    
    public void draw() {
        //float redLevel = Math.min((nutritiveReserves)/300 + 0.5f,1)/2;179 ->116
        //float greenLevel = 1.5f - Math.min((nutritiveReserves)/300 + 0.5f,1 );133 -> 179
        //float blueLevel = 34;
        float n = Math.min(nutritiveReserves/100,1);
        int redLevel = (int) (-n*(100)+184);
        int greenLevel = (int)(+n*25 +159);
        int blueLevel = 18;
        //world.drawing.setColor(new Color(0,170f/255f,0,n));
        world.drawing.setColor(new Color(redLevel,greenLevel,blueLevel));
        world.drawing.fillRect(getArea().getX()-.5f,getArea().getY()-.5f,1,1);
    }
    
    
    
    
    public String[][] getProperties() {
        String[][] ret0 = getArea().getProperties();
        String[][] ret = new String[5][2];
        String[] p1 = {"kind",getKind()};
        String[] p2 = {"height",new Float(getHeight()).toString()};
        String[] p3 = {"Drawing priority",new Float(getDrawingPriority()).toString()};
        String[] p4 = {"ID",id.toString()};
        String[] p5 = {"Grass height", new Float(getNutritiveReserves()).toString()};
        ret[0] = p1; ret[1] = p2; ret[2] = p3; ret[3] = p4; ret[4] = p5;
        return(union(ret0,ret)); //proprits de l'area et de l'lment
    }
    
    
    
    public void setProperties(String property, String value) {
        try {
            getArea().setProperties(property,value);
            if (property.equals("height")) {
                setHeight(Float.parseFloat(value));
            } else
                if (property.equals("kind")) {
                setKind(value);
                } else
                    if (property.equals("Drawing priority")) {
                float priority = Float.parseFloat(value);
                setDrawingPriority(priority);
                    }else
                        if (property.equals("Grass height")) {
                float nutritive = Float.parseFloat(value);
                setNutritiveReserves(nutritive);
                        }
        } catch (Exception e) {}
    }
    
    
}
