/*
 * Distributeur.java
 *
 * Created on 21 mai 2005, 19:42
 */

package examples;

import java.awt.Color;
import java.awt.Image;
import modelling.RectangularArea;
import sema.Agent;
import sema.Agent.Action;
import sema.Element;
import sema.World;

/**
 *
 * @author Moi
 */
public class Distributeur extends Agent{
    
    /** Creates a new instance of Distributeur */
    public Distributeur(World world, Image image) {
	super(world,new RectangularArea2(world.map,1f,1f,0.75f,0.75f,0f),1f,image);
	setKind("Machine  caf");
    }
    
    boolean isUsed = false;
    Element user;
    public boolean isUsed() {
	return isUsed;
    }
    public boolean use(Element e) {
	return e == user;
    }
    
    
    int nbcafepret = 0;
    static final double tempsCoffe = 10;
    public boolean askCoffe(Element e){
	if (isUsed()) {
	    new dis("Occup !");
	    return false;
	} else {
	    isUsed = true;
	    user = e;
	    new ElementEvent(tempsCoffe) {
		protected void whatToDo() {
		    new dis("Prt!!");
		    nbcafepret++;
		}
	    };
	    new dis("Prpare le Caf.");
	    return true;
	}
    }
    
    public boolean coffeReady(){
	return nbcafepret>0;
    }
    
    public void takeCoffe(){
	if (coffeReady()) {isUsed = false; nbcafepret--;}
    }
    
    
    String bullephrase;
    boolean disphrase;
    class dis extends Action {
	dis(String phrase) {
	    bullephrase = phrase;
	    disphrase = true;
	    start(2);
	}
	protected float step() {
	    disphrase = false;
	    return -1;
	}
    }
    
    public void draw() {
	getArea().draw(world.drawing);
	if(disphrase) {
	    world.drawing.drawString(bullephrase, getArea().getX(), getArea().getY()-0.5f); //TODO amliore l'affichage
	}
	
	if(isUsed) highlight(new Color(1f,1f,0f,0.7f));
	
	if (isMarked())
	    getArea().highlight(world.drawing,new Color(0,1,0,.3f));
    }
}
