
package examples;

import java.awt.Color;
import java.awt.Image;
import modelling.Eatable;
import sema.Agent;
import sema.Area;
import sema.Element;
import sema.World;

/**
 *
 * @author Propritaire
 */
public class CadavreMouton extends Element implements Eatable{
    
    /** Creates a new instance of CadavreMouton */
    public CadavreMouton(World world, Area area,float nutritiveReserves, Image image) {
        super(world, area, image);
        this.image = image;
        setKind("cadavre");
        this.nutritiveReserves = nutritiveReserves;
        this.nutritiveReserves2 = nutritiveReserves;
        setDrawingPriority(2);
    }
    
    
    
    private float nutritiveReserves, nutritiveReserves2;
    
    private Image image, defImage;
    
    public float getNutritiveReserves(){
        return nutritiveReserves;
    }
    
    protected void setNutritiveReserves(float newValue){
        nutritiveReserves = newValue;
    }
    
    protected void decreaseNutritiveReserves(float decreaseValue){
        nutritiveReserves -= decreaseValue;
        if (nutritiveReserves<=0) {
            setKind("cadavreSec");
        }
    }
    
    /**
     * Determinates if the agent may eat it by the given agent.
     */
    public boolean canEat(Element element){
        return (nutritiveReserves > 0);
    }
    
    public void draw(){
        super.draw();
        if (nutritiveReserves>0)
            highlight(new Color(1,0,0,.6f*nutritiveReserves/nutritiveReserves2));
    }
    
    public void death(){
    }
    
    
    
    
    
    
    
    
    
    
    /**
     * Returns the among of food get.
     */
    
    public float eaten(Agent agent){
        float a = (float) Math.min( 5*Math.random(), getNutritiveReserves());
        decreaseNutritiveReserves(a);
        if (getNutritiveReserves() <= 0){
            death();
        }
        return ((float) a);
    }
    
    
    
    
    public String[][] getProperties() {
        String[][] ret0 = getArea().getProperties();
        String[][] ret = new String[5][2];
        String[] p1 = {"kind",getKind()};
        String[] p2 = {"height",new Float(getHeight()).toString()};
        String[] p3 = {"Drawing priority",new Float(getDrawingPriority()).toString()};
        String[] p4 = {"ID",id.toString()};
        String[] p5 = {"Meat left", new Float(getNutritiveReserves()).toString()};
        ret[0] = p1; ret[1] = p2; ret[2] = p3; ret[3] = p4; ret[4] = p5;
        return(union(ret0,ret)); //proprits de l'area et de l'lment
    }
    
    
    
    public void setProperties(String property, String value) {
        try {
            getArea().setProperties(property,value);
            if (property.equals("height")) {
                setHeight(Float.parseFloat(value));
            } else
                if (property.equals("kind")) {
                setKind(value);
                } else
                    if (property.equals("Drawing priority")) {
                float priority = Float.parseFloat(value);
                setDrawingPriority(priority);
                    }else
                        if (property.equals("Meat left")) {
                float nutritive = Float.parseFloat(value);
                setNutritiveReserves(nutritive);
                        }
        } catch (Exception e) {}
    }
    
    
    
    
    
    
    
    
    
    
    
    
}
