/*
 * Abeille.java
 *
 * Created on 23 mai 2005, 17:13
 */

package examples;

import java.awt.Image;
import java.util.Iterator;
import java.util.Vector;
import modelling.Selector;
import sema.Box;
import sema.Element;
import sema.World;

/**
 *
 * @author Boris
 */
public class Abeille extends MovingAgent2 {
    public static class AbeilleSelector extends Selector{
        public boolean isFiting(Element e){
            if (e.getKind().equals("Abeille")) return false;
            return true;
        }
    }
    
    
    /** Creates a new instance of Abeille */
    public Abeille(World world, float x, float y, Image image) {
        super(world, new examples.RectangularArea2(world.map, x,y,1.4f,1.4f),1,image, 2, new AbeilleSelector());
        setKind("Abeille");
        new Butiner();
    }
    
    protected class Butiner extends MoveTo{
        public Butiner(){
            super((float)Math.random()*(world.map.xLength-1.4f)+.7f,(float)Math.random()*(world.map.yLength-1.4f)+.7f,.7f);
        }
        
        private int flower = 1;
        
        public float step(){
            flower++;
            Vector v = getArea().getIntersectedBoxes();
            if (flower>0)
                for (int i = 0; i<v.size(); i++){
                Box b = (Box) v.get(i);
                Iterator it =b.getContents().iterator();
                while (it.hasNext()) {
                    Element a = (Element) it.next();
                    if (a.getKind().equals("flower")) {
                        flower = -35;
                        return (15);
                    }
                }
                }
            if (successiveFailures>5) {
                return -1;
            }
            return super.step();
        }
        
        public void whenEnd(){
            new Butiner();
        }
    }
    
}
