package SEMAbeans;

import javax.swing.JComponent;
import java.awt.geom.Rectangle2D;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Color;


/**
 * Bean used for the preview of a {@link sema.Map}.
 * This is a blue rectangular area correponding to a part of a map.
 * Every coordinate or dimension has to be given propotionally to the map ;
 * for example the width of the area will be given as: (width of the area in map unit)/(width of the map in map unit).
 */
public class ZGPreviewSEMA extends JComponent{ //composant graphique pour l'affichage de l'aperu de la carte
    
    /**
     * Constructs the component with the specified fixed size.
     */
    public ZGPreviewSEMA() {

        addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                requestFocusInWindow();
            }
        });
    }
    
    //position du rectangle bleu dans l'aperu
    private int px = 0;
    private int py = 0;
    private int plx = 200;
    private int ply = 200;
    
    /**
     * Fixed width of the component
     */
    public final int width = 200;
    /**
     * Fixed height of the component.
     */
    public final int height = 200;
    
    
    //positionner le rectangle bleu dans l'aperu
    /**
     * Sets the position of the center of the zone.
     * @param x the x-coordinate divided by the width of the total map. (in the 0-1 range)
     * @param y the y-coordinate divided by the height of the total map. (in the 0-1 range)
     */
    public void setCenterPosition(float x, float y){
        px = Math.round(x*width-plx/2);
        py = Math.round(y*width-ply/2);
        repaint();
    }
    
    /**
     * Returns the x-coordinate of the center.
     * @return the x-coordinate (in 'proportion' : read {@link ZGPreviewSEMA})
     */
    public int getCenterX(){
        return (px+plx/2);
    }
    /**
     * Returns the x-coordinate of the center.
     * @return the y-coordinate (in 'proportion' : read {@link ZGPreviewSEMA})
     */
    public int getCenterY(){
        return (py+ply/2);
    }
    /**
     * Checks if the point is inside the area.
     * @param x x-coordinate of the point to check.
     * @param y y-coordinate of the point to check.
     * @return whether the coordinates are inside the area.
     */
    public boolean isInZone(int x, int y){
        return (Math.abs(x-getCenterX())<=plx/2 && Math.abs(y-getCenterY())<=ply/2);
    }
    
    //redimensionner le rectangle bleu dans l'aperu
    /**
     * Sets the size of the area.
     * @param width the width of the area.
     * @param height the height of the are.
     */
    public void setZoneSize(float width, float height) {
        float oldplx = plx;
        float oldply = ply;
        plx = Math.round(width*(float)this.width);
        ply = Math.round(height*(float)this.height);
        px = (int)(px + (oldplx - plx)/2);
        py = (int)(py + (oldply - ply)/2);
        repaint();
    }
    
    //taille fixe pour l'aperu lorsque l'on redimensionne la fentre
    /**
     * Returns the preferred size.
     * @return the preferred size.
     */
    public Dimension getPreferredSize() {return new Dimension(width,height); }
    /**
     * Returns the maximum size.
     * @return the maximum size.
     */
    public Dimension getMaximumSize() {	return getPreferredSize(); }
    /**
     * Returns the minimum size.
     * @return the minimum size.
     */
    public Dimension getMinimumSize() {	return getPreferredSize(); }
        /**
     * Paints the component with the specified graphics context.
     * @param g the graphics context.
     * @see javax.swing.JComponent#paintComponent(Graphics  g)
     */
    protected void paintComponent(Graphics g) {
        g.setColor(getBackground());
        g.fillRect(0,0,200,200);
        g.setColor(new Color(30,30,255));
        g.fillRect(px,py,plx,ply); //affichage du rectangle bleu qui indique o l'on se trouve sur la carte
    }
}
