/*
 * Decompiled with CFR 0.152.
 */
package sema;

import java.util.TreeMap;
import sema.Box;
import sema.Drawing;
import sema.Element;
import sema.Engine;
import sema.Map;
import sema.Nature;

public class World {
    private String name;
    private String comments;
    public final Engine engine;
    public final Drawing drawing;
    public final Map map;
    public final Nature nature;
    private TreeMap elements;
    private int currentID;

    public World(Engine engine, Map map, Nature nature, Drawing drawing, String name, String comments) {
        this.currentID = 0;
        this.engine = engine;
        this.map = map;
        this.nature = nature;
        this.elements = new TreeMap();
        this.drawing = drawing;
        this.name = name;
        this.comments = comments;
    }

    public World() {
        this.engine = new Engine();
        Box[][] boxes = new Box[0][0];
        this.map = new Map(0, 0, 1.0f, boxes);
        this.nature = new Nature(this.engine, this.map);
        this.elements = new TreeMap();
        this.drawing = new Drawing(100.0f, 1.0f, 0.0f, 10.0f, 0.0f, 50.0f, 1.0f, 1.0f, 100000, 200, 0.0f, 0.0f, 1);
        this.name = "No simulation";
    }

    public String getName() {
        return this.name;
    }

    public String getComments() {
        return this.comments;
    }

    public void draw() {
    }

    public TreeMap getElements() {
        return (TreeMap)this.elements.clone();
    }

    private Integer newID() {
        return new Integer(this.currentID++);
    }

    protected Integer register(Element el) {
        Integer id = this.newID();
        this.elements.put(id, el);
        return id;
    }

    protected void unregister(Element el) {
        this.elements.remove(el.id);
    }

    public Element id2element(Integer id) {
        Element el = null;
        try {
            el = (Element)this.elements.get(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return el;
    }

    public String[][] getProperties() {
        String[][] ret = new String[3][2];
        String[] p1 = new String[]{"name", this.name};
        String[] p2 = new String[]{"comments", this.comments};
        String[] p4 = new String[]{"Number of elements", new Integer(this.elements.size()).toString()};
        ret[0] = p1;
        ret[1] = p2;
        ret[2] = p4;
        return World.union(ret, World.union(this.map.getProperties(), World.union(this.nature.getProperties(), this.engine.getProperties())));
    }

    private static String[][] union(String[][] p1, String[][] p2) {
        int i;
        int n1 = p1.length;
        int n2 = p2.length;
        String[][] np = new String[n1 + n2][2];
        for (i = 0; i < n1; ++i) {
            np[i] = p1[i];
        }
        for (i = 0; i < n2; ++i) {
            np[n1 + i] = p2[i];
        }
        return np;
    }

    public void setProperties(String s1, String s2) {
        this.map.setProperties(s1, s2);
        this.engine.setProperties(s1, s2);
        this.nature.setProperties(s1, s2);
    }
}

