/*
 * Decompiled with CFR 0.152.
 */
package sema;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import modelling.Receptive;
import modelling.RectangularArea;
import modelling.Selector;
import sema.Agent;
import sema.Area;
import sema.Box;
import sema.Element;
import sema.Engine;
import sema.Map;
import sema.Signal;

public class Nature {
    private Engine engine;
    private Map map;

    public Nature(Engine engine, Map map) {
        this.engine = engine;
        this.map = map;
    }

    public TreeMap getElements(Area area) {
        TreeMap<Integer, Element> cibles = new TreeMap<Integer, Element>();
        Vector boxes = area.getIntersectedBoxes();
        for (int i = 0; i < boxes.size(); ++i) {
            Box box = (Box)boxes.get(i);
            Iterator iterator = box.getContents().iterator();
            while (iterator.hasNext()) {
                Element a = (Element)iterator.next();
                cibles.put(a.id, a);
            }
        }
        return cibles;
    }

    public float getDistance(Element element1, Element element2) {
        float x = element1.getArea().getX() - element2.getArea().getX();
        float y = element1.getArea().getY() - element2.getArea().getY();
        return (float)Math.sqrt(x * x + y * y);
    }

    public void broadcastSignal(Signal sig) {
        TreeMap cibles = this.getElements(sig.getArea());
        Set cles = cibles.keySet();
        Iterator iterator = cles.iterator();
        while (iterator.hasNext()) {
            Agent ag = (Agent)cibles.get(iterator);
            if (!sig.getSelector().isFiting(ag)) continue;
            try {
                Receptive receivingSignalsAgent = (Receptive)((Object)ag);
                receivingSignalsAgent.receiveSignal(sig);
            }
            catch (Exception e) {}
        }
    }

    public CanSee getCanSee(Element el) {
        return new CanSee(el);
    }

    public GoodKind getGoodKind(String kind) {
        return new GoodKind(kind);
    }

    protected String[][] getProperties() {
        String[][] a = new String[][]{};
        return a;
    }

    protected void setProperties(String property, String value) {
    }

    protected class GoodKind
    extends Selector {
        String kind;

        protected GoodKind(String kind) {
            this.kind = kind;
        }

        public boolean isFiting(Element el) {
            return el.getKind().equals(this.kind);
        }
    }

    public class CanSee
    extends Selector {
        private Element ag;

        public CanSee(Element ag) {
            this.ag = ag;
        }

        public boolean isFiting(Element el) {
            float x_length = el.getArea().getX() - this.ag.getArea().getX();
            float y_length = el.getArea().getY() - this.ag.getArea().getY();
            float distance = (float)Math.sqrt(x_length * x_length + y_length * y_length);
            float x = (el.getArea().getX() + this.ag.getArea().getX()) / 2.0f;
            float y = (el.getArea().getY() + this.ag.getArea().getY()) / 2.0f;
            float angle = (float)Math.atan2(y_length, x_length);
            RectangularArea seeWay = new RectangularArea(Nature.this.map, x, y, distance, 0.0f, angle);
            TreeMap treemap = Nature.this.getElements(seeWay);
            treemap.remove(el.id);
            treemap.remove(this.ag.id);
            Set cles = treemap.keySet();
            Iterator iterator = cles.iterator();
            while (iterator.hasNext()) {
                try {
                    Element obstacle = (Element)treemap.get(iterator.next());
                    if (!obstacle.getArea().intersect(el.getArea().getX(), el.getArea().getY(), this.ag.getArea().getX(), this.ag.getArea().getY())) continue;
                    return false;
                }
                catch (Exception e) {
                    System.out.println("Error in the Nature.CanSee - Incorrect casting");
                }
            }
            return true;
        }
    }
}

