/*
 * Decompiled with CFR 0.152.
 */
package sema;

import java.util.Vector;
import sema.Box;

public class Map {
    public final int xBoxes;
    public final int yBoxes;
    public final float xLength;
    public final float yLength;
    public final float boxLength;
    public final Box[][] boxes;

    public Map(int x_boxes, int y_boxes, float box_length, Box[][] boxes) {
        this.xBoxes = x_boxes;
        this.yBoxes = y_boxes;
        this.boxLength = box_length;
        this.xLength = (float)x_boxes * box_length;
        this.yLength = (float)y_boxes * box_length;
        this.boxes = boxes;
    }

    public Vector getCoveringBoxes(float x, float y, float x_length, float y_length) {
        Vector<Box> covering = new Vector<Box>();
        int imin = (int)Math.max(Math.floor(x / this.boxLength), 0.0);
        int jmin = (int)Math.max(Math.floor(y / this.boxLength), 0.0);
        double imax = Math.min(Math.ceil((x + x_length) / this.boxLength), (double)this.xBoxes);
        double jmax = Math.min(Math.ceil((y + y_length) / this.boxLength), (double)this.yBoxes);
        int i = imin;
        while ((double)i < imax) {
            int j = jmin;
            while ((double)j < jmax) {
                try {
                    covering.add(this.boxes[i][j]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return covering;
    }

    protected String[][] getProperties() {
        String[][] ret = new String[5][2];
        String[] p1 = new String[]{"xBoxes", new Integer(this.xBoxes).toString()};
        String[] p2 = new String[]{"yBoxes", new Integer(this.yBoxes).toString()};
        String[] p4 = new String[]{"boxLength", new Float(this.boxLength).toString()};
        String[] p5 = new String[]{"xLength", new Float(this.xLength).toString()};
        String[] p6 = new String[]{"yLength", new Float(this.yLength).toString()};
        ret[0] = p1;
        ret[1] = p2;
        ret[2] = p4;
        ret[3] = p5;
        ret[4] = p6;
        return ret;
    }

    protected void setProperties(String property, String value) {
    }
}

