/*
 * Decompiled with CFR 0.152.
 */
package sema;

import java.util.Stack;
import java.util.TreeMap;
import sema.Event;

public class Engine {
    private Double t = new Double(0.0);
    private TreeMap events = new TreeMap();
    private int futureEvents = 0;
    private int pastEvents = 0;

    public double getTime() {
        return this.t;
    }

    protected void add(Event ev) {
        Double tEv = ev.date;
        if (tEv.compareTo(this.t) >= 0) {
            if (this.events.containsKey(tEv)) {
                Stack s = (Stack)this.events.get(tEv);
                s.add(ev);
            } else {
                Stack<Event> s = new Stack<Event>();
                s.push(ev);
                this.events.put(tEv, s);
            }
        }
        ++this.futureEvents;
    }

    public void delete(Event ev) {
        ev.delete();
    }

    public void next() throws EndOfSimulation, SimulationError {
        try {
            this.t = (Double)this.events.firstKey();
        }
        catch (Exception e) {
            throw new EndOfSimulation();
        }
        Stack s = (Stack)this.events.remove(this.t);
        while (!s.empty()) {
            Event ev = (Event)s.pop();
            --this.futureEvents;
            ++this.pastEvents;
            if (ev == null) continue;
            ev.execute();
        }
    }

    public void gotoDate(Double date) throws EndOfSimulation, SimulationError {
        while (this.t.compareTo(date) < 0) {
            this.next();
        }
    }

    public String[][] getProperties() {
        String[] p8 = new String[]{"Future events", new Integer(this.futureEvents).toString()};
        String[] p9 = new String[]{"Past events", new Integer(this.pastEvents).toString()};
        String[][] a = new String[][]{p8, p9};
        return a;
    }

    public void setProperties(String property, String value) {
    }

    public static class SimulationError
    extends Exception {
        public SimulationError(String error) {
            new Exception(error);
        }
    }

    public static class EndOfSimulation
    extends Exception {
    }
}

