/*
 * Decompiled with CFR 0.152.
 */
package sema;

import java.awt.Color;
import java.awt.Image;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import sema.Area;
import sema.Box;
import sema.Event;
import sema.World;

public class Element
implements Comparable {
    public final World world;
    public final Integer id;
    private Area area;
    private String kind;
    private Image image;
    private float height = 0.0f;
    private float drawingPriority = 0.0f;
    private boolean alive = true;
    private boolean marked = false;

    public Element(World world, Area area, Image image) {
        this.id = world.register(this);
        this.world = world;
        this.kind = "object";
        this.area = area;
        area.setElement(this);
        this.image = image;
    }

    public float getDrawingPriority() {
        return this.drawingPriority;
    }

    protected void setDrawingPriority(float priority) {
        this.drawingPriority = priority;
    }

    public float getHeight() {
        return this.height;
    }

    protected void setHeight(float h) {
        this.height = h;
    }

    public String getKind() {
        return this.kind;
    }

    protected void setKind(String s) {
        this.kind = s;
    }

    public String getName() {
        return this.kind + this.id.toString();
    }

    public Image getImage() {
        return this.image;
    }

    public Area getArea() {
        return this.area;
    }

    public boolean canTake(Element e) {
        return true;
    }

    protected void death() {
        this.world.unregister(this);
        this.alive = false;
        Vector intersectedBoxes = this.getArea().getIntersectedBoxes();
        for (int i = 0; i < intersectedBoxes.size(); ++i) {
            ((Box)intersectedBoxes.get(i)).unregister(this);
        }
    }

    public boolean kill(Element killer) {
        this.death();
        return true;
    }

    public void draw() {
        this.getArea().draw(this.world.drawing);
        if (this.isMarked()) {
            this.getArea().highlight(this.world.drawing, new Color(0.0f, 1.0f, 0.0f, 0.3f));
        }
    }

    public void highlight(Color c) {
        this.getArea().highlight(this.world.drawing, c);
    }

    public void highlight() {
        this.getArea().highlight(this.world.drawing, new Color(1.0f, 0.0f, 0.0f, 0.5f));
    }

    public void setMarked(boolean b) {
        this.marked = b;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public Icon getIcon() {
        if (this.image != null) {
            float f = Math.max((float)this.image.getWidth(null) / 100.0f, (float)this.image.getHeight(null) / 100.0f);
            if (f == 0.0f) {
                f = 1.0f;
            }
            int x = (int)((float)this.image.getWidth(null) / f);
            int y = (int)((float)this.image.getHeight(null) / f);
            return new ImageIcon(this.image.getScaledInstance(x, y, 0));
        }
        return null;
    }

    public String[][] getProperties() {
        String[][] ret0 = this.getArea().getProperties();
        String[][] ret = new String[4][2];
        String[] p1 = new String[]{"kind", this.getKind()};
        String[] p2 = new String[]{"height", new Float(this.getHeight()).toString()};
        String[] p3 = new String[]{"Drawing priority", new Float(this.getDrawingPriority()).toString()};
        String[] p4 = new String[]{"ID", this.id.toString()};
        ret[0] = p1;
        ret[1] = p2;
        ret[2] = p3;
        ret[3] = p4;
        return Element.union(ret0, ret);
    }

    public static String[][] union(String[][] p1, String[][] p2) {
        int i;
        int n1 = p1.length;
        int n2 = p2.length;
        String[][] np = new String[n1 + n2][2];
        for (i = 0; i < n1; ++i) {
            np[i] = p1[i];
        }
        for (i = 0; i < n2; ++i) {
            np[n1 + i] = p2[i];
        }
        return np;
    }

    public void setProperties(String property, String value) {
        try {
            this.area.setProperties(property, value);
            if (property.equals("height")) {
                this.setHeight(Float.parseFloat(value));
            } else if (property.equals("kind")) {
                this.setKind(value);
            } else if (property.equals("Drawing priority")) {
                float priority = Float.parseFloat(value);
                this.setDrawingPriority(priority);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return this.getName();
    }

    public int compareTo(Object o) {
        Element el = null;
        try {
            el = (Element)o;
        }
        catch (Exception e) {
            return -1;
        }
        if (this.getDrawingPriority() > el.getDrawingPriority()) {
            return 1;
        }
        if (this.getDrawingPriority() < el.getDrawingPriority()) {
            return -1;
        }
        return this.id.compareTo(el.id);
    }

    protected abstract class ElementEvent
    extends Event {
        public ElementEvent(double relativeDate) {
            super(relativeDate + Element.this.world.engine.getTime(), Element.this.world.engine);
        }

        public boolean execute() {
            if (Element.this.alive) {
                return super.execute();
            }
            return false;
        }

        protected void whatToDo() {
        }
    }
}

