/*
 * Decompiled with CFR 0.152.
 */
package sema;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import sema.Box;
import sema.Element;

public class Drawing {
    private Graphics2D g;
    public final float boxFactor;
    public final float pixelsByUnitZoom1x;
    public final float pixelsByBoxZoom1x;
    public final float centerX;
    public final float centerY;
    public final float minZoom;
    public final float maxZoom;
    public final float minTfactor;
    public final float maxTfactor;
    public final float tFactor;
    public final float virtualDelay;
    public final int realDelay;
    private float pbu;
    private float pbb;
    private float zoom;

    public Drawing(float pixelsByUnitZoom1x, float boxLength, float minZoom, float maxZoom, float minTfactor, float maxTfactor, float tFactor, float zoomFactor, int virtualD, int realD, float centerX, float centerY, int boxFactor) {
        this.pixelsByUnitZoom1x = pixelsByUnitZoom1x;
        this.pixelsByBoxZoom1x = pixelsByUnitZoom1x * boxLength;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.minTfactor = minTfactor;
        this.maxTfactor = maxTfactor;
        this.tFactor = tFactor;
        this.virtualDelay = virtualD;
        this.realDelay = realD;
        this.zoom = zoomFactor;
        this.centerX = centerX;
        this.centerY = centerY;
        this.boxFactor = boxFactor;
    }

    public void draw(Graphics2D g, Vector boxToRefresh) {
        this.g = g;
        g.setColor(Color.WHITE);
        TreeSet elementsToDraw = new TreeSet();
        for (int i = 0; i < boxToRefresh.size(); ++i) {
            Box bi = (Box)boxToRefresh.get(i);
            bi.draw();
            Iterator it = bi.getContents().iterator();
            while (it.hasNext()) {
                elementsToDraw.add(it.next());
            }
        }
        Iterator it = elementsToDraw.iterator();
        while (it.hasNext()) {
            ((Element)it.next()).draw();
        }
    }

    public void setZoom(float z) {
        this.zoom = z;
        this.pbb = this.zoom * this.pixelsByBoxZoom1x;
        this.pbu = this.zoom * this.pixelsByUnitZoom1x;
    }

    public float getZoom() {
        return this.zoom;
    }

    public float getPixelsByBox() {
        return this.pbb;
    }

    public float getPixelsByUnit() {
        return this.pbu;
    }

    private int l2p(float length) {
        return Math.round(this.pbu * length);
    }

    private int l2dp(float length) {
        return (int)Math.floor(this.pbu * length);
    }

    private int l2up(float length) {
        return (int)Math.ceil(this.pbu * length);
    }

    public void setColor(Color c) {
        this.g.setColor(c);
    }

    public void drawLine(float x1, float y1, float x2, float y2) {
        this.g.drawLine(this.l2p(x1), this.l2p(y1), this.l2p(x2), this.l2p(y2));
    }

    public void drawRect(float x, float y, float xLength, float yLength) {
        this.g.drawRect(this.l2p(x), this.l2p(y), this.l2up(xLength), this.l2up(yLength));
    }

    public void drawRoundRect(float x, float y, float xLength, float yLength) {
        this.g.drawRoundRect(this.l2p(x), this.l2p(y), this.l2up(xLength), this.l2up(yLength), this.l2up(xLength) / 5, this.l2up(yLength) / 5);
    }

    public void fillRoundRect(float x, float y, float xLength, float yLength) {
        this.g.fillRoundRect(this.l2p(x), this.l2p(y), this.l2up(xLength), this.l2up(yLength), this.l2up(xLength) / 5, this.l2up(yLength) / 5);
    }

    public void drawRect(float x0, float y0, float xLength, float yLength, float angle, float x, float y) {
        this.g.rotate(angle, this.l2p(x), this.l2p(y));
        this.g.drawRect(this.l2p(x0), this.l2p(y0), this.l2p(xLength), this.l2p(yLength));
        this.g.rotate(-angle, this.l2p(x), this.l2p(y));
    }

    public void fillRect(float x, float y, float xLength, float yLength) {
        this.g.fillRect(this.l2p(x), this.l2p(y), this.l2up(xLength), this.l2up(yLength));
    }

    public void fillRect(float x0, float y0, float xLength, float yLength, float angle, float x, float y) {
        this.g.rotate(angle, this.l2p(x), this.l2p(y));
        this.g.fillRect(this.l2p(x0), this.l2p(y0), this.l2p(xLength), this.l2p(yLength));
        this.g.rotate(-angle, this.l2p(x), this.l2p(y));
    }

    public void drawCircle(float x, float y, float radius) {
        this.g.drawOval(this.l2p(x - radius), this.l2p(y - radius), this.l2up(2.0f * radius), this.l2up(2.0f * radius));
    }

    public void fillCircle(float x, float y, float radius) {
        this.g.fillOval(this.l2p(x - radius), this.l2p(y - radius), this.l2up(2.0f * radius), this.l2up(2.0f * radius));
    }

    public void drawImage(Image image, float x, float y, float xLength, float yLength) {
        this.g.drawImage(image, this.l2p(x), this.l2p(y), this.l2up(xLength), this.l2up(yLength), null);
    }

    public void drawImage(Image image, float x0, float y0, float xLength, float yLength, float angle, float x, float y) {
        AffineTransform at = new AffineTransform();
        at.rotate(angle, this.pbu * x, this.pbu * y);
        at.translate(this.l2p(x0), this.l2p(y0));
        at.scale((float)this.l2p(xLength) / (float)image.getWidth(null), (float)this.l2p(yLength) / (float)image.getHeight(null));
        this.g.drawImage(image, at, null);
    }

    public void drawString(String s, float x, float y) {
        this.g.drawString(s, this.l2p(x), this.l2p(y));
    }
}

