/*
 * Decompiled with CFR 0.152.
 */
package sema;

import java.awt.Color;
import java.awt.Image;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import sema.Drawing;
import sema.Element;
import sema.Map;

public class Box {
    protected Map map;
    protected Drawing g;
    public final int x;
    public final int y;
    private float height;
    private String kind;
    protected Image image;
    private TreeSet contents = new TreeSet();

    public Box(Map map, Drawing drawing, int x, int y, float height, String kind, Image image) {
        this.map = map;
        this.x = x;
        this.y = y;
        this.height = height;
        this.kind = kind;
        map.boxes[x][y] = this;
        this.image = image;
        this.g = drawing;
    }

    public float getHeight() {
        return this.height;
    }

    public String getKind() {
        return this.kind;
    }

    public Image getImage() {
        return this.image;
    }

    public TreeSet getContents() {
        return (TreeSet)this.contents.clone();
    }

    public boolean isFreeFor(Element el) {
        return true;
    }

    public void register(Element element) {
        this.contents.add(element);
    }

    public void unregister(Element element) {
        this.contents.remove(element);
    }

    public Icon getIcon() {
        if (this.image != null) {
            float f = Math.max((float)this.image.getWidth(null) / 100.0f, (float)this.image.getHeight(null) / 100.0f);
            if (f == 0.0f) {
                f = 1.0f;
            }
            int x = (int)((float)this.image.getWidth(null) / f);
            int y = (int)((float)this.image.getHeight(null) / f);
            return new ImageIcon(this.image.getScaledInstance(x, y, 0));
        }
        return null;
    }

    public void draw() {
        float bl = this.map.boxLength;
        this.g.setColor(Color.WHITE);
        this.g.fillRect((float)this.x * bl, (float)this.y * bl, bl, bl);
        this.g.drawImage(this.image, (float)this.x * bl, (float)this.y * bl, bl, bl);
    }

    public void fill(Color c) {
        float bl = this.map.boxLength;
        this.g.setColor(c);
        this.g.fillRect((float)this.x * bl, (float)this.y * bl, bl, bl);
    }

    public void drawBorder(Color c) {
        float bl = this.map.boxLength;
        this.g.setColor(c);
        this.g.drawRect((float)this.x * bl, (float)this.y * bl, bl, bl);
    }

    public void highlight(Color c) {
        float bl = this.map.boxLength;
        this.g.setColor(c);
        this.g.fillRoundRect((float)this.x * bl, (float)this.y * bl, bl, bl);
        this.g.setColor(Color.BLACK);
        this.g.drawRoundRect((float)this.x * bl, (float)this.y * bl, bl, bl);
    }

    public void highlight() {
        this.highlight(new Color(0.0f, 0.0f, 1.0f, 0.3f));
    }

    public String[][] getProperties() {
        String[][] ret = new String[5][2];
        String[] p1 = new String[]{"x", new Integer(this.x).toString()};
        String[] p2 = new String[]{"y", new Integer(this.y).toString()};
        String[] p3 = new String[]{"height", new Float(this.height).toString()};
        String[] p4 = new String[]{"kind", this.kind};
        String[] p5 = new String[]{"nb of elements", new Integer(this.contents.size()).toString()};
        ret[0] = p1;
        ret[1] = p2;
        ret[2] = p3;
        ret[3] = p4;
        ret[4] = p5;
        return ret;
    }

    public void setProperties(String property, String value) {
        try {
            if (property.equals("height")) {
                this.height = Float.parseFloat(value);
            } else if (property.equals("kind")) {
                this.kind = value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

