/*
 * Decompiled with CFR 0.152.
 */
package sema;

import java.awt.Image;
import sema.Area;
import sema.Element;
import sema.World;

public class Agent
extends Element {
    private float delay;

    public Agent(World world, Area area, float delay, Image image) {
        super(world, area, image);
        this.setDelay(delay * (1.0f + (2.0f * (float)Math.random() - 1.0f) / 100.0f));
    }

    public float getDelay() {
        return this.delay;
    }

    protected void setDelay(float delay) {
        if (delay >= 0.0f) {
            this.delay = delay;
        }
    }

    protected void registerAction(Action a) {
    }

    protected void unregisterAction(Action a) {
    }

    protected boolean acceptAction(Action action) {
        return true;
    }

    public class Action {
        private boolean disabled = false;
        private boolean paused = false;
        private boolean beginned = false;
        private Continue nextEvent;
        private Wait waitEvent;

        public Action() {
            Agent.this.registerAction(this);
        }

        public Action(double t) {
            Agent.this.registerAction(this);
            this.start(t);
        }

        public final boolean start() {
            return this.start(Agent.this.delay);
        }

        public final boolean start(double t) {
            if (this.hasBegun() || this.isDisabled()) {
                return false;
            }
            if (this.isPaused()) {
                this.whenStartInPause();
            } else {
                new FirstEvent(t);
            }
            return true;
        }

        public final boolean isDisabled() {
            return this.disabled;
        }

        private void disable() {
            this.disabled = true;
        }

        public final boolean isPaused() {
            return this.paused;
        }

        private void setPaused(boolean b) {
            this.paused = b;
        }

        public final boolean hasBegun() {
            return this.beginned;
        }

        private final void end() {
            this.disable();
            this.close();
            Agent.this.unregisterAction(this);
        }

        public final void pause() {
            if (this.hasBegun()) {
                this.whenPaused();
                if (this.nextEvent != null) {
                    this.nextEvent.delete();
                    this.nextEvent = null;
                }
            }
            this.setPaused(true);
        }

        public final void pause(double maxWaiting) {
            this.whenPaused();
            if (this.nextEvent != null) {
                this.nextEvent.delete();
                this.nextEvent = null;
            }
            this.setPaused(true);
            this.waitEvent = new Wait(maxWaiting);
        }

        public final void stop() {
            this.whenStopped();
            this.end();
        }

        public final boolean resume() {
            this.setPaused(false);
            if (this.waitEvent != null) {
                this.waitEvent.delete();
                this.waitEvent = null;
            }
            if (!this.hasBegun()) {
                return false;
            }
            if (!this.isDisabled() & !this.isPaused()) {
                return true;
            }
            if (!this.isDisabled()) {
                if (Agent.this.acceptAction(this)) {
                    float m = this.resumedStep();
                    if (m >= 0.0f) {
                        this.nextEvent = new Continue((double)m);
                        return true;
                    }
                    this.whenEnd();
                    this.end();
                    return false;
                }
                this.whenRefused();
                this.end();
                return false;
            }
            return false;
        }

        protected float firstStep() {
            return this.step();
        }

        protected float resumedStep() {
            return this.step();
        }

        protected void whenStartInPause() {
        }

        protected void whenPaused() {
        }

        protected void whenStopped() {
        }

        protected void whenRefused() {
        }

        protected void whenEnd() {
        }

        protected void close() {
        }

        protected float step() {
            return 1.0f;
        }

        private class Wait
        extends Element.ElementEvent {
            public Wait(double t) {
                super(Agent.this, t);
            }

            public void whatToDo() {
                Action.this.resume();
            }
        }

        private class Continue
        extends Element.ElementEvent {
            public Continue(double t) {
                super(Agent.this, t);
            }

            public void whatToDo() {
                if (!Action.this.isDisabled()) {
                    if (Agent.this.acceptAction(Action.this)) {
                        float m = Action.this.step();
                        if (m >= 0.0f) {
                            this.date = new Double(this.date + (double)m);
                            ((Action)Action.this).Agent.this.world.engine.add(this);
                        } else {
                            Action.this.whenEnd();
                            Action.this.end();
                        }
                    } else {
                        Action.this.whenRefused();
                        Action.this.end();
                    }
                }
            }
        }

        private class FirstEvent
        extends Element.ElementEvent {
            public FirstEvent(double t) {
                super(Agent.this, t);
            }

            public void whatToDo() {
                if (!Action.this.isDisabled()) {
                    if (Agent.this.acceptAction(Action.this)) {
                        float m = Action.this.firstStep();
                        Action.this.beginned = true;
                        if (m >= 0.0f) {
                            Action.this.nextEvent = new Continue((double)m);
                        } else {
                            Action.this.whenEnd();
                            Action.this.end();
                        }
                    } else {
                        Action.this.whenRefused();
                        Action.this.end();
                    }
                }
            }
        }
    }
}

