/*
 * Decompiled with CFR 0.152.
 */
package modelling;

import java.awt.Image;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import modelling.RectangularArea;
import modelling.Selector;
import modelling.Vision;
import sema.Agent;
import sema.Area;
import sema.Element;
import sema.Nature;
import sema.World;

public class SeeingAgent
extends Agent
implements Vision {
    private Selector personnalVision;
    float visionRadius;

    public SeeingAgent(World world, Area area, float delay, Image image, float visionRadius) {
        super(world, area, delay, image);
        Nature nature = world.nature;
        nature.getClass();
        this.personnalVision = new Nature.CanSee(nature, this);
        this.visionRadius = visionRadius;
    }

    public String getName() {
        return "Seeing Agent";
    }

    protected float getVisionRadius() {
        return this.visionRadius;
    }

    protected Area getAreaOfVision() {
        float x = (float)((double)this.getArea().getX() + Math.cos(this.getArea().getAngle()) * (double)this.getVisionRadius() / 2.0);
        float y = (float)((double)this.getArea().getY() + Math.sin(this.getArea().getAngle()) * (double)this.getVisionRadius() / 2.0);
        return new RectangularArea(this.world.map, x, y, this.getVisionRadius(), 2.0f * this.getVisionRadius(), this.getArea().getAngle());
    }

    protected Area getLineVision(float angle) {
        float x = (float)((double)this.getArea().getX() + Math.cos(angle) * (double)this.getVisionRadius() / 2.0);
        float y = (float)((double)this.getArea().getY() + Math.sin(angle) * (double)this.getVisionRadius() / 2.0);
        return new RectangularArea(this.world.map, x, y, this.getVisionRadius(), 0.0f, angle);
    }

    public boolean canSee(Element element) {
        return this.personnalVision.isFiting(element) && this.world.nature.getDistance(this, element) < this.getVisionRadius();
    }

    public Vector watch() {
        Vector<Element> seen = new Vector<Element>();
        TreeMap areaOfVision = this.world.nature.getElements(this.getAreaOfVision());
        Set cles = areaOfVision.keySet();
        Iterator iterator = cles.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)areaOfVision.get(iterator.next());
            if (!this.canSee(element)) continue;
            seen.add(element);
        }
        return seen;
    }

    public Element watchNearest() {
        float nearest = Float.MAX_VALUE;
        Element curentNearest = null;
        TreeMap areaOfVision = this.world.nature.getElements(this.getAreaOfVision());
        Set cles = areaOfVision.keySet();
        Iterator iterator = cles.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)areaOfVision.get(iterator.next());
            float distance = this.world.nature.getDistance(element, this);
            if (!(distance < nearest) || !this.personnalVision.isFiting(element)) continue;
            curentNearest = element;
            nearest = distance;
        }
        return curentNearest;
    }

    public Vector watchFor(Selector sel) {
        Vector<Element> seen = new Vector<Element>();
        TreeMap areaOfVision = this.world.nature.getElements(this.getAreaOfVision());
        Set cles = areaOfVision.keySet();
        Iterator iterator = cles.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)areaOfVision.get(iterator.next());
            if (!this.canSee(element) || !sel.isFiting(element)) continue;
            seen.add(element);
        }
        return seen;
    }

    public Element watchForNearest(Selector sel) {
        float nearest = Float.MAX_VALUE;
        Element curentNearest = null;
        TreeMap areaOfVision = this.world.nature.getElements(this.getAreaOfVision());
        Set cles = areaOfVision.keySet();
        Iterator iterator = cles.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)areaOfVision.get(iterator.next());
            float distance = this.world.nature.getDistance(element, this);
            if (!(distance < nearest) || !sel.isFiting(element) || !this.personnalVision.isFiting(element)) continue;
            curentNearest = element;
            nearest = distance;
        }
        return curentNearest;
    }
}

