/*
 * Decompiled with CFR 0.152.
 */
package modelling;

import java.awt.Color;
import java.util.Iterator;
import java.util.Vector;
import sema.Area;
import sema.Box;
import sema.Drawing;
import sema.Element;
import sema.Map;

public class PonctualArea
implements Area {
    private float xDrawLength;
    private float yDrawLength;
    private Map map;
    private Element element;
    private Vector intersectedBoxes = new Vector();
    private float x;
    private float y;
    private float angle;
    private float lastX;
    private float lastY;
    private float lastAngle;
    private float lastXlength;
    private float lastYlength;
    private float lastXdraw;
    private float lastYdraw;
    private Vector lastV;

    public PonctualArea(Map map, float x, float y, float angle, float xDrawLength, float yDrawLength) {
        this.lastX = x;
        this.lastY = y;
        this.lastAngle = angle;
        this.lastXdraw = xDrawLength;
        this.lastYdraw = yDrawLength;
        this.x = x;
        this.y = y;
        this.map = map;
        this.refreshBoxes();
        this.lastV = this.getIntersectedBoxes();
        this.xDrawLength = xDrawLength;
        this.yDrawLength = yDrawLength;
        this.angle = angle;
    }

    public Vector getIntersectedBoxes() {
        return this.intersectedBoxes;
    }

    private void registerBoxes() {
        if (this.element != null && this.intersectedBoxes.size() > 0) {
            ((Box)this.intersectedBoxes.get(0)).register(this.element);
        }
    }

    private void unregisterBoxes() {
        if (this.element != null && this.intersectedBoxes.size() > 0) {
            ((Box)this.intersectedBoxes.get(0)).unregister(this.element);
        }
    }

    private Vector computeBoxes() {
        Vector<Box> covering = new Vector<Box>();
        try {
            covering.add(this.map.boxes[(int)Math.floor(this.x / this.map.boxLength)][(int)Math.floor(this.y / this.map.boxLength)]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return covering;
    }

    private void refreshBoxes() {
        this.unregisterBoxes();
        this.intersectedBoxes = this.computeBoxes();
        this.registerBoxes();
    }

    public void setElement(Element el) {
        this.element = el;
        this.refreshBoxes();
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getAngle() {
        return this.angle;
    }

    public boolean isIn(float px, float py) {
        return this.x == px & this.y == py;
    }

    public boolean isCrashingElements() {
        return this.isCrashingElements(this.getIntersectedBoxes());
    }

    public boolean isCrashingElements(Vector v) {
        if (v == null) {
            return true;
        }
        for (int i = 0; i < v.size(); ++i) {
            Box b = (Box)v.get(i);
            if (!b.isFreeFor(this.element)) {
                return true;
            }
            int s = b.getContents().size();
            if (s <= 1 && !(s == 1 & !b.getContents().contains(this.element))) continue;
            return true;
        }
        return false;
    }

    public Vector getPolygon() {
        Vector<float[]> v = new Vector<float[]>();
        float[] p8 = new float[]{this.x, this.y};
        v.add(p8);
        return v;
    }

    public boolean isPolygon() {
        return true;
    }

    private float vectorial(float px, float py, float ax, float ay, float bx, float by) {
        return (ax - px) * (by - py) - (ay - py) * (bx - px);
    }

    public boolean intersect(float ax, float ay, float bx, float by) {
        return false;
    }

    public boolean intersect(Vector p1) {
        return false;
    }

    public boolean intersect(Area a) {
        return a.isIn(this.x, this.y);
    }

    public boolean exactIsCrashingElements() {
        return this.exactIsCrashingElements(this.getIntersectedBoxes());
    }

    public boolean exactIsCrashingElements(Vector v) {
        if (v == null) {
            return true;
        }
        if (v.size() > 0) {
            Box b = (Box)v.get(0);
            if (!b.isFreeFor(this.element)) {
                return true;
            }
            Iterator it = b.getContents().iterator();
            while (it.hasNext()) {
                Element el = (Element)it.next();
                if (el == this.element || !el.getArea().isIn(this.x, this.y)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean translate(float x, float y) {
        float backX = this.x;
        float backY = this.y;
        this.x += x;
        this.y += y;
        if (this.inMap()) {
            this.refreshBoxes();
            return true;
        }
        this.x = backX;
        this.y = backY;
        return false;
    }

    public boolean setX(float x) {
        float backX = this.x;
        this.x = x;
        if (this.inMap()) {
            this.refreshBoxes();
            return true;
        }
        this.x = backX;
        return false;
    }

    public boolean setY(float y) {
        float backY = this.y;
        this.y = y;
        if (this.inMap()) {
            this.refreshBoxes();
            return true;
        }
        this.y = backY;
        return false;
    }

    public Vector simuleTranslate(float x, float y) {
        float backX = this.x;
        float backY = this.y;
        this.x += x;
        this.y += y;
        if (!this.inMap()) {
            this.x = backX;
            this.y = backY;
            this.lastX = this.x;
            this.lastY = this.y;
            this.lastAngle = this.angle;
            this.lastXdraw = this.xDrawLength;
            this.lastYdraw = this.yDrawLength;
            this.lastV = null;
            return null;
        }
        Vector v = this.computeBoxes();
        this.lastX = this.x;
        this.lastY = this.y;
        this.lastAngle = this.angle;
        this.lastXdraw = this.xDrawLength;
        this.lastYdraw = this.yDrawLength;
        this.lastV = v;
        this.x = backX;
        this.y = backY;
        return v;
    }

    public void confirmSimuled() {
        this.x = this.lastX;
        this.y = this.lastY;
        this.angle = this.lastAngle;
        this.xDrawLength = this.lastXdraw;
        this.yDrawLength = this.lastYdraw;
        this.unregisterBoxes();
        this.intersectedBoxes = this.lastV;
        this.registerBoxes();
    }

    private float toZero2PI(float f) {
        double t = Math.IEEEremainder(f, Math.PI * 2);
        if (t < 0.0) {
            return (float)(t + Math.PI * 2);
        }
        return (float)t;
    }

    public boolean rotate(float angle) {
        this.angle = this.toZero2PI(this.angle + angle);
        return true;
    }

    public boolean setAngle(float a) {
        this.angle = this.toZero2PI(a);
        return true;
    }

    public Vector simuleRotate(float angle) {
        this.lastX = this.x;
        this.lastY = this.y;
        this.lastAngle = angle + this.angle;
        this.lastXdraw = this.xDrawLength;
        this.lastYdraw = this.yDrawLength;
        this.lastV = this.intersectedBoxes;
        return this.intersectedBoxes;
    }

    public boolean rescale(float x, float y) {
        return true;
    }

    public Vector simuleRescale(float xS, float yS) {
        this.lastX = this.x;
        this.lastY = this.y;
        this.lastAngle = this.angle;
        this.lastXdraw = this.xDrawLength;
        this.lastYdraw = this.yDrawLength;
        this.lastV = this.intersectedBoxes;
        return this.intersectedBoxes;
    }

    public boolean inMap() {
        return this.x >= 0.0f && this.x <= this.map.xLength & this.y >= 0.0f && this.y < this.map.yLength;
    }

    public void draw(Drawing g) {
        if (this.element != null) {
            g.drawImage(this.element.getImage(), this.x - this.xDrawLength / 2.0f, this.y - this.yDrawLength / 2.0f, this.xDrawLength, this.yDrawLength, this.angle, this.x, this.y);
        }
    }

    public void fill(Drawing g, Color c) {
    }

    public void drawBorder(Drawing g, Color c) {
    }

    public void highlight(Drawing g, Color c) {
        g.setColor(c);
        g.fillRect(this.x - this.xDrawLength / 2.0f, this.y - this.yDrawLength / 2.0f, this.xDrawLength, this.yDrawLength, this.angle, this.x, this.y);
        g.setColor(Color.BLACK);
        g.drawRect(this.x - this.xDrawLength / 2.0f, this.y - this.yDrawLength / 2.0f, this.xDrawLength, this.yDrawLength, this.angle, this.x, this.y);
    }

    public String[][] getProperties() {
        String[][] ret = new String[4][2];
        String[] p1 = new String[]{"x", new Float(this.x).toString()};
        String[] p2 = new String[]{"y", new Float(this.y).toString()};
        String[] p5 = new String[]{"angle (in degrees)", new Float((double)(180.0f * this.angle) / Math.PI).toString()};
        String[] p6 = new String[]{"intersected boxes", new Integer(this.intersectedBoxes.size()).toString()};
        ret[0] = p1;
        ret[1] = p2;
        ret[2] = p5;
        ret[3] = p6;
        return ret;
    }

    public void setProperties(String s1, String s2) {
        try {
            if (s1.equals("x")) {
                this.setX(Float.parseFloat(s2));
            } else if (s1.equals("y")) {
                this.setY(Float.parseFloat(s2));
            } else if (s1.equals("angle (in degrees)")) {
                this.setAngle(Float.parseFloat(s2) / 180.0f * (float)Math.PI);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object clone() {
        return new PonctualArea(this.map, this.x, this.y, this.xDrawLength, this.yDrawLength, this.angle);
    }
}

