/*
 * Decompiled with CFR 0.152.
 */
package modelling;

import java.awt.Image;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import modelling.CircularArea;
import modelling.Pheromone;
import modelling.PonctualArea;
import modelling.Selector;
import sema.Agent;
import sema.Area;
import sema.Element;
import sema.Signal;
import sema.World;

public class PheromoneUserAgent
extends Agent {
    Image pheromoneImage;

    public PheromoneUserAgent(World world, Area area, float delay, Image image, Image pheromoneImage) {
        super(world, area, delay, image);
        this.pheromoneImage = pheromoneImage;
    }

    public void letPheromone(String contents, float during, Selector selector) {
        new Pheromone(this.world, (Area)new PonctualArea(this.world.map, this.getArea().getX(), this.getArea().getY(), 0.1f, 0.1f, 0.0f), this.pheromoneImage, contents, (double)during, selector);
    }

    private Element getNextPheromonae(String contents, float radius) {
        TreeMap elements = this.world.nature.getElements(new CircularArea(this.world.map, this.getArea().getX(), this.getArea().getY(), radius, 0.0f));
        float nextAngle = 721.0f;
        Element curentElement = null;
        Set cles = elements.keySet();
        Iterator iterator = cles.iterator();
        while (iterator.hasNext()) {
            Element ph = (Element)elements.get(iterator);
            if (!ph.getKind().equals("pheromone")) continue;
            Signal pheromone = (Signal)((Object)ph);
            double distance = this.world.nature.getDistance(ph, this);
            float angle = Math.abs(this.getArea().getX() - (float)Math.atan2(ph.getArea().getY() - this.getArea().getY(), ph.getArea().getX() - this.getArea().getX()));
            if (!(angle < nextAngle) || !(distance <= 0.1) || !contents.equals(pheromone.getContents())) continue;
            curentElement = ph;
            nextAngle = angle;
        }
        return curentElement;
    }
}

