/*
 * Decompiled with CFR 0.152.
 */
package modelling;

import java.awt.Image;
import java.util.Vector;
import modelling.RectangularArea;
import sema.Agent;
import sema.Area;
import sema.Box;
import sema.World;

public class MovingAgent
extends Agent {
    private float speed;
    private float stepLength;
    private float stepDelay;

    public MovingAgent(World world, Area area, float delay, Image image, float speed) {
        super(world, area, delay, image);
        this.setSpeed(speed);
        new MoveTo(19.0f, 19.0f, 0.1f);
    }

    protected void setSpeed(float speed) {
        this.speed = speed;
        this.stepLength = Math.min(speed * this.getDelay(), this.world.map.boxLength / 1.5f);
        this.stepDelay = this.stepLength / speed;
    }

    public final float getSpeed() {
        return this.speed;
    }

    protected boolean acceptAction(Agent.Action a) {
        return true;
    }

    protected boolean translate(float x, float y) {
        if (!this.getArea().exactIsCrashingElements(this.getArea().simuleTranslate(x, y))) {
            this.getArea().confirmSimuled();
            return true;
        }
        return false;
    }

    protected boolean rotate(float a) {
        if (!this.getArea().exactIsCrashingElements(this.getArea().simuleRotate(a))) {
            this.getArea().confirmSimuled();
            return true;
        }
        return false;
    }

    protected boolean walk(float f) {
        return this.translate(f * (float)Math.cos(this.getArea().getAngle()), f * (float)Math.sin(this.getArea().getAngle()));
    }

    protected boolean fitStep() {
        float bestAngle = 0.0f;
        float bestDistance = 0.0f;
        for (int i = 0; i < 8; ++i) {
            float d = this.canSee((float)i * (float)Math.PI / 4.0f);
            if (!(d > bestDistance)) continue;
            bestAngle = (float)i * (float)Math.PI / 4.0f;
            bestDistance = d;
        }
        this.rotate(bestAngle - this.getArea().getAngle());
        return this.walk(this.stepLength);
    }

    protected float canSee(float angle) {
        float visionRadius = this.world.map.xLength + this.world.map.xLength;
        float xUp = this.getArea().getX() + visionRadius * (float)Math.cos(angle) / 2.0f;
        float yUp = this.getArea().getY() + visionRadius * (float)Math.sin(angle) / 2.0f;
        RectangularArea a = new RectangularArea(this.world.map, xUp, yUp, visionRadius, 1.0f, angle);
        Vector v = a.getIntersectedBoxes();
        float maxDist = Float.MAX_VALUE;
        float bl = this.world.map.boxLength;
        for (int i = 0; i < v.size(); ++i) {
            Box b = (Box)v.get(i);
            float dist = (float)Math.sqrt(((float)b.x * bl - this.getArea().getX()) * ((float)b.x * bl - this.getArea().getX()) + ((float)b.y * bl - this.getArea().getY()) * ((float)b.y * bl - this.getArea().getY()));
            if (!(dist < maxDist) || b.getContents().size() <= 1 && b.isFreeFor(this) && (b.getContents().size() != 1 || b.getContents().contains(this))) continue;
            maxDist = dist;
        }
        return maxDist;
    }

    protected boolean randomStep(float a) {
        this.rotate((2.0f * (float)Math.random() - 1.0f) * (float)Math.PI / 2.0f - a - this.getArea().getAngle());
        return this.walk((float)Math.random() * this.stepLength);
    }

    protected class MoveTo
    extends Agent.Action {
        protected float a;
        protected float x;
        protected float y;
        protected float radius;
        protected int successiveFailures;

        public MoveTo(float x, float y, float radius) {
            super(MovingAgent.this);
            this.a = 0.0f;
            this.successiveFailures = 0;
            this.x = x;
            this.y = y;
            this.radius = radius;
        }

        public float step() {
            float ymove;
            this.a = (float)Math.atan2(this.y - MovingAgent.this.getArea().getY(), this.x - MovingAgent.this.getArea().getX());
            if (Math.random() / (double)(1 + this.successiveFailures) < 0.1) {
                if (MovingAgent.this.randomStep(this.a)) {
                    // empty if block
                }
                --this.successiveFailures;
                if (this.successiveFailures < 0) {
                    this.successiveFailures = 0;
                }
                return MovingAgent.this.stepDelay * (float)Math.max(1 / (1 + this.successiveFailures), 0);
            }
            MovingAgent.this.rotate(this.a - MovingAgent.this.getArea().getAngle());
            float xx = Math.abs(this.x - MovingAgent.this.getArea().getX());
            float yy = Math.abs(this.y - MovingAgent.this.getArea().getY());
            float d = (float)Math.sqrt(xx * xx + yy * yy);
            if (d <= this.radius) {
                return -1.0f;
            }
            float xmove = xx < MovingAgent.this.getSpeed() * MovingAgent.this.getDelay() ? this.x - MovingAgent.this.getArea().getX() : MovingAgent.this.stepLength * (this.x - MovingAgent.this.getArea().getX()) / d;
            float f = ymove = yy < MovingAgent.this.getSpeed() * MovingAgent.this.getDelay() ? this.y - MovingAgent.this.getArea().getY() : MovingAgent.this.stepLength * (this.y - MovingAgent.this.getArea().getY()) / d;
            if (MovingAgent.this.translate(xmove, ymove)) {
                this.successiveFailures /= 2;
            } else {
                ++this.successiveFailures;
                this.a = (float)Math.atan2(this.y - MovingAgent.this.getArea().getY(), this.x - MovingAgent.this.getArea().getX());
            }
            return MovingAgent.this.stepDelay;
        }
    }

    protected class Errer
    extends Agent.Action {
        public Errer() {
            super(MovingAgent.this);
        }

        public Errer(double t) {
            super(MovingAgent.this, t);
        }

        public float step() {
            MovingAgent.this.rotate((float)Math.random());
            MovingAgent.this.walk(MovingAgent.this.stepLength);
            return MovingAgent.this.getDelay();
        }
    }
}

