/*
 * Decompiled with CFR 0.152.
 */
package modelling;

import java.awt.Image;
import sema.Agent;
import sema.Area;
import sema.World;

public class GrowingAgent
extends Agent {
    protected Growing growing;

    public GrowingAgent(World world, Area area, float delay, Image image, float reachableSize, float timeToGrow) {
        super(world, area, delay, image);
        this.growing = new Growing(reachableSize, timeToGrow);
    }

    protected class Growing
    extends Agent.Action {
        private float size;
        public final float reachableSize;
        public final float timeToGrow;

        public Growing(float reachableSize, float timeToGrow) {
            super(GrowingAgent.this, timeToGrow);
            this.size = 1.0f;
            this.reachableSize = reachableSize;
            this.timeToGrow = timeToGrow;
        }

        public float getSize() {
            return this.size;
        }

        protected boolean rescaleSize(float a) {
            if (this.size * a <= this.reachableSize) {
                this.size *= a;
                GrowingAgent.this.getArea().rescale(a, a);
                return true;
            }
            return false;
        }

        protected float step() {
            if (this.rescaleSize(1.1f)) {
                return this.timeToGrow;
            }
            return -1.0f;
        }
    }
}

