/*
 * Decompiled with CFR 0.152.
 */
package modelling;

import java.awt.Image;
import modelling.Eatable;
import modelling.Satisfactor;
import sema.Agent;
import sema.Area;
import sema.Element;
import sema.World;

public class EatingAgent
extends Agent {
    protected IsHungry hungrylevel = new IsHungry(10.0f, 0.0f, 30.0f);
    protected Consuming consomption = new Consuming(60.0f, 3.0f);

    public EatingAgent(World world, Area area, float delay, Image image) {
        super(world, area, delay, image);
    }

    protected IsHungry getHungryLevel() {
        return this.hungrylevel;
    }

    protected Agent.Action getConsomption() {
        return this.consomption;
    }

    protected void eat(float x) {
        this.hungrylevel.changeHunger(x);
    }

    protected void consums(float x) {
        this.hungrylevel.changeHunger(-x);
    }

    protected class EatElement
    extends Agent.Action {
        protected Element goal;

        public EatElement(Element goal) {
            super(EatingAgent.this);
            this.goal = goal;
        }

        protected float step() {
            if (EatingAgent.this.world.nature.getDistance(EatingAgent.this, this.goal) > 2.0f && !EatingAgent.this.getHungryLevel().isSatisfying()) {
                return -1.0f;
            }
            try {
                Eatable a = (Eatable)((Object)this.goal);
                if (a.canEat(EatingAgent.this)) {
                    EatingAgent.this.getHungryLevel().changeHunger(a.eaten(EatingAgent.this));
                }
                return (float)Math.random() * 10.0f;
            }
            catch (Exception e) {
                return -1.0f;
            }
        }
    }

    protected class Consuming
    extends Agent.Action {
        private float delay;
        private float among;

        public Consuming(float delay, float among) {
            super(EatingAgent.this, Math.random() * 20.0);
            this.delay = delay;
            this.among = among;
        }

        protected float step() {
            EatingAgent.this.getHungryLevel().changeHunger(this.delay);
            return this.among;
        }
    }

    protected class IsHungry
    extends Satisfactor {
        protected float hunger;
        protected float hungryFloor;
        protected float hungryCeil;
        protected boolean unfiniteHungry;

        public IsHungry(float hunger, float hungryFloor, float hungryCeil) {
            this.hunger = hunger;
            this.hungryFloor = hungryFloor;
            this.hungryCeil = hungryCeil;
            this.unfiniteHungry = false;
        }

        public IsHungry() {
            this.unfiniteHungry = true;
        }

        public boolean isSatisfying() {
            return this.hunger > this.hungryCeil || this.unfiniteHungry;
        }

        public int heuristic() {
            return (int)Math.floor(this.hungryCeil - this.hunger);
        }

        public float getReserves() {
            return this.hunger - this.hungryFloor;
        }

        public void changeHunger(float difference) {
            this.hunger += difference;
        }
    }
}

