/*
 * Decompiled with CFR 0.152.
 */
package modelling;

import java.awt.Color;
import java.util.Iterator;
import java.util.Vector;
import sema.Area;
import sema.Box;
import sema.Drawing;
import sema.Element;
import sema.Map;

public class CircularArea
implements Area {
    private Map map;
    private Element element;
    private float radius;
    private float lastX;
    private float lastY;
    private float lastRadius;
    private Vector lastV;
    private float lastAngle;
    public final float sqr2 = (float)Math.sqrt(2.0);
    public final float sqr2s2 = this.sqr2 / 2.0f;
    private Vector intersectedBoxes = new Vector();
    private float x;
    private float y;
    private float angle;

    public CircularArea(Map map, float x, float y, float radius, float angle) {
        this.x = x;
        this.y = y;
        this.radius = radius;
        this.map = map;
        this.lastX = x;
        this.lastY = y;
        this.lastRadius = radius;
        this.refreshBoxes();
        this.angle = 0.0f;
        this.lastAngle = angle;
        this.lastV = this.intersectedBoxes;
    }

    public Vector getIntersectedBoxes() {
        return this.intersectedBoxes;
    }

    private void registerBoxes() {
        if (this.element != null) {
            for (int i = 0; i < this.intersectedBoxes.size(); ++i) {
                ((Box)this.intersectedBoxes.get(i)).register(this.element);
            }
        }
    }

    private void unregisterBoxes() {
        if (this.element != null) {
            for (int i = 0; i < this.intersectedBoxes.size(); ++i) {
                ((Box)this.intersectedBoxes.get(i)).unregister(this.element);
            }
        }
    }

    private Vector computeBoxes() {
        return this.map.getCoveringBoxes(this.x - this.radius, this.y - this.radius, 2.0f * this.radius, 2.0f * this.radius);
    }

    private void refreshBoxes() {
        this.unregisterBoxes();
        this.intersectedBoxes = this.computeBoxes();
        this.registerBoxes();
    }

    public void setElement(Element el) {
        this.element = el;
        this.refreshBoxes();
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getAngle() {
        return this.angle;
    }

    public boolean isIn(float px, float py) {
        return Math.sqrt((px - this.x) * (px - this.x) + (py - this.y) * (py - this.y)) <= (double)this.radius;
    }

    public boolean isCrashingElements() {
        return this.isCrashingElements(this.getIntersectedBoxes());
    }

    public boolean isCrashingElements(Vector v) {
        if (v == null) {
            return true;
        }
        for (int i = 0; i < v.size(); ++i) {
            Box b = (Box)v.get(i);
            if (!b.isFreeFor(this.element)) {
                return true;
            }
            int s = b.getContents().size();
            if (s <= 1 && !(s == 1 & !b.getContents().contains(this.element))) continue;
            return true;
        }
        return false;
    }

    public boolean isPolygon() {
        return false;
    }

    public Vector getPolygon() {
        Vector<float[]> v = new Vector<float[]>();
        float x1 = this.x + this.radius;
        float y1 = this.y;
        float x2 = this.x + this.radius * this.sqr2s2;
        float y2 = this.y + this.radius * this.sqr2s2;
        float x3 = this.x;
        float y3 = this.y + this.radius;
        float x4 = this.x - this.radius * this.sqr2s2;
        float y4 = this.y + this.radius * this.sqr2s2;
        float x5 = this.x - this.radius;
        float y5 = this.y;
        float x6 = this.x - this.radius * this.sqr2s2;
        float y6 = this.y - this.radius * this.sqr2s2;
        float x7 = this.x;
        float y7 = this.y - this.radius;
        float x8 = this.x + this.radius * this.sqr2s2;
        float y8 = this.y - this.radius * this.sqr2s2;
        float[] p1 = new float[]{x1, y1};
        float[] p2 = new float[]{x2, y2};
        float[] p3 = new float[]{x3, y3};
        float[] p4 = new float[]{x4, y4};
        float[] p5 = new float[]{x5, y5};
        float[] p6 = new float[]{x6, y6};
        float[] p7 = new float[]{x7, y7};
        float[] p8 = new float[]{x8, y8};
        v.add(p1);
        v.add(p2);
        v.add(p3);
        v.add(p4);
        v.add(p5);
        v.add(p6);
        v.add(p7);
        v.add(p8);
        return v;
    }

    private float vectorial(float px, float py, float ax, float ay, float bx, float by) {
        return (ax - px) * (by - py) - (ay - py) * (bx - px);
    }

    public boolean intersect(float ax, float ay, float bx, float by) {
        float d = (float)Math.sqrt((ax - bx) * (ax - bx) + (ay - by) * (ay - by));
        if (this.isIn(ax, ay) || this.isIn(bx, by)) {
            return true;
        }
        if (d > 0.0f) {
            if (Math.abs(this.vectorial(ax, ay, bx, by, this.x, this.y)) <= this.radius * d) {
                float px = this.x + ay - by;
                float py = this.y + bx - ax;
                return this.vectorial(ax, ay, this.x, this.y, px, py) * this.vectorial(bx, by, this.x, this.y, px, py) <= 0.0f;
            }
            return false;
        }
        return false;
    }

    public boolean intersect(Vector p1) {
        int n = p1.size();
        for (int i = 0; i < n - 1; ++i) {
            float by;
            float[] temp2;
            float bx;
            float ay;
            float[] temp = (float[])p1.get(i);
            float ax = temp[0];
            if (!this.intersect(ax, ay = temp[1], bx = (temp2 = (float[])p1.get(i + 1))[0], by = temp2[1])) continue;
            return true;
        }
        if (n > 1) {
            float[] temp = (float[])p1.get(n - 1);
            float ax = temp[0];
            float ay = temp[1];
            float[] temp2 = (float[])p1.get(0);
            float bx = temp2[0];
            float by = temp2[1];
            return this.intersect(ax, ay, bx, by);
        }
        return false;
    }

    public boolean intersect(Area a) {
        return this.intersect(a.getPolygon());
    }

    public boolean exactIsCrashingElements() {
        return this.exactIsCrashingElements(this.getIntersectedBoxes());
    }

    public boolean exactIsCrashingElements(Vector v) {
        if (v == null) {
            return true;
        }
        for (int i = 0; i < v.size(); ++i) {
            Box b = (Box)v.get(i);
            if (!b.isFreeFor(this.element)) {
                return true;
            }
            Iterator it = b.getContents().iterator();
            while (it.hasNext()) {
                Element el = (Element)it.next();
                if (el == this.element || !this.intersect(el.getArea())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean translate(float x, float y) {
        float backX = this.x;
        float backY = this.y;
        this.x += x;
        this.y += y;
        if (this.inMap()) {
            this.refreshBoxes();
            return true;
        }
        this.x = backX;
        this.y = backY;
        return false;
    }

    public boolean setRadius(float r) {
        if (r < 0.0f) {
            return false;
        }
        float backradius = this.radius;
        this.radius = r;
        if (this.inMap()) {
            this.refreshBoxes();
            return true;
        }
        this.radius = backradius;
        return false;
    }

    public boolean setX(float x) {
        float backX = this.x;
        this.x = x;
        if (this.inMap()) {
            this.refreshBoxes();
            return true;
        }
        this.x = backX;
        return false;
    }

    public boolean setY(float y) {
        float backY = this.y;
        this.y = y;
        if (this.inMap()) {
            this.refreshBoxes();
            return true;
        }
        this.y = backY;
        return false;
    }

    public Vector simuleTranslate(float x, float y) {
        float backX = this.x;
        float backY = this.y;
        this.x += x;
        this.y += y;
        if (!this.inMap()) {
            this.x = backX;
            this.y = backY;
            this.lastX = this.x;
            this.lastY = this.y;
            this.lastRadius = this.radius;
            this.lastAngle = this.angle;
            this.lastV = this.intersectedBoxes;
            return null;
        }
        Vector v = this.computeBoxes();
        this.lastX = this.x;
        this.lastY = this.y;
        this.lastRadius = this.radius;
        this.lastAngle = this.angle;
        this.lastV = v;
        this.x = backX;
        this.y = backY;
        return v;
    }

    public void confirmSimuled() {
        this.x = this.lastX;
        this.y = this.lastY;
        this.radius = this.lastRadius;
        this.lastAngle = this.angle;
        this.intersectedBoxes = this.lastV;
        this.x += this.x;
        this.y += this.y;
        this.unregisterBoxes();
        this.intersectedBoxes = this.lastV;
        this.registerBoxes();
    }

    private float toZero2PI(float f) {
        double t = Math.IEEEremainder(f, Math.PI * 2);
        if (t < 0.0) {
            return (float)(t + Math.PI * 2);
        }
        return (float)t;
    }

    public boolean rotate(float angle) {
        float backAngle = this.angle;
        this.angle = this.toZero2PI(this.angle + angle);
        if (this.inMap()) {
            this.refreshBoxes();
            return true;
        }
        this.angle = backAngle;
        return false;
    }

    public boolean setAngle(float a) {
        float backA = this.angle;
        this.angle = this.toZero2PI(a);
        if (this.inMap()) {
            this.refreshBoxes();
            return true;
        }
        this.angle = backA;
        return false;
    }

    public Vector simuleRotate(float angle) {
        float backAngle = this.angle;
        this.angle = this.toZero2PI(this.angle + angle);
        Vector v = this.computeBoxes();
        this.lastX = this.x;
        this.lastY = this.y;
        this.lastAngle = this.angle;
        this.lastRadius = this.radius;
        this.lastV = v;
        this.angle = backAngle;
        return v;
    }

    public boolean rescale(float x, float y) {
        float backRadius = this.radius;
        this.radius = this.radius * (x + y) / 2.0f;
        if (this.inMap()) {
            this.refreshBoxes();
            return true;
        }
        this.radius = backRadius;
        return false;
    }

    public Vector simuleRescale(float xS, float yS) {
        float backRadius = this.radius;
        this.radius = this.radius * (xS + yS) / 2.0f;
        if (!this.inMap()) {
            return null;
        }
        Vector v = this.computeBoxes();
        if (!this.inMap()) {
            this.radius = backRadius;
            this.lastX = this.x;
            this.lastY = this.y;
            this.lastRadius = this.radius;
            this.lastAngle = this.angle;
            this.lastV = this.intersectedBoxes;
            return null;
        }
        this.lastX = this.x;
        this.lastY = this.y;
        this.lastRadius = this.radius;
        this.lastV = v;
        this.lastAngle = this.angle;
        this.radius = backRadius;
        return v;
    }

    public boolean inMap() {
        return this.x >= this.radius && this.x <= this.map.xLength - this.radius & this.y >= this.radius && this.y <= this.map.yLength - this.radius;
    }

    public void draw(Drawing g) {
        g.setColor(Color.WHITE);
        g.fillCircle(this.x, this.y, this.radius);
        g.setColor(Color.BLACK);
        if (this.element != null) {
            g.drawImage(this.element.getImage(), this.x - this.radius * this.sqr2s2, this.y - this.radius * this.sqr2s2, this.radius * this.sqr2, this.radius * this.sqr2, this.angle, this.x, this.y);
        }
        g.drawCircle(this.x, this.y, this.radius);
    }

    public void fill(Drawing g, Color c) {
        g.setColor(c);
        g.fillCircle(this.x, this.y, this.radius);
    }

    public void drawBorder(Drawing g, Color c) {
        g.setColor(c);
        g.drawCircle(this.x, this.y, this.radius);
    }

    public void highlight(Drawing g, Color c) {
        g.setColor(c);
        g.fillCircle(this.x, this.y, this.radius);
        g.setColor(Color.BLACK);
        g.drawCircle(this.x, this.y, this.radius);
    }

    public String[][] getProperties() {
        String[][] ret = new String[5][2];
        String[] p1 = new String[]{"x", new Float(this.x).toString()};
        String[] p2 = new String[]{"y", new Float(this.y).toString()};
        String[] p4 = new String[]{"radius", new Float(this.radius).toString()};
        String[] p5 = new String[]{"angle (in degrees)", new Float((double)(180.0f * this.angle) / Math.PI).toString()};
        String[] p6 = new String[]{"intersected boxes", new Integer(this.intersectedBoxes.size()).toString()};
        ret[0] = p1;
        ret[1] = p2;
        ret[2] = p4;
        ret[3] = p5;
        ret[4] = p6;
        return ret;
    }

    public void setProperties(String s1, String s2) {
        try {
            if (s1.equals("x")) {
                this.setX(Float.parseFloat(s2));
            } else if (s1.equals("y")) {
                this.setY(Float.parseFloat(s2));
            } else if (s1.equals("radius")) {
                this.setRadius(Float.parseFloat(s2));
            } else if (s1.equals("angle (in degrees)")) {
                this.setAngle(Float.parseFloat(s2) / 180.0f * (float)Math.PI);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object clone() {
        return new CircularArea(this.map, this.x, this.y, this.radius, this.angle);
    }
}

