/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.awt.Color;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import sema.Area;
import sema.Box;
import sema.Drawing;
import sema.Element;
import sema.Map;

public class RectangularArea2
implements Area,
Cloneable {
    private Map map;
    private Element element;
    private float x;
    private float y;
    private float lastX;
    private float lastY;
    private float lastAngle;
    private float lastXlength;
    private float lastYlength;
    private float lastX0t;
    private float lastY0t;
    private Vector lastV;
    private float angle;
    private float x_length;
    private float y_length;
    private float x0_t;
    private float y0_t;
    private float x0;
    private float y0;
    private float cos;
    private float sin;
    private final float boxLength;
    private final int xBoxes;
    private final int yBoxes;
    private final Box[][] boxes;
    private final float xmax;
    private final float ymax;
    private Vector intersectedBoxes = new Vector();

    public RectangularArea2(Map map, float x, float y, float x_length, float y_length) {
        this(map, x, y, x_length, y_length, 0.0f, -x_length / 2.0f, -y_length / 2.0f);
    }

    public RectangularArea2(Map map, float x, float y, float x_length, float y_length, float angle) {
        this(map, x, y, x_length, y_length, angle, -x_length / 2.0f, -y_length / 2.0f);
    }

    public RectangularArea2(Map map, float x, float y, float x_length, float y_length, float angle, float x0_t, float y0_t) {
        this.x = x;
        this.y = y;
        this.x0_t = x0_t;
        this.y0_t = y0_t;
        this.x_length = x_length;
        this.y_length = y_length;
        this.angle = angle;
        this.map = map;
        this.boxLength = map.boxLength;
        this.xBoxes = map.xBoxes;
        this.yBoxes = map.yBoxes;
        this.boxes = map.boxes;
        this.xmax = map.xLength;
        this.ymax = map.yLength;
        this.lastX = x;
        this.lastY = y;
        this.lastX0t = x0_t;
        this.lastY0t = y0_t;
        this.lastAngle = angle;
        this.lastXlength = x_length;
        this.lastYlength = y_length;
        this.refreshValues();
        this.refreshIntersectedBoxes();
        this.lastV = this.getIntersectedBoxes();
    }

    private void refreshValues() {
        this.cos = (float)Math.cos(this.angle);
        this.sin = (float)Math.sin(this.angle);
        this.x0 = this.x0_t + this.x;
        this.y0 = this.y0_t + this.y;
    }

    public void setElement(Element el) {
        this.element = el;
        this.refreshIntersectedBoxes();
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getAngle() {
        return this.angle;
    }

    private void registerBoxes() {
        if (this.element != null) {
            for (int i = 0; i < this.intersectedBoxes.size(); ++i) {
                ((Box)this.intersectedBoxes.get(i)).register(this.element);
            }
        }
    }

    private void unregisterBoxes() {
        if (this.element != null) {
            for (int i = 0; i < this.intersectedBoxes.size(); ++i) {
                ((Box)this.intersectedBoxes.get(i)).unregister(this.element);
            }
        }
    }

    private Vector getCoveringBoxes() {
        float ytemp;
        float xtemp;
        TreeMap<Integer, Box> covering = new TreeMap<Integer, Box>();
        float x1 = this.cos * (this.x0 - this.x) - this.sin * (this.y0 - this.y) + this.x;
        float y1 = this.cos * (this.y0 - this.y) + this.sin * (this.x0 - this.x) + this.y;
        float x2 = this.cos * (this.x0 + this.x_length - this.x) - this.sin * (this.y0 - this.y) + this.x;
        float y2 = this.cos * (this.y0 - this.y) + this.sin * (this.x0 + this.x_length - this.x) + this.y;
        float x3 = this.cos * (this.x0 - this.x) - this.sin * (this.y0 + this.y_length - this.y) + this.x;
        float y3 = this.cos * (this.y0 + this.y_length - this.y) + this.sin * (this.x0 - this.x) + this.y;
        float x4 = this.cos * (this.x0 + this.x_length - this.x) - this.sin * (this.y0 + this.y_length - this.y) + this.x;
        float y4 = this.cos * (this.y0 + this.y_length - this.y) + this.sin * (this.x0 + this.x_length - this.x) + this.y;
        float ymin = 0.0f;
        float ymax = 0.0f;
        if (this.angle >= 0.0f & (double)this.angle <= 1.5707963267948966) {
            xtemp = x1;
            ytemp = y1;
            x1 = x3;
            y1 = y3;
            x3 = x4;
            y3 = y4;
            x4 = x2;
            y4 = y2;
            x2 = xtemp;
            y2 = ytemp;
        } else if ((double)this.angle > 1.5707963267948966 & (double)this.angle <= Math.PI) {
            xtemp = x1;
            ytemp = y1;
            x1 = x4;
            y1 = y4;
            x4 = xtemp;
            y4 = ytemp;
            xtemp = x2;
            ytemp = y2;
            x2 = x3;
            y2 = y3;
            x3 = xtemp;
            y3 = ytemp;
        } else if ((double)this.angle > Math.PI & (double)this.angle <= 4.71238898038469) {
            xtemp = x1;
            ytemp = y1;
            x1 = x2;
            y1 = y2;
            x2 = x4;
            y2 = y4;
            x4 = x3;
            y4 = y3;
            x3 = xtemp;
            y3 = ytemp;
        }
        int imin = (int)Math.max(Math.ceil(x1 / this.boxLength), 0.0);
        double imax = Math.min(Math.floor(x4 / this.boxLength), (double)(this.xBoxes - 1));
        int i = imin;
        while ((double)i <= imax) {
            ymin = (float)i * this.boxLength <= x2 ? y1 + (y2 - y1) * ((float)i * this.boxLength - x1) / (x2 - x1) : y2 + (y4 - y2) * ((float)i * this.boxLength - x2) / (x4 - x2);
            ymax = (float)i * this.boxLength <= x3 ? y1 + (y3 - y1) * ((float)i * this.boxLength - x1) / (x3 - x1) : y3 + (y4 - y3) * ((float)i * this.boxLength - x3) / (x4 - x3);
            int jmin = (int)Math.max(Math.floor(ymin / this.boxLength), 0.0);
            double jmax = Math.min(Math.floor(ymax / this.boxLength), (double)(this.yBoxes - 1));
            int j = jmin;
            while ((double)j <= jmax) {
                try {
                    covering.put(new Integer(i * this.yBoxes + j), this.boxes[i][j]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        int jmin = (int)Math.max(Math.ceil(y2 / this.boxLength), 1.0);
        double jmax = Math.min(Math.floor(y3 / this.boxLength), (double)this.yBoxes);
        int j = jmin;
        while ((double)j <= jmax) {
            int i2;
            float xmin = 0.0f;
            if ((float)j * this.boxLength <= y1) {
                xmin = x1 + ((float)j * this.boxLength - y1) / (y2 - y1) * (x2 - x1);
                i2 = (int)Math.floor(xmin / this.boxLength);
                try {
                    covering.put(new Integer(i2 * this.yBoxes + j - 1), this.boxes[i2][j - 1]);
                }
                catch (Exception e) {}
            } else {
                xmin = x1 + ((float)j * this.boxLength - y1) / (y3 - y1) * (x3 - x1);
                i2 = (int)Math.floor(xmin / this.boxLength);
                if (j < this.yBoxes) {
                    try {
                        covering.put(new Integer(i2 * this.yBoxes + j), this.boxes[i2][j]);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            ++j;
        }
        try {
            covering.put(new Integer((int)Math.floor(x1 / this.boxLength) * this.yBoxes + (int)(y1 / this.boxLength)), this.boxes[(int)(x1 / this.boxLength)][(int)(y1 / this.boxLength)]);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            covering.put(new Integer((int)Math.floor(x2 / this.boxLength) * this.yBoxes + (int)(y2 / this.boxLength)), this.boxes[(int)(x2 / this.boxLength)][(int)(y2 / this.boxLength)]);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            covering.put(new Integer((int)Math.floor(x3 / this.boxLength) * this.yBoxes + (int)(y3 / this.boxLength)), this.boxes[(int)(x3 / this.boxLength)][(int)(y3 / this.boxLength)]);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            covering.put(new Integer((int)Math.floor(x4 / this.boxLength) * this.yBoxes + (int)(y4 / this.boxLength)), this.boxes[(int)(x4 / this.boxLength)][(int)(y4 / this.boxLength)]);
        }
        catch (Exception e) {
            // empty catch block
        }
        Vector<Object> v = new Vector<Object>();
        Object key = null;
        Object o = null;
        try {
            key = covering.firstKey();
        }
        catch (Exception e) {
            key = null;
        }
        while (key != null) {
            o = covering.remove(key);
            if (o != null) {
                v.add(o);
            }
            try {
                key = covering.firstKey();
            }
            catch (Exception e) {
                key = null;
            }
        }
        return v;
    }

    private Vector computeIntersectedBoxes() {
        if (this.angle == 0.0f) {
            return this.map.getCoveringBoxes(this.x0, this.y0, this.x_length, this.y_length);
        }
        if ((double)this.angle == 4.71238898038469) {
            return this.map.getCoveringBoxes(this.x + this.y0 - this.y, this.y - this.x_length - this.x0 + this.x, this.y_length, this.x_length);
        }
        if ((double)this.angle == Math.PI) {
            return this.map.getCoveringBoxes(this.x + (this.x - this.x0) - this.x_length, this.y + (this.y - this.y0) - this.y_length, this.x_length, this.y_length);
        }
        if ((double)this.angle == 1.5707963267948966) {
            return this.map.getCoveringBoxes(this.x - this.y0 + this.y - this.y_length, this.y + this.x0 - this.x, this.y_length, this.x_length);
        }
        return this.getCoveringBoxes();
    }

    private void refreshIntersectedBoxes() {
        this.unregisterBoxes();
        this.intersectedBoxes = this.computeIntersectedBoxes();
        this.registerBoxes();
    }

    public Vector getIntersectedBoxes() {
        return this.intersectedBoxes;
    }

    private float vectorial(float px, float py, float ax, float ay, float bx, float by) {
        return (ax - px) * (by - py) - (ay - py) * (bx - px);
    }

    public boolean isIn(float px, float py) {
        float x1 = this.cos * (this.x0 - this.x) - this.sin * (this.y0 - this.y) + this.x;
        float y1 = this.cos * (this.y0 - this.y) + this.sin * (this.x0 - this.x) + this.y;
        float x2 = this.cos * (this.x0 + this.x_length - this.x) - this.sin * (this.y0 - this.y) + this.x;
        float y2 = this.cos * (this.y0 - this.y) + this.sin * (this.x0 + this.x_length - this.x) + this.y;
        float x3 = this.cos * (this.x0 - this.x) - this.sin * (this.y0 + this.y_length - this.y) + this.x;
        float y3 = this.cos * (this.y0 + this.y_length - this.y) + this.sin * (this.x0 - this.x) + this.y;
        float x4 = this.cos * (this.x0 + this.x_length - this.x) - this.sin * (this.y0 + this.y_length - this.y) + this.x;
        float y4 = this.cos * (this.y0 + this.y_length - this.y) + this.sin * (this.x0 + this.x_length - this.x) + this.y;
        boolean result = this.vectorial(px, py, x1, y1, x2, y2) * this.vectorial(px, py, x3, y3, x4, y4) <= 0.0f & this.vectorial(px, py, x1, y1, x3, y3) * this.vectorial(px, py, x2, y2, x4, y4) <= 0.0f;
        return result;
    }

    public boolean isCrashingElements() {
        return this.isCrashingElements(this.computeIntersectedBoxes());
    }

    public boolean isCrashingElements(Vector v) {
        if (v == null) {
            return true;
        }
        for (int i = 0; i < v.size(); ++i) {
            Box b = (Box)v.get(i);
            if (!b.isFreeFor(this.element)) {
                return true;
            }
            int s = b.getContents().size();
            if (s <= 1 && !(s == 1 & !b.getContents().contains(this.element))) continue;
            return true;
        }
        return false;
    }

    public Vector getPolygon() {
        Vector<float[]> v = new Vector<float[]>();
        float x1 = this.cos * (this.x0 - this.x) - this.sin * (this.y0 - this.y) + this.x;
        float y1 = this.cos * (this.y0 - this.y) + this.sin * (this.x0 - this.x) + this.y;
        float x2 = this.cos * (this.x0 + this.x_length - this.x) - this.sin * (this.y0 - this.y) + this.x;
        float y2 = this.cos * (this.y0 - this.y) + this.sin * (this.x0 + this.x_length - this.x) + this.y;
        float x3 = this.cos * (this.x0 - this.x) - this.sin * (this.y0 + this.y_length - this.y) + this.x;
        float y3 = this.cos * (this.y0 + this.y_length - this.y) + this.sin * (this.x0 - this.x) + this.y;
        float x4 = this.cos * (this.x0 + this.x_length - this.x) - this.sin * (this.y0 + this.y_length - this.y) + this.x;
        float y4 = this.cos * (this.y0 + this.y_length - this.y) + this.sin * (this.x0 + this.x_length - this.x) + this.y;
        float[] p1 = new float[]{x1, y1};
        float[] p2 = new float[]{x2, y2};
        float[] p3 = new float[]{x3, y3};
        float[] p4 = new float[]{x4, y4};
        v.add(p1);
        v.add(p2);
        v.add(p4);
        v.add(p3);
        return v;
    }

    public boolean isPolygon() {
        return true;
    }

    public boolean intersect(float ax, float ay, float bx, float by) {
        float x1 = this.cos * (this.x0 - this.x) - this.sin * (this.y0 - this.y) + this.x;
        float y1 = this.cos * (this.y0 - this.y) + this.sin * (this.x0 - this.x) + this.y;
        float x2 = this.cos * (this.x0 + this.x_length - this.x) - this.sin * (this.y0 - this.y) + this.x;
        float y2 = this.cos * (this.y0 - this.y) + this.sin * (this.x0 + this.x_length - this.x) + this.y;
        float x3 = this.cos * (this.x0 - this.x) - this.sin * (this.y0 + this.y_length - this.y) + this.x;
        float y3 = this.cos * (this.y0 + this.y_length - this.y) + this.sin * (this.x0 - this.x) + this.y;
        float x4 = this.cos * (this.x0 + this.x_length - this.x) - this.sin * (this.y0 + this.y_length - this.y) + this.x;
        float y4 = this.cos * (this.y0 + this.y_length - this.y) + this.sin * (this.x0 + this.x_length - this.x) + this.y;
        return this.vectorial(ax, ay, x1, y1, x2, y2) * this.vectorial(bx, by, x1, y1, x2, y2) <= 0.0f && this.vectorial(x1, y1, ax, ay, bx, by) * this.vectorial(x2, y2, ax, ay, bx, by) <= 0.0f || this.vectorial(ax, ay, x2, y2, x3, y3) * this.vectorial(bx, by, x2, y2, x3, y3) <= 0.0f && this.vectorial(x2, y2, ax, ay, bx, by) * this.vectorial(x3, y3, ax, ay, bx, by) <= 0.0f || this.vectorial(ax, ay, x3, y3, x4, y4) * this.vectorial(bx, by, x3, y3, x4, y4) <= 0.0f && this.vectorial(x3, y3, ax, ay, bx, by) * this.vectorial(x4, y4, ax, ay, bx, by) <= 0.0f || this.vectorial(ax, ay, x4, y4, x1, y1) * this.vectorial(bx, by, x4, y4, x1, y1) <= 0.0f && this.vectorial(x4, y4, ax, ay, bx, by) * this.vectorial(x1, y1, ax, ay, bx, by) <= 0.0f;
    }

    public boolean intersect(Vector p1) {
        float x1 = this.cos * (this.x0 - this.x) - this.sin * (this.y0 - this.y) + this.x;
        float y1 = this.cos * (this.y0 - this.y) + this.sin * (this.x0 - this.x) + this.y;
        float x2 = this.cos * (this.x0 + this.x_length - this.x) - this.sin * (this.y0 - this.y) + this.x;
        float y2 = this.cos * (this.y0 - this.y) + this.sin * (this.x0 + this.x_length - this.x) + this.y;
        float x3 = this.cos * (this.x0 - this.x) - this.sin * (this.y0 + this.y_length - this.y) + this.x;
        float y3 = this.cos * (this.y0 + this.y_length - this.y) + this.sin * (this.x0 - this.x) + this.y;
        float x4 = this.cos * (this.x0 + this.x_length - this.x) - this.sin * (this.y0 + this.y_length - this.y) + this.x;
        float y4 = this.cos * (this.y0 + this.y_length - this.y) + this.sin * (this.x0 + this.x_length - this.x) + this.y;
        int n = p1.size();
        for (int i = 0; i < n - 1; ++i) {
            float[] temp = (float[])p1.get(i);
            float ax = temp[0];
            float ay = temp[1];
            float[] temp2 = (float[])p1.get(i + 1);
            float bx = temp2[0];
            float by = temp2[1];
            if (!(this.vectorial(ax, ay, x1, y1, x2, y2) * this.vectorial(bx, by, x1, y1, x2, y2) <= 0.0f && this.vectorial(x1, y1, ax, ay, bx, by) * this.vectorial(x2, y2, ax, ay, bx, by) <= 0.0f || this.vectorial(ax, ay, x2, y2, x3, y3) * this.vectorial(bx, by, x2, y2, x3, y3) <= 0.0f && this.vectorial(x2, y2, ax, ay, bx, by) * this.vectorial(x3, y3, ax, ay, bx, by) <= 0.0f || this.vectorial(ax, ay, x3, y3, x4, y4) * this.vectorial(bx, by, x3, y3, x4, y4) <= 0.0f && this.vectorial(x3, y3, ax, ay, bx, by) * this.vectorial(x4, y4, ax, ay, bx, by) <= 0.0f) && (!(this.vectorial(ax, ay, x4, y4, x1, y1) * this.vectorial(bx, by, x4, y4, x1, y1) <= 0.0f) || !(this.vectorial(x4, y4, ax, ay, bx, by) * this.vectorial(x1, y1, ax, ay, bx, by) <= 0.0f))) continue;
            return true;
        }
        if (n > 1) {
            float[] temp = (float[])p1.get(n - 1);
            float ax = temp[0];
            float ay = temp[1];
            float[] temp2 = (float[])p1.get(0);
            float bx = temp2[0];
            float by = temp2[1];
            return this.vectorial(ax, ay, x1, y1, x2, y2) * this.vectorial(bx, by, x1, y1, x2, y2) <= 0.0f && this.vectorial(x1, y1, ax, ay, bx, by) * this.vectorial(x2, y2, ax, ay, bx, by) <= 0.0f || this.vectorial(ax, ay, x2, y2, x3, y3) * this.vectorial(bx, by, x2, y2, x3, y3) <= 0.0f && this.vectorial(x2, y2, ax, ay, bx, by) * this.vectorial(x3, y3, ax, ay, bx, by) <= 0.0f || this.vectorial(ax, ay, x3, y3, x4, y4) * this.vectorial(bx, by, x3, y3, x4, y4) <= 0.0f && this.vectorial(x3, y3, ax, ay, bx, by) * this.vectorial(x4, y4, ax, ay, bx, by) <= 0.0f || this.vectorial(ax, ay, x4, y4, x1, y1) * this.vectorial(bx, by, x4, y4, x1, y1) <= 0.0f && this.vectorial(x4, y4, ax, ay, bx, by) * this.vectorial(x1, y1, ax, ay, bx, by) <= 0.0f;
        }
        return false;
    }

    public boolean intersect(Area a) {
        return a.intersect(this.getPolygon());
    }

    public boolean exactIsCrashingElements() {
        return this.exactIsCrashingElements(this.computeIntersectedBoxes());
    }

    public boolean exactIsCrashingElements(Vector v) {
        if (v == null) {
            return true;
        }
        for (int i = 0; i < v.size(); ++i) {
            Box b = (Box)v.get(i);
            if (!b.isFreeFor(this.element)) {
                return true;
            }
            Iterator it = b.getContents().iterator();
            while (it.hasNext()) {
                Element el = (Element)it.next();
                if (el == this.element || !el.getArea().intersect(this)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean translate(float x, float y) {
        float backX = this.x;
        float backY = this.y;
        this.x += x;
        this.y += y;
        this.refreshValues();
        if (this.inMap()) {
            this.refreshIntersectedBoxes();
            return true;
        }
        this.x = backX;
        this.y = backY;
        this.refreshValues();
        return false;
    }

    public boolean setX(float x) {
        float backX = this.x;
        this.x = x;
        this.refreshValues();
        if (this.inMap()) {
            this.refreshIntersectedBoxes();
            return true;
        }
        this.x = backX;
        this.refreshValues();
        return false;
    }

    public boolean setY(float y) {
        float backY = this.y;
        this.y = y;
        this.refreshValues();
        if (this.inMap()) {
            this.refreshIntersectedBoxes();
            return true;
        }
        this.y = backY;
        this.refreshValues();
        return false;
    }

    private void setSimuled(Vector v) {
        this.lastX = this.x;
        this.lastY = this.y;
        this.lastAngle = this.angle;
        this.lastXlength = this.x_length;
        this.lastYlength = this.y_length;
        this.lastX0t = this.x0_t;
        this.lastY0t = this.y0_t;
        this.lastV = v;
    }

    public Vector simuleTranslate(float x, float y) {
        float backX = this.x;
        float backY = this.y;
        this.x += x;
        this.y += y;
        this.refreshValues();
        if (!this.inMap()) {
            this.x = backX;
            this.y = backY;
            this.setSimuled(this.intersectedBoxes);
            this.refreshValues();
            return null;
        }
        Vector v = this.computeIntersectedBoxes();
        this.setSimuled(v);
        this.x = backX;
        this.y = backY;
        this.refreshValues();
        return v;
    }

    public void confirmSimuled() {
        this.x = this.lastX;
        this.y = this.lastY;
        this.angle = this.lastAngle;
        this.x_length = this.lastXlength;
        this.y_length = this.lastYlength;
        this.x0_t = this.lastX0t;
        this.y0_t = this.lastY0t;
        this.unregisterBoxes();
        this.intersectedBoxes = this.lastV;
        this.registerBoxes();
        this.refreshValues();
    }

    private float toZero2PI(float f) {
        double t = Math.IEEEremainder(f, Math.PI * 2);
        if (t < 0.0) {
            return (float)(t + Math.PI * 2);
        }
        return (float)t;
    }

    public boolean rotate(float angle) {
        float backAngle = this.angle;
        this.angle = this.toZero2PI(this.angle + angle);
        this.refreshValues();
        if (this.inMap()) {
            this.refreshIntersectedBoxes();
            return true;
        }
        this.angle = backAngle;
        this.refreshValues();
        return false;
    }

    public boolean setAngle(float a) {
        float backA = this.angle;
        this.angle = this.toZero2PI(a);
        this.refreshValues();
        if (this.inMap()) {
            this.refreshIntersectedBoxes();
            return true;
        }
        this.angle = backA;
        this.refreshValues();
        return false;
    }

    public Vector simuleRotate(float angle) {
        float backAngle = this.angle;
        this.angle = this.toZero2PI(this.angle + angle);
        this.refreshValues();
        if (!this.inMap()) {
            this.angle = backAngle;
            this.setSimuled(this.intersectedBoxes);
            this.refreshValues();
            return null;
        }
        Vector v = this.computeIntersectedBoxes();
        this.setSimuled(v);
        this.angle = backAngle;
        this.refreshValues();
        return v;
    }

    public boolean rescale(float x, float y) {
        float backXl = this.x_length;
        float backYl = this.y_length;
        float backx0t = this.x0_t;
        float backy0t = this.y0_t;
        this.x_length *= x;
        this.y_length *= y;
        this.x0_t *= x;
        this.y0_t *= y;
        this.refreshValues();
        if (this.inMap()) {
            this.refreshIntersectedBoxes();
            return true;
        }
        this.x_length = backXl;
        this.y_length = backYl;
        this.x0_t = backx0t;
        this.y0_t = backy0t;
        this.refreshValues();
        return false;
    }

    public Vector simuleRescale(float xS, float yS) {
        float backXl = this.x_length;
        float backYl = this.y_length;
        float backx0t = this.x0_t;
        float backy0t = this.y0_t;
        this.x_length *= xS;
        this.y_length *= yS;
        this.x0_t *= xS;
        this.y0_t *= yS;
        this.refreshValues();
        if (!this.inMap()) {
            this.x_length = backXl;
            this.y_length = backYl;
            this.x0_t = backx0t;
            this.y0_t = backy0t;
            this.setSimuled(this.intersectedBoxes);
            this.refreshValues();
            return null;
        }
        Vector v = this.computeIntersectedBoxes();
        this.setSimuled(v);
        this.x_length = backXl;
        this.y_length = backYl;
        this.x0_t = backx0t;
        this.y0_t = backy0t;
        this.refreshValues();
        return v;
    }

    public boolean inMap() {
        float x1 = this.cos * (this.x0 - this.x) - this.sin * (this.y0 - this.y) + this.x;
        float y1 = this.cos * (this.y0 - this.y) + this.sin * (this.x0 - this.x) + this.y;
        float x2 = this.cos * (this.x0 + this.x_length - this.x) - this.sin * (this.y0 - this.y) + this.x;
        float y2 = this.cos * (this.y0 - this.y) + this.sin * (this.x0 + this.x_length - this.x) + this.y;
        float x3 = this.cos * (this.x0 - this.x) - this.sin * (this.y0 + this.y_length - this.y) + this.x;
        float y3 = this.cos * (this.y0 + this.y_length - this.y) + this.sin * (this.x0 - this.x) + this.y;
        float x4 = this.cos * (this.x0 + this.x_length - this.x) - this.sin * (this.y0 + this.y_length - this.y) + this.x;
        float y4 = this.cos * (this.y0 + this.y_length - this.y) + this.sin * (this.x0 + this.x_length - this.x) + this.y;
        return x1 >= 0.0f & x2 >= 0.0f & x3 >= 0.0f & x4 >= 0.0f & y1 >= 0.0f & y2 >= 0.0f & y3 >= 0.0f & y4 >= 0.0f & x1 <= this.xmax & x2 <= this.xmax & x3 <= this.xmax & x4 <= this.xmax & y1 <= this.ymax & y2 <= this.ymax & y3 <= this.ymax & y4 <= this.ymax;
    }

    public void draw(Drawing g) {
        if (this.element != null) {
            g.drawImage(this.element.getImage(), this.x0, this.y0, this.x_length, this.y_length, this.angle, this.x, this.y);
        }
    }

    public void fill(Drawing g, Color c) {
        g.setColor(c);
        g.fillRect(this.x0, this.y0, this.x_length, this.y_length, this.angle, this.x, this.y);
    }

    public void drawBorder(Drawing g, Color c) {
        g.setColor(c);
        g.drawRect(this.x0, this.y0, this.x_length, this.y_length, this.angle, this.x, this.y);
    }

    public void highlight(Drawing g, Color c) {
        g.setColor(c);
        g.fillRect(this.x0, this.y0, this.x_length, this.y_length, this.angle, this.x, this.y);
        g.setColor(Color.BLACK);
        g.drawRect(this.x0, this.y0, this.x_length, this.y_length, this.angle, this.x, this.y);
    }

    public String[][] getProperties() {
        String[][] ret = new String[6][2];
        String[] p1 = new String[]{"x", new Float(this.x).toString()};
        String[] p2 = new String[]{"y", new Float(this.y).toString()};
        String[] p3 = new String[]{"x_length", new Float(this.x_length).toString()};
        String[] p4 = new String[]{"y_length", new Float(this.y_length).toString()};
        String[] p5 = new String[]{"angle (in degrees)", new Float((double)(180.0f * this.angle) / Math.PI).toString()};
        String[] p6 = new String[]{"intersected boxes", new Integer(this.intersectedBoxes.size()).toString()};
        ret[0] = p1;
        ret[1] = p2;
        ret[2] = p3;
        ret[3] = p4;
        ret[4] = p5;
        ret[5] = p6;
        return ret;
    }

    public void setProperties(String s1, String s2) {
        try {
            if (s1.equals("x")) {
                this.setX(Float.parseFloat(s2));
            } else if (s1.equals("y")) {
                this.setY(Float.parseFloat(s2));
            } else if (s1.equals("x_length")) {
                this.rescale(Float.parseFloat(s2) / this.x_length, 1.0f);
            } else if (s1.equals("y_length")) {
                this.rescale(1.0f, Float.parseFloat(s2) / this.y_length);
            } else if (s1.equals("angle (in degrees)")) {
                this.setAngle(Float.parseFloat(s2) / 180.0f * (float)Math.PI);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object clone() {
        return new RectangularArea2(this.map, this.x, this.y, this.x_length, this.y_length, this.angle, this.x0_t, this.y0_t);
    }
}

