/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.awt.Image;
import java.util.Iterator;
import java.util.Vector;
import modelling.Selector;
import sema.Agent;
import sema.Area;
import sema.Box;
import sema.Element;
import sema.World;

public class MovingAgent3
extends Agent {
    private float speed;
    private float stepLength;
    protected float stepDelay;
    protected Selector compatibleElements;

    public MovingAgent3(World world, Area area, float delay, Image image, float speed) {
        this(world, area, delay, image, speed, new AllElements());
    }

    public MovingAgent3(World world, Area area, float delay, Image image, float speed, Selector compatibleElements) {
        super(world, area, delay, image);
        this.setSpeed(speed);
        this.compatibleElements = compatibleElements;
    }

    protected void setSpeed(float speed) {
        this.speed = speed;
        this.stepLength = Math.min(speed * this.getDelay(), this.world.map.boxLength / 2.5f);
        this.stepDelay = this.stepLength / speed;
    }

    public final float getSpeed() {
        return this.speed;
    }

    protected boolean acceptAction(Agent.Action a) {
        return true;
    }

    protected boolean isCrashingElements() {
        Vector v = this.getArea().getIntersectedBoxes();
        for (int i = 0; i < v.size(); ++i) {
            Box b = (Box)v.get(i);
            if (!b.isFreeFor(this)) {
                return true;
            }
            Iterator it = b.getContents().iterator();
            while (it.hasNext()) {
                Element a = (Element)it.next();
                if (a == this || this.compatibleElements.isFiting(a)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean translate(float x, float y) {
        if (this.getArea().translate(x, y)) {
            if (this.isCrashingElements() || !this.getArea().inMap()) {
                this.getArea().translate(-x, -y);
            } else {
                return true;
            }
        }
        return false;
    }

    protected boolean rotate(float a) {
        if (this.getArea().rotate(a)) {
            if (this.isCrashingElements() || !this.getArea().inMap()) {
                this.getArea().rotate(-a);
            } else {
                return true;
            }
        }
        return false;
    }

    protected boolean orientate(float x, float y) {
        return this.orientate((float)Math.atan2(y - this.getArea().getY(), x - this.getArea().getX()));
    }

    protected boolean orientate(float a) {
        float backAngle = this.getArea().getAngle();
        if (this.getArea().setAngle(a)) {
            if (this.isCrashingElements() || !this.getArea().inMap()) {
                this.getArea().setAngle(backAngle);
            } else {
                return true;
            }
        }
        return false;
    }

    protected boolean walk() {
        return this.walk(this.stepLength);
    }

    protected boolean walk(float f) {
        return this.walk(f, this.getArea().getAngle());
    }

    protected boolean walk(float f, float a) {
        if (this.translate(f * (float)Math.cos(a), f * (float)Math.sin(a))) {
            return true;
        }
        return this.randomStep();
    }

    protected boolean randomStep() {
        float f = this.stepLength;
        float a = (float)(Math.PI * 2 * Math.random());
        if (this.translate(f * (float)Math.cos(a), f * (float)Math.sin(a))) {
            this.orientate(a);
            return true;
        }
        return false;
    }

    protected class MoveToRandomGoal
    extends MoveTo {
        public MoveToRandomGoal(float radius) {
            super((float)Math.random() * (MovingAgent3.this.world.map.xLength - 2.0f * radius) + radius, (float)Math.random() * (MovingAgent3.this.world.map.yLength - 2.0f * radius) + radius, radius);
        }

        public float step() {
            if (this.successiveFailures > 5) {
                return -1.0f;
            }
            return super.step();
        }
    }

    protected class MoveToRandomGoals
    extends MoveTo {
        public MoveToRandomGoals(float radius) {
            super((float)Math.random() * (MovingAgent3.this.world.map.xLength - 2.0f * radius) + radius, (float)Math.random() * (MovingAgent3.this.world.map.yLength - 2.0f * radius) + radius, radius);
        }

        public float step() {
            float a = super.step();
            if (this.successiveFailures > 5 || a < 0.0f) {
                a = 0.0f;
                this.x = (float)Math.random() * (MovingAgent3.this.world.map.xLength - 2.0f * this.radius) + this.radius;
                this.y = (float)Math.random() * (MovingAgent3.this.world.map.xLength - 2.0f * this.radius) + this.radius;
                this.successiveFailures = 0;
                this.randomize = false;
                this.failure = false;
                this.b = 0.0f;
                return MovingAgent3.this.getDelay();
            }
            return a;
        }
    }

    protected class MoveTo
    extends Agent.Action {
        protected float a;
        protected float x;
        protected float y;
        protected float radius;
        protected int successiveFailures;
        protected boolean randomize;
        protected boolean failure;
        float b;

        public MoveTo(float x, float y, float radius) {
            super(MovingAgent3.this);
            this.a = 0.0f;
            this.successiveFailures = 0;
            this.randomize = false;
            this.failure = false;
            this.b = 0.0f;
            this.x = x;
            this.y = y;
            this.radius = radius;
            this.start();
        }

        public MoveTo(float x, float y) {
            this(x, y, 0.0f);
        }

        private boolean randomStep() {
            if (!this.randomize) {
                this.b = this.successiveFailures > 4 ? (float)(Math.PI * Math.random() + (double)this.a + 0.7853981633974483) : (Math.random() > 0.5 ? (float)(1.5707963267948966 * Math.random() + (double)this.a + 0.7853981633974483) : (float)(1.5707963267948966 * Math.random() + (double)this.a + 3.9269908169872414));
            }
            if (MovingAgent3.this.walk(MovingAgent3.this.stepLength, this.b)) {
                MovingAgent3.this.rotate(this.b - MovingAgent3.this.getArea().getAngle());
                return true;
            }
            this.randomize = false;
            return false;
        }

        public float step() {
            float ymove;
            this.a = (float)Math.atan2(this.y - MovingAgent3.this.getArea().getY(), this.x - MovingAgent3.this.getArea().getX());
            if (this.failure) {
                if (this.randomStep()) {
                    this.successiveFailures /= 2;
                    if (Math.random() * (double)this.successiveFailures < 4.0) {
                        this.failure = false;
                    }
                    return MovingAgent3.this.stepDelay;
                }
                this.failure = false;
                ++this.successiveFailures;
                return MovingAgent3.this.stepDelay;
            }
            MovingAgent3.this.rotate(this.a - MovingAgent3.this.getArea().getAngle());
            float xx = Math.abs(this.x - MovingAgent3.this.getArea().getX());
            float yy = Math.abs(this.y - MovingAgent3.this.getArea().getY());
            float d = (float)Math.sqrt(xx * xx + yy * yy);
            if (d <= this.radius) {
                return -1.0f;
            }
            float xmove = xx < MovingAgent3.this.stepLength ? this.x - MovingAgent3.this.getArea().getX() : MovingAgent3.this.stepLength * (this.x - MovingAgent3.this.getArea().getX()) / d;
            float f = ymove = yy < MovingAgent3.this.stepLength ? this.y - MovingAgent3.this.getArea().getY() : MovingAgent3.this.stepLength * (this.y - MovingAgent3.this.getArea().getY()) / d;
            if (MovingAgent3.this.translate(xmove, ymove)) {
                this.failure = false;
            } else {
                this.failure = true;
                ++this.successiveFailures;
                this.a = (float)Math.atan2(this.y - MovingAgent3.this.getArea().getY(), this.x - MovingAgent3.this.getArea().getX());
            }
            return MovingAgent3.this.stepDelay;
        }
    }

    protected class Errer
    extends Agent.Action {
        public Errer() {
            super(MovingAgent3.this);
        }

        public Errer(double t) {
            super(MovingAgent3.this, t);
        }

        public float step() {
            MovingAgent3.this.randomStep();
            return MovingAgent3.this.getDelay();
        }
    }

    public static class AllElements
    extends Selector {
        public boolean isFiting(Element e) {
            return true;
        }
    }
}

