/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.CadavreMouton;
import examples.CircularArea2;
import examples.Herbe;
import examples.Loup;
import examples.Message2;
import examples.MovingAgent2;
import java.awt.Color;
import java.awt.Image;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import modelling.Eatable;
import modelling.Receptive;
import modelling.RectangularArea;
import modelling.Satisfactor;
import modelling.Selector;
import sema.Agent;
import sema.Area;
import sema.Element;
import sema.Signal;
import sema.World;

public class Mouton
extends MovingAgent2
implements Receptive {
    protected Image imageCadavre;
    protected Image imageBouffant;
    protected Image imageCourante;
    protected Image imageNormale;
    private Agent.Action currentAction;
    public boolean enEveil = false;
    private Selector isHerbe;
    private Selector personnalVision;
    float visionRadius;
    protected IsHungry hungrylevel;
    protected Consuming consomption;

    public Mouton(World world, Area area, float delay, Image image) {
        super(world, area, delay, image, 3.0f, world.nature.getGoodKind("herbe"));
        this.isHerbe = this.world.nature.getGoodKind("herbe");
        this.visionRadius = 13.0f;
        this.setKind("mouton");
        this.hungrylevel = new IsHungry(10.0f, 0.0f, 30.0f);
        this.consomption = new Consuming(60.0f, 3.0f);
        this.currentAction = new Manger();
        this.imageCadavre = image;
        this.imageBouffant = image;
        this.imageCourante = image;
        this.imageNormale = image;
        this.setCompatibleElements();
        this.setDrawingPriority(5.0f);
    }

    public Mouton(World world, Area area, float delay, Image image, Image imageCadavre) {
        this(world, area, delay, image);
        this.imageCadavre = imageCadavre;
    }

    public Mouton(World world, Area area, float delay, Image image, Image imageCadavre, Image imageBouffant) {
        this(world, area, delay, image);
        this.imageCadavre = imageCadavre;
        this.imageBouffant = imageBouffant;
    }

    public Image getImage() {
        return this.imageCourante;
    }

    public void setCompatibleElements() {
        this.compatibleElements = new PeutEtrePietine();
    }

    protected void setCurrentAction(Agent.Action act) {
        this.currentAction = act;
    }

    protected Agent.Action getCurrentAction() {
        return this.currentAction;
    }

    protected boolean canCatch(Signal sig) {
        return true;
    }

    protected void sigToAction(Signal sig) {
        if (sig.getContents().equals("loup") && !this.enEveil) {
            this.enEveil = true;
            new AttentionAuLoup((double)(this.getDelay() / 2.0f));
        }
        if (sig.getContents().equals("b\u00ea") && !this.enEveil) {
            this.enEveil = true;
            new AttentionAuLoup2((double)(this.getDelay() / 2.0f));
        }
    }

    public void receiveSignal(Signal sig) {
        if (this.canCatch(sig)) {
            this.sigToAction(sig);
        }
    }

    protected float getVisionRadius() {
        return this.visionRadius;
    }

    protected Area getAreaOfVision() {
        float x = this.getArea().getX();
        float y = this.getArea().getY();
        return new RectangularArea(this.world.map, x, y, 2.0f * this.getVisionRadius(), 2.0f * this.getVisionRadius(), this.getArea().getAngle());
    }

    protected Area getLineVision(float angle) {
        float x = (float)((double)this.getArea().getX() + Math.cos(angle) * (double)this.getVisionRadius() / 2.0);
        float y = (float)((double)this.getArea().getY() + Math.sin(angle) * (double)this.getVisionRadius() / 2.0);
        return new RectangularArea(this.world.map, x, y, this.getVisionRadius(), 0.0f, angle);
    }

    public boolean canSee(Element element) {
        return this.personnalVision.isFiting(element) && this.world.nature.getDistance(this, element) < this.getVisionRadius();
    }

    public Vector watch() {
        Vector<Element> seen = new Vector<Element>();
        TreeMap areaOfVision = this.world.nature.getElements(this.getAreaOfVision());
        Set cles = areaOfVision.keySet();
        Iterator iterator = cles.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)areaOfVision.get(iterator.next());
            if (!this.canSee(element)) continue;
            seen.add(element);
        }
        return seen;
    }

    public Element watchNearest() {
        float nearest = Float.MAX_VALUE;
        Element curentNearest = null;
        TreeMap areaOfVision = this.world.nature.getElements(this.getAreaOfVision());
        Set cles = areaOfVision.keySet();
        Iterator iterator = cles.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)areaOfVision.get(iterator.next());
            float distance = this.world.nature.getDistance(element, this);
            if (!(distance < nearest) || !this.personnalVision.isFiting(element)) continue;
            curentNearest = element;
            nearest = distance;
        }
        return curentNearest;
    }

    public Vector watchFor(Selector sel) {
        Vector<Element> seen = new Vector<Element>();
        TreeMap areaOfVision = this.world.nature.getElements(this.getAreaOfVision());
        Set cles = areaOfVision.keySet();
        Iterator iterator = cles.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)areaOfVision.get(iterator.next());
            if (!this.canSee(element) || !sel.isFiting(element)) continue;
            seen.add(element);
        }
        return seen;
    }

    public Element watchForNearest(Selector sel) {
        float nearest = Float.MAX_VALUE;
        Element curentNearest = null;
        TreeMap areaOfVision = this.world.nature.getElements(this.getAreaOfVision());
        Set cles = areaOfVision.keySet();
        Iterator iterator = cles.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)areaOfVision.get(iterator.next());
            float distance = this.world.nature.getDistance(element, this);
            if (!(distance < nearest) || !sel.isFiting(element)) continue;
            curentNearest = element;
            nearest = distance;
        }
        return curentNearest;
    }

    protected IsHungry getHungryLevel() {
        return this.hungrylevel;
    }

    protected Agent.Action getConsomption() {
        return this.consomption;
    }

    protected void eat(float x) {
        this.hungrylevel.changeHunger(x);
    }

    protected void consums(float x) {
        this.hungrylevel.changeHunger(-x);
    }

    public boolean kill(Element el) {
        new CadavreMouton(this.world, new CircularArea2(this.world.map, this.getArea().getX(), this.getArea().getY(), 0.8f, 0.0f), Math.min(this.hungrylevel.hunger, 50.0f), this.imageCadavre);
        super.kill(el);
        return true;
    }

    public String getActivity() {
        this.currentAction.getClass();
        if (this.currentAction.getClass() == Dormir.class) {
            return "Dormir";
        }
        if (this.currentAction.getClass() == Manger.class) {
            return "Chercher de l'herbe";
        }
        if (this.currentAction.getClass() == MoveRandomly.class) {
            return "D\u00e9ambuler";
        }
        if (this.currentAction.getClass() == EatElement.class) {
            return "Brouter";
        }
        if (this.currentAction.getClass() == AttentionAuLoup.class) {
            return "Fuir un loup";
        }
        if (this.currentAction.getClass() == AttentionAuLoup2.class) {
            return "Fuir un loup car un copain a b\u00eal\u00e9";
        }
        return "Je ne sais pas ce que je fais";
    }

    public String[][] getProperties() {
        String[][] ret0 = this.getArea().getProperties();
        String[][] ret = new String[7][2];
        String[] p1 = new String[]{"kind", this.getKind()};
        String[] p2 = new String[]{"Activit\u00e9", this.getActivity()};
        String[] p3 = new String[]{"R\u00e9serves d'\u00e9nergie", new Float(this.hungrylevel.hunger).toString()};
        String[] p4 = new String[]{"Vigilant", new Boolean(this.enEveil).toString()};
        String[] p5 = new String[]{"height", new Float(this.getHeight()).toString()};
        String[] p6 = new String[]{"Drawing priority", new Float(this.getDrawingPriority()).toString()};
        String[] p7 = new String[]{"ID", this.id.toString()};
        ret[0] = p1;
        ret[1] = p2;
        ret[2] = p3;
        ret[3] = p4;
        ret[4] = p5;
        ret[5] = p6;
        ret[6] = p7;
        return Mouton.union(ret0, ret);
    }

    public void setProperties(String property, String value) {
        try {
            this.getArea().setProperties(property, value);
            if (property.equals("height")) {
                this.setHeight(Float.parseFloat(value));
            } else if (property.equals("kind")) {
                this.setKind(value);
            } else if (property.equals("Drawing priority")) {
                float priority = Float.parseFloat(value);
                this.setDrawingPriority(priority);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void draw() {
        this.world.drawing.setColor(Color.BLUE);
        if (this.getCurrentAction().getClass() == Dormir.class) {
            float backA = this.getArea().getAngle();
            this.getArea().setAngle(0.0f);
            super.draw();
            this.getArea().setAngle(backA);
            this.world.drawing.drawString("Zzz", this.getArea().getX(), this.getArea().getY() - 0.5f);
        } else if (this.getCurrentAction().getClass() == Manger.class) {
            super.draw();
            this.world.drawing.drawString("?", this.getArea().getX(), this.getArea().getY() - 0.5f);
        } else if (this.getCurrentAction().getClass() == EatElement.class) {
            float backA = this.getArea().getAngle();
            this.getArea().setAngle(0.0f);
            super.draw();
            this.getArea().setAngle(backA);
            this.world.drawing.drawString("Mmm", this.getArea().getX(), this.getArea().getY() - 0.5f);
        } else if (this.getCurrentAction().getClass() == AttentionAuLoup.class) {
            super.draw();
            this.world.drawing.setColor(Color.RED);
            this.world.drawing.drawString("BEE!!", this.getArea().getX(), this.getArea().getY() - 0.5f);
        } else if (this.getCurrentAction().getClass() == AttentionAuLoup2.class) {
            super.draw();
            this.world.drawing.setColor(Color.RED);
            this.world.drawing.drawString("B\u00ea!", this.getArea().getX(), this.getArea().getY() - 0.5f);
        } else {
            super.draw();
            this.world.drawing.setColor(Color.BLUE);
            this.world.drawing.drawString("...", this.getArea().getX(), this.getArea().getY() - 0.5f);
        }
        if (this.isMarked()) {
            this.getArea().highlight(this.world.drawing, new Color(0.0f, 1.0f, 0.0f, 0.3f));
        }
    }

    public class AttentionAuLoup2
    extends Agent.Action {
        double firstTime;

        public AttentionAuLoup2() {
            super(Mouton.this);
        }

        public AttentionAuLoup2(double t) {
            super(Mouton.this, t);
            this.firstTime = Mouton.this.world.engine.getTime();
        }

        public float firstStep() {
            Mouton.this.enEveil = true;
            try {
                Dormir dodo = (Dormir)Mouton.this.getCurrentAction();
                if (Math.random() > 0.3) {
                    return -1.0f;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            Loup predator = (Loup)Mouton.this.watchForNearest(Mouton.this.world.nature.getGoodKind("loup"));
            if (predator != null) {
                Mouton.this.getCurrentAction().stop();
                Mouton.this.setCurrentAction(this);
                return this.step();
            }
            return -1.0f;
        }

        public float step() {
            if (Mouton.this.world.engine.getTime() - this.firstTime > (double)(5.0f * (float)Math.random() + 8.0f)) {
                Mouton.this.setCurrentAction(new MoveRandomly());
                return -1.0f;
            }
            try {
                Loup predator = (Loup)Mouton.this.watchForNearest(Mouton.this.world.nature.getGoodKind("loup"));
                float distance = Mouton.this.world.nature.getDistance(predator, Mouton.this);
                float x = Mouton.this.getArea().getX() + (0.5f + 0.5f * (float)Math.random()) * (Mouton.this.getArea().getX() - predator.getArea().getX());
                float y = Mouton.this.getArea().getY() + (0.5f + 0.5f * (float)Math.random()) * (Mouton.this.getArea().getY() - predator.getArea().getY());
                Mouton.this.orientate(x, y);
                Mouton.this.walk();
                return Mouton.this.stepDelay / 2.0f;
            }
            catch (Exception e) {
                Mouton.this.setCurrentAction(new MoveRandomly());
                return -1.0f;
            }
        }

        protected void close() {
            Mouton.this.enEveil = false;
        }
    }

    public class AttentionAuLoup
    extends Agent.Action {
        double firstTime;

        public AttentionAuLoup() {
            super(Mouton.this);
        }

        public AttentionAuLoup(double t) {
            super(Mouton.this, t);
            this.firstTime = Mouton.this.world.engine.getTime();
        }

        public float firstStep() {
            Mouton.this.enEveil = true;
            try {
                Dormir dodo = (Dormir)Mouton.this.getCurrentAction();
                if (Math.random() > 0.2) {
                    return -1.0f;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            Loup predator = (Loup)Mouton.this.watchForNearest(Mouton.this.world.nature.getGoodKind("loup"));
            if (predator != null) {
                Mouton.this.getCurrentAction().stop();
                Mouton.this.setCurrentAction(this);
                Mouton.this.world.nature.broadcastSignal(new Message2(Mouton.this.world.map, "b\u00ea", 9.0f, Mouton.this.getArea().getX(), Mouton.this.getArea().getY(), Mouton.this.world.nature.getGoodKind("mouton")));
                return this.step();
            }
            return -1.0f;
        }

        public float step() {
            if (Mouton.this.world.engine.getTime() - this.firstTime > (double)(5.0f * (float)Math.random() + 8.0f)) {
                Mouton.this.setCurrentAction(new MoveRandomly());
                return -1.0f;
            }
            try {
                Loup predator = (Loup)Mouton.this.watchForNearest(Mouton.this.world.nature.getGoodKind("loup"));
                float distance = Mouton.this.world.nature.getDistance(predator, Mouton.this);
                float x = Mouton.this.getArea().getX() + (0.5f + 0.5f * (float)Math.random()) * (Mouton.this.getArea().getX() - predator.getArea().getX());
                float y = Mouton.this.getArea().getY() + (0.5f + 0.5f * (float)Math.random()) * (Mouton.this.getArea().getY() - predator.getArea().getY());
                Mouton.this.orientate(x, y);
                Mouton.this.walk();
                return Mouton.this.stepDelay / 2.0f;
            }
            catch (Exception e) {
                Mouton.this.setCurrentAction(new MoveRandomly());
                return -1.0f;
            }
        }

        protected void close() {
            Mouton.this.enEveil = false;
        }
    }

    public class Dormir
    extends Agent.Action {
        private float dureeDuSommeil;

        public Dormir() {
            super(Mouton.this, Mouton.this.getDelay());
            this.dureeDuSommeil = 0.0f;
        }

        public float step() {
            this.dureeDuSommeil += 100.0f;
            if ((double)this.dureeDuSommeil > 200.0 + 100.0 * Math.random() || Mouton.this.hungrylevel.getReserves() < 0.0f) {
                Mouton.this.setCurrentAction(new Manger());
                return -1.0f;
            }
            return 100.0f;
        }
    }

    public class Manger
    extends Agent.Action {
        public Manger() {
            super(Mouton.this, Mouton.this.getDelay());
        }

        public float step() {
            Herbe herbe = (Herbe)Mouton.this.watchForNearest(Mouton.this.isHerbe);
            if (herbe != null) {
                float distance = Mouton.this.world.nature.getDistance(Mouton.this, herbe);
                if ((double)distance < 0.5) {
                    Mouton.this.imageCourante = Mouton.this.imageBouffant;
                    Mouton.this.setCurrentAction(new EatElement(herbe));
                    return -1.0f;
                }
                float x = herbe.getArea().getX();
                float y = herbe.getArea().getY();
                Mouton.this.orientate(x, y);
                Mouton.this.walk();
                return Mouton.this.stepDelay;
            }
            if (Math.random() > 0.9) {
                Mouton.this.setCurrentAction(new Dormir());
                return -1.0f;
            }
            Mouton.this.setCurrentAction(new MoveRandomly());
            return -1.0f;
        }
    }

    protected class EatElement
    extends Agent.Action {
        protected Element goal;

        public EatElement(Element goal) {
            super(Mouton.this, Mouton.this.getDelay());
            this.goal = goal;
        }

        protected float step() {
            if (Mouton.this.world.nature.getDistance(Mouton.this, this.goal) > 2.0f || Math.random() > 0.85) {
                Mouton.this.setCurrentAction(new MoveRandomly());
                return -1.0f;
            }
            try {
                Eatable a = (Eatable)((Object)this.goal);
                if (a.canEat(Mouton.this)) {
                    Mouton.this.getHungryLevel().changeHunger(a.eaten(Mouton.this) / 3.0f);
                    return (float)Math.random() * 7.0f;
                }
                Mouton.this.setCurrentAction(new Dormir());
                return -1.0f;
            }
            catch (Exception e) {
                Mouton.this.setCurrentAction(new Dormir());
                return -1.0f;
            }
        }

        public void close() {
            Mouton.this.imageCourante = Mouton.this.imageNormale;
        }
    }

    protected class Consuming
    extends Agent.Action {
        private float delay;
        private float among;

        public Consuming(float delay, float among) {
            super(Mouton.this, Math.random() * 20.0);
            this.delay = delay;
            this.among = among;
        }

        protected float step() {
            Mouton.this.getHungryLevel().changeHunger(-this.among);
            return this.delay;
        }
    }

    protected class IsHungry
    extends Satisfactor {
        protected float hunger;
        protected float hungryFloor;
        protected float hungryCeil;
        protected boolean unfiniteHungry;

        public IsHungry(float hunger, float hungryFloor, float hungryCeil) {
            this.hunger = hunger;
            this.hungryFloor = hungryFloor;
            this.hungryCeil = hungryCeil;
            this.unfiniteHungry = false;
        }

        public IsHungry() {
            this.unfiniteHungry = true;
        }

        public boolean isSatisfying() {
            return this.hunger > this.hungryCeil || this.unfiniteHungry;
        }

        public int heuristic() {
            return (int)Math.floor(this.hungryCeil - this.hunger);
        }

        public float getReserves() {
            return this.hunger - this.hungryFloor;
        }

        public void changeHunger(float difference) {
            this.hunger += difference;
        }
    }

    private class isNear
    extends Selector {
        float x;
        float y;
        float radius;

        public isNear(float x, float y, float radius) {
            this.x = x;
            this.y = y;
            this.radius = radius;
        }

        public boolean isFiting(Element el) {
            float yd;
            float xd = el.getArea().getX() - this.x;
            return Math.sqrt(xd * xd + (yd = el.getArea().getY() - this.y) * yd) < (double)this.radius;
        }
    }

    protected class MoveRandomly
    extends MovingAgent2.MoveTo {
        private float distance;

        public MoveRandomly(float distance, float angle) {
            super(Mouton.this, Math.max(0.0f, Math.min(Mouton.this.getArea().getX() + (float)((double)distance * Math.cos(angle)), Mouton.this.world.map.xLength - 1.0f)), Math.max(0.0f, Math.min(Mouton.this.getArea().getY() + (float)((double)distance * Math.sin(angle)), Mouton.this.world.map.yLength - 1.0f)));
            this.distance = distance;
        }

        public MoveRandomly() {
            this((float)Math.random() * 10.0f, (float)Math.random() * 20.0f);
        }

        public float step() {
            if (this.successiveFailures > 3) {
                float angle = (float)Math.random() * 20.0f;
                this.x = Math.max(0.0f, Math.min(Mouton.this.getArea().getX() + (float)((double)this.distance * Math.cos(angle)), Mouton.this.world.map.xLength - 1.0f));
                this.y = Math.max(0.0f, Math.min(Mouton.this.getArea().getY() + (float)((double)this.distance * Math.sin(angle)), Mouton.this.world.map.yLength - 1.0f));
                this.successiveFailures = 0;
                this.randomize = false;
                this.failure = false;
                this.b = 0.0f;
                return Mouton.this.getDelay();
            }
            return 3.0f * super.step();
        }

        public void whenEnd() {
            Mouton.this.setCurrentAction(new Manger());
        }
    }

    protected class PeutEtrePietine
    extends Selector {
        public boolean isFiting(Element el) {
            return el.getKind().equals("herbe") || el.getKind().equals("cadavre") || el.getKind().equals("cadavreSec");
        }
    }
}

