/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.Message2;
import examples.MovingAgent2;
import examples.Nature2;
import examples.RectangularArea2;
import java.awt.Color;
import java.awt.Image;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import modelling.Eatable;
import modelling.Mobile;
import modelling.RectangularArea;
import modelling.Selector;
import modelling.Vision;
import sema.Agent;
import sema.Area;
import sema.Element;
import sema.Nature;
import sema.World;

public class Loup
extends MovingAgent2
implements Mobile,
Vision {
    public String etat = "Chasser";
    private Selector personnalVision;
    private Selector isMouton;
    float visionRadius;
    private int comptMoveToRandomGoals;
    boolean mangeant;

    public Loup(World world, Area area, float delay, Image image) {
        super(world, area, delay, image, 7.0f, world.nature.getGoodKind("herbe"));
        Nature nature = this.world.nature;
        nature.getClass();
        this.personnalVision = new Nature.CanSee(nature, this);
        this.isMouton = ((Nature2)this.world.nature).getGoodKind("mouton", "cadavre");
        this.visionRadius = 10.0f;
        this.mangeant = false;
        this.setKind("loup");
        new CommonWolfAction((double)this.getDelay());
        this.setCompatibleElements();
        this.setDrawingPriority(10.0f);
    }

    public Loup(World world, Image image) {
        this(world, new RectangularArea2(world.map, 1.0f, 1.0f, 2.0f, 2.0f), 1.0f, image);
    }

    public void setCompatibleElements() {
        this.compatibleElements = new PeutEtrePietine();
    }

    protected float getVisionRadius() {
        return this.visionRadius;
    }

    protected Area getAreaOfVision() {
        float x = this.getArea().getX();
        float y = this.getArea().getY();
        return new RectangularArea(this.world.map, x, y, 2.0f * this.getVisionRadius(), 2.0f * this.getVisionRadius(), this.getArea().getAngle());
    }

    protected Area getLineVision(float angle) {
        float x = (float)((double)this.getArea().getX() + Math.cos(angle) * (double)this.getVisionRadius() / 2.0);
        float y = (float)((double)this.getArea().getY() + Math.sin(angle) * (double)this.getVisionRadius() / 2.0);
        return new RectangularArea(this.world.map, x, y, this.getVisionRadius(), 0.0f, angle);
    }

    public boolean canSee(Element element) {
        return this.personnalVision.isFiting(element) && this.world.nature.getDistance(this, element) < this.getVisionRadius();
    }

    public Vector watch() {
        Vector<Element> seen = new Vector<Element>();
        TreeMap areaOfVision = this.world.nature.getElements(this.getAreaOfVision());
        Set cles = areaOfVision.keySet();
        Iterator iterator = cles.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)areaOfVision.get(iterator.next());
            if (!this.canSee(element)) continue;
            seen.add(element);
        }
        return seen;
    }

    public Element watchNearest() {
        float nearest = Float.MAX_VALUE;
        Element curentNearest = null;
        TreeMap areaOfVision = this.world.nature.getElements(this.getAreaOfVision());
        Set cles = areaOfVision.keySet();
        Iterator iterator = cles.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)areaOfVision.get(iterator.next());
            float distance = this.world.nature.getDistance(element, this);
            if (!(distance < nearest) || !this.personnalVision.isFiting(element)) continue;
            curentNearest = element;
            nearest = distance;
        }
        return curentNearest;
    }

    public Vector watchFor(Selector sel) {
        Vector<Element> seen = new Vector<Element>();
        TreeMap areaOfVision = this.world.nature.getElements(this.getAreaOfVision());
        Set cles = areaOfVision.keySet();
        Iterator iterator = cles.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)areaOfVision.get(iterator.next());
            if (!this.canSee(element) || !sel.isFiting(element)) continue;
            seen.add(element);
        }
        return seen;
    }

    public Element watchForNearest(Selector sel) {
        float nearest = Float.MAX_VALUE;
        Element curentNearest = null;
        TreeMap areaOfVision = this.world.nature.getElements(this.getAreaOfVision());
        Set cles = areaOfVision.keySet();
        Iterator iterator = cles.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)areaOfVision.get(iterator.next());
            float distance = this.world.nature.getDistance(element, this);
            if (!(distance < nearest) || !sel.isFiting(element)) continue;
            curentNearest = element;
            nearest = distance;
        }
        return curentNearest;
    }

    private void endOfAction(String action) {
    }

    public boolean acceptAction(Agent.Action action) {
        this.debutAction();
        try {
            MovingAgent2.MoveToRandomGoals errer = (MovingAgent2.MoveToRandomGoals)action;
            if (this.comptMoveToRandomGoals <= 0) {
                this.etat = "Chasser";
                new CommonWolfAction((double)this.getDelay());
                return false;
            }
            --this.comptMoveToRandomGoals;
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    public void debutAction() {
        this.world.nature.broadcastSignal(new Message2(this.world.map, "loup", 8.0f, this.getArea().getX(), this.getArea().getY(), this.isMouton));
    }

    public void draw() {
        float backA = this.getArea().getAngle();
        this.getArea().setAngle(0.0f);
        super.draw();
        this.getArea().setAngle(backA);
    }

    public void highlight() {
        this.highlight(new Color(0.0f, 0.0f, 1.0f, 0.2f));
    }

    public String[][] getProperties() {
        String[][] ret0 = this.getArea().getProperties();
        String[][] ret = new String[5][2];
        String[] p1 = new String[]{"kind", this.getKind()};
        String[] p2 = new String[]{"height", new Float(this.getHeight()).toString()};
        String[] p3 = new String[]{"Drawing priority", new Float(this.getDrawingPriority()).toString()};
        String[] p4 = new String[]{"ID", this.id.toString()};
        String[] p5 = new String[]{"Activit\u00e9", this.etat};
        ret[0] = p1;
        ret[1] = p2;
        ret[2] = p3;
        ret[3] = p4;
        ret[4] = p5;
        return Loup.union(ret0, ret);
    }

    public void setProperties(String property, String value) {
        try {
            this.getArea().setProperties(property, value);
            if (property.equals("height")) {
                this.setHeight(Float.parseFloat(value));
            } else if (property.equals("kind")) {
                this.setKind(value);
            } else if (property.equals("Drawing priority")) {
                float priority = Float.parseFloat(value);
                this.setDrawingPriority(priority);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected class EatElement
    extends Agent.Action {
        protected Element goal;

        public EatElement(Element goal) {
            super(Loup.this, Loup.this.getDelay());
            this.goal = goal;
            Loup.this.mangeant = true;
        }

        public EatElement() {
            this(this$0.watchForNearest(this$0.world.nature.getGoodKind("cadavre")));
        }

        protected float firstStep() {
            Loup.this.etat = "Manger";
            Loup.this.orientate(this.goal.getArea().getX(), this.goal.getArea().getY());
            Loup.this.walk();
            return Loup.this.getDelay();
        }

        protected float step() {
            Eatable a = (Eatable)((Object)this.goal);
            if (a.canEat(Loup.this) && Loup.this.world.nature.getDistance(Loup.this, this.goal) < 2.0f) {
                a.eaten(Loup.this);
                return Loup.this.getDelay();
            }
            Loup.this.etat = "Chasser";
            new CommonWolfAction((double)Loup.this.getDelay());
            return -1.0f;
        }

        protected void close() {
            Loup.this.mangeant = false;
        }
    }

    protected class CommonWolfAction
    extends Agent.Action {
        public CommonWolfAction(double t) {
            super(Loup.this, t);
        }

        public float step() {
            Element meat = Loup.this.watchForNearest(Loup.this.isMouton);
            if (meat != null) {
                float distance = Loup.this.world.nature.getDistance(meat, Loup.this);
                if ((double)distance < 1.5) {
                    if (meat.getKind().equals("mouton")) {
                        meat.kill(Loup.this);
                    }
                    new EatElement();
                    return -1.0f;
                }
                float x = meat.getArea().getX();
                float y = meat.getArea().getY();
                Loup.this.orientate(x, y);
                Loup.this.walk();
                return Loup.this.stepDelay;
            }
            Loup.this.comptMoveToRandomGoals = 10;
            Loup.this.etat = "Errer";
            new MovingAgent2.MoveToRandomGoals(Loup.this, Loup.this.getDelay());
            return -1.0f;
        }
    }

    private class isNear
    extends Selector {
        float x;
        float y;
        float radius;

        public isNear(float x, float y, float radius) {
            this.x = x;
            this.y = y;
            this.radius = radius;
        }

        public boolean isFiting(Element el) {
            float yd;
            float xd = el.getArea().getX() - this.x;
            return Math.sqrt(xd * xd + (yd = el.getArea().getY() - this.y) * yd) < (double)this.radius;
        }
    }

    protected class PeutEtrePietine
    extends Selector {
        public boolean isFiting(Element el) {
            return !el.getKind().equals("loup");
        }
    }
}

