/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.awt.Color;
import java.awt.Image;
import modelling.Eatable;
import sema.Agent;
import sema.Area;
import sema.Element;
import sema.World;

public class Herbe
extends Element
implements Eatable {
    private float nutritiveReserves;
    private Image image;

    public Herbe(World world, Area area, Image image) {
        super(world, area, image);
        this.image = image;
        this.setKind("herbe");
        this.nutritiveReserves = 100.0f;
        this.setDrawingPriority(0.0f);
    }

    public float getNutritiveReserves() {
        return this.nutritiveReserves;
    }

    protected void setNutritiveReserves(float newValue) {
        this.nutritiveReserves = newValue;
    }

    protected void decreaseNutritiveReserves(float decreaseValue) {
        this.nutritiveReserves -= decreaseValue;
    }

    public boolean canEat(Element element) {
        return (double)this.nutritiveReserves > 0.1;
    }

    public float eaten(Agent agent) {
        float a = (float)Math.min(20.0 * Math.random(), (double)this.getNutritiveReserves());
        this.decreaseNutritiveReserves(a);
        if ((double)this.getNutritiveReserves() <= 0.1) {
            this.death();
        }
        return a;
    }

    public void draw() {
        float n = Math.min(this.nutritiveReserves / 100.0f, 1.0f);
        int redLevel = (int)(-n * 100.0f + 184.0f);
        int greenLevel = (int)(n * 25.0f + 159.0f);
        int blueLevel = 18;
        this.world.drawing.setColor(new Color(redLevel, greenLevel, blueLevel));
        this.world.drawing.fillRect(this.getArea().getX() - 0.5f, this.getArea().getY() - 0.5f, 1.0f, 1.0f);
    }

    public String[][] getProperties() {
        String[][] ret0 = this.getArea().getProperties();
        String[][] ret = new String[5][2];
        String[] p1 = new String[]{"kind", this.getKind()};
        String[] p2 = new String[]{"height", new Float(this.getHeight()).toString()};
        String[] p3 = new String[]{"Drawing priority", new Float(this.getDrawingPriority()).toString()};
        String[] p4 = new String[]{"ID", this.id.toString()};
        String[] p5 = new String[]{"Grass height", new Float(this.getNutritiveReserves()).toString()};
        ret[0] = p1;
        ret[1] = p2;
        ret[2] = p3;
        ret[3] = p4;
        ret[4] = p5;
        return Herbe.union(ret0, ret);
    }

    public void setProperties(String property, String value) {
        try {
            this.getArea().setProperties(property, value);
            if (property.equals("height")) {
                this.setHeight(Float.parseFloat(value));
            } else if (property.equals("kind")) {
                this.setKind(value);
            } else if (property.equals("Drawing priority")) {
                float priority = Float.parseFloat(value);
                this.setDrawingPriority(priority);
            } else if (property.equals("Grass height")) {
                float nutritive = Float.parseFloat(value);
                this.setNutritiveReserves(nutritive);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected class Growing
    extends Element.ElementEvent {
        public Growing(double t) {
            super(Herbe.this, t);
        }

        protected void whatToDo() {
            Herbe.this.setNutritiveReserves(Herbe.this.getNutritiveReserves() + 10.0f);
        }
    }
}

