/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.MovingAgent2;
import examples.RectangularArea2;
import java.awt.Image;
import java.util.Iterator;
import java.util.Vector;
import modelling.Selector;
import sema.Agent;
import sema.Box;
import sema.Element;
import sema.World;

class Grain
extends MovingAgent2 {
    public Grain(World world, float x, float y, float proba, Image image) {
        super(world, new RectangularArea2(world.map, (x + 0.5f) * world.map.boxLength, (y + 0.5f) * world.map.boxLength, world.map.boxLength, world.map.boxLength, 1.5707964f), 1.0f, image, 1.0f, new NoElements());
        new Fall().start();
    }

    protected boolean isCrashingElements2() {
        Vector v = this.getArea().getIntersectedBoxes();
        for (int i = 0; i < v.size(); ++i) {
            Box b = (Box)v.get(i);
            if (!b.isFreeFor(this)) {
                return true;
            }
            Iterator it = b.getContents().iterator();
            while (it.hasNext()) {
                Element a = (Element)it.next();
                if (a == this || this.compatibleElements.isFiting(a) || !this.getArea().isIn(a.getArea().getX(), a.getArea().getY())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean translate2(float x, float y) {
        if (this.getArea().translate(x, y)) {
            if (this.isCrashingElements2() || !this.getArea().inMap()) {
                this.getArea().translate(-x, -y);
            } else {
                return true;
            }
        }
        return false;
    }

    protected boolean walk(float f) {
        return this.walk(f, this.getArea().getAngle());
    }

    protected boolean walk(float f, float a) {
        return this.translate2(f * (float)Math.cos(a), f * (float)Math.sin(a));
    }

    class Fall
    extends Agent.Action {
        Fall() {
            super(Grain.this);
        }

        public float step() {
            if (Grain.this.walk(Grain.this.world.map.boxLength)) {
                Grain.this.walk(Grain.this.world.map.boxLength, (float)((int)(Math.random() * 2.0)) * (float)Math.PI);
                return Grain.this.getDelay();
            }
            return -1.0f;
        }
    }

    static class NoElements
    extends Selector {
        NoElements() {
        }

        public boolean isFiting(Element e) {
            return false;
        }
    }
}

