/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.awt.Color;
import java.awt.Image;
import modelling.Eatable;
import sema.Agent;
import sema.Area;
import sema.Element;
import sema.World;

public class CadavreMouton
extends Element
implements Eatable {
    private float nutritiveReserves;
    private float nutritiveReserves2;
    private Image image;
    private Image defImage;

    public CadavreMouton(World world, Area area, float nutritiveReserves, Image image) {
        super(world, area, image);
        this.image = image;
        this.setKind("cadavre");
        this.nutritiveReserves = nutritiveReserves;
        this.nutritiveReserves2 = nutritiveReserves;
        this.setDrawingPriority(2.0f);
    }

    public float getNutritiveReserves() {
        return this.nutritiveReserves;
    }

    protected void setNutritiveReserves(float newValue) {
        this.nutritiveReserves = newValue;
    }

    protected void decreaseNutritiveReserves(float decreaseValue) {
        this.nutritiveReserves -= decreaseValue;
        if (this.nutritiveReserves <= 0.0f) {
            this.setKind("cadavreSec");
        }
    }

    public boolean canEat(Element element) {
        return this.nutritiveReserves > 0.0f;
    }

    public void draw() {
        super.draw();
        if (this.nutritiveReserves > 0.0f) {
            this.highlight(new Color(1.0f, 0.0f, 0.0f, 0.6f * this.nutritiveReserves / this.nutritiveReserves2));
        }
    }

    public void death() {
    }

    public float eaten(Agent agent) {
        float a = (float)Math.min(5.0 * Math.random(), (double)this.getNutritiveReserves());
        this.decreaseNutritiveReserves(a);
        if (this.getNutritiveReserves() <= 0.0f) {
            this.death();
        }
        return a;
    }

    public String[][] getProperties() {
        String[][] ret0 = this.getArea().getProperties();
        String[][] ret = new String[5][2];
        String[] p1 = new String[]{"kind", this.getKind()};
        String[] p2 = new String[]{"height", new Float(this.getHeight()).toString()};
        String[] p3 = new String[]{"Drawing priority", new Float(this.getDrawingPriority()).toString()};
        String[] p4 = new String[]{"ID", this.id.toString()};
        String[] p5 = new String[]{"Meat left", new Float(this.getNutritiveReserves()).toString()};
        ret[0] = p1;
        ret[1] = p2;
        ret[2] = p3;
        ret[3] = p4;
        ret[4] = p5;
        return CadavreMouton.union(ret0, ret);
    }

    public void setProperties(String property, String value) {
        try {
            this.getArea().setProperties(property, value);
            if (property.equals("height")) {
                this.setHeight(Float.parseFloat(value));
            } else if (property.equals("kind")) {
                this.setKind(value);
            } else if (property.equals("Drawing priority")) {
                float priority = Float.parseFloat(value);
                this.setDrawingPriority(priority);
            } else if (property.equals("Meat left")) {
                float nutritive = Float.parseFloat(value);
                this.setNutritiveReserves(nutritive);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

