/*
 * Decompiled with CFR 0.152.
 */
package SEMAbeans;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComponent;
import sema.Box;
import sema.Element;
import sema.World;

public class ZGCarteSEMA
extends JComponent {
    private float cxu = 0.0f;
    private float cyu = 0.0f;
    private boolean highlightSelectedBox = false;
    private World world = new World();
    private float pixelsByBox = 10.0f;
    private Element selectedElement;
    private Box selectedBox;

    public ZGCarteSEMA() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ZGCarteSEMA.this.requestFocusInWindow();
            }
        });
    }

    public void setHighlightSelectedBox(boolean b) {
        this.highlightSelectedBox = b;
    }

    public void setCenterXu(float x) {
        this.cxu = x;
    }

    public float getCenterXu() {
        return this.cxu;
    }

    public void setCenterYu(float y) {
        this.cyu = y;
    }

    public float getCenterYu() {
        return this.cyu;
    }

    public void setSelectedElement(Element selectedElement) {
        this.selectedElement = selectedElement;
    }

    public void setSelectedBox(Box selectedBox) {
        this.selectedBox = selectedBox;
    }

    public void init(World world) {
        this.world = world;
        this.pixelsByBox = world.drawing.getPixelsByBox();
        this.selectedBox = null;
        this.selectedElement = null;
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)(this.pixelsByBox * 10.0f), (int)(this.pixelsByBox * 10.0f));
    }

    public Dimension getMinimumSize() {
        return new Dimension((int)this.pixelsByBox, (int)this.pixelsByBox);
    }

    public float getWidthu() {
        return (float)this.getWidth() / this.world.drawing.getPixelsByUnit();
    }

    public float getXu() {
        return this.cxu - this.getWidthu() / 2.0f;
    }

    public float getHeightu() {
        return (float)this.getHeight() / this.world.drawing.getPixelsByUnit();
    }

    public float getYu() {
        return this.cyu - this.getHeightu() / 2.0f;
    }

    protected void paintComponent(Graphics g) {
        float xu = this.getXu();
        float yu = this.getYu();
        float pbu = this.world.drawing.getPixelsByUnit();
        Graphics2D genv = (Graphics2D)g.create();
        genv.setColor(this.getBackground());
        genv.fillRect(0, 0, this.getWidth(), this.getHeight());
        genv.translate(-xu * pbu, -yu * pbu);
        if (this.world != null) {
            Vector boxToRefresh = this.world.map.getCoveringBoxes(xu, yu, this.getWidthu(), this.getHeightu());
            this.world.drawing.draw(genv, boxToRefresh);
            this.world.draw();
            if (this.selectedElement != null) {
                this.selectedElement.highlight();
            }
            if (this.selectedBox != null && this.highlightSelectedBox) {
                this.selectedBox.highlight();
            }
        }
    }
}

