/*
 * Decompiled with CFR 0.152.
 */
package Interface;

import Interface.FileExtFilter;
import Interface.SimFileRW;
import SEMAbeans.ZGCarteSEMA;
import SEMAbeans.ZGPreviewSEMA;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.RandomAccessFile;
import java.text.NumberFormat;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sema.Box;
import sema.Element;
import sema.Engine;
import sema.World;

public class Sema
extends JFrame {
    private final World defaultWorld;
    private World world;
    private int boxFactor;
    private final SimFileRW ioSIM;
    private File currentfile;
    private float zoom;
    private float defaultZoom;
    private float zoomMax;
    private float zoomMin;
    private float cxu;
    private float cyu;
    private float timeFactor;
    private float facteurTemporelMax;
    private float facteurTemporelMin;
    private long RealDisplayDelay;
    private double VirtualDisplayDelay;
    private boolean timeFactorEnabled;
    private long lastRDelay;
    private double lastVDelay;
    private double delaiVirtuelAffSynchronized;
    private SEMAThread semaThread;
    private static Object calcul = new int[1];
    private static Object run = new int[1];
    private Box selectedBox;
    private Element selectedElement;
    private boolean isMouvingElement;
    private boolean isEditing;
    private boolean isFollowing;
    private boolean wasRunning;
    private boolean pause_temp;
    private boolean isRunning;
    private boolean hasEnded;
    private String lastCodeEntered;
    private int xMoveApercu;
    private int yMoveApercu;
    private boolean isPreviewMoving;
    private boolean isPreviewDragued;
    private float xMove;
    private float yMove;
    private boolean isRotatingElement;
    private float angleMove;
    private JButton Default;
    private JPanel GroundOptions;
    private JSplitPane PanelDroit;
    private JPanel barreDoutil;
    private JPanel barreDoutilEdition;
    private JPanel barreDoutilSimulation;
    private JButton buttonCenter;
    private JButton buttonCenterBox;
    private JButton buttonChangeBox;
    private JButton buttonDate;
    private JButton buttonDuplicateEl;
    private JButton buttonFit;
    private JButton buttonKill;
    private JButton buttonNext;
    private JButton buttonRun;
    private JButton buttonSave;
    private JButton buttonaddEl;
    private JButton buttonaddElbig;
    private JSplitPane centerPanel;
    private JCheckBox checkActivateRDelay;
    private JCheckBox checkActivateVDelay;
    private JCheckBox checkBoost;
    private JCheckBox checkFollow;
    private JCheckBox checkLock;
    private JCheckBox checkMarked;
    private JCheckBox checkPause;
    private JCheckBox checkShow;
    private JComboBox choixIndiv;
    private Panel elPropPanel;
    private JPanel elementOptions;
    private JPanel elementPanel;
    private JFormattedTextField fieldDate;
    private JFormattedTextField fieldDelaiReel;
    private JFormattedTextField fieldDelaiVirtuel;
    private JFormattedTextField fieldFacteurTemporel;
    private JFormattedTextField fieldPasNext;
    private JFormattedTextField fieldZoom;
    private JPanel groundPanel;
    private JLabel iconIndiv;
    private JLabel iconTerrain;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    private JLabel labelAchievedTF;
    private JLabel labelApercu;
    private JLabel labelElementChoice;
    private JLabel labelPropIndiv;
    private JLabel labelPropMonde;
    private JMenuItem menuAbout;
    private JMenuBar menuBar;
    private JMenuItem menuEditFile;
    private JMenu menuFile;
    private JMenu menuHelp;
    private JMenuItem menuItemHelp;
    private JMenuItem menuNewFile;
    private JMenuItem menuOpenFile;
    private JMenuItem menuResetFile;
    private JMenuItem menuResetWithBF;
    private Panel paneDroitHaut;
    private JPanel panelDroitBas;
    private JSplitPane panelG_Carte;
    private JPanel panelGauche;
    private Panel panelpropWorld;
    private JFileChooser simChooser;
    private JSlider sliderTemporel;
    private JSlider sliderZoom;
    private JTable tablePropIndiv;
    private JTable tablePropMonde;
    private JTable tablePropTerrain;
    private ZGPreviewSEMA zGApercu;
    private ZGCarteSEMA zGCarte;
    private JPanel zoomOptions;
    static /* synthetic */ Class class$java$lang$String;

    public Sema() {
        this.world = this.defaultWorld = new World();
        this.boxFactor = 1;
        this.ioSIM = new SimFileRW();
        this.timeFactorEnabled = true;
        this.lastRDelay = -1L;
        this.lastVDelay = -1.0;
        this.delaiVirtuelAffSynchronized = Math.min((float)this.VirtualDisplayDelay, (float)this.RealDisplayDelay * this.timeFactor);
        this.semaThread = new SEMAThread();
        this.isMouvingElement = false;
        this.isEditing = true;
        this.isFollowing = false;
        this.wasRunning = false;
        this.pause_temp = false;
        this.isRunning = false;
        this.hasEnded = true;
        this.lastCodeEntered = "sema.Agent(sema.Area modelling.RectangularArea(selfType map, float 1, float 1, float 1, float 1),float 1, Image \"filename\")";
        this.xMoveApercu = 0;
        this.yMoveApercu = 0;
        this.isPreviewMoving = false;
        this.isPreviewDragued = false;
        this.xMove = 0.0f;
        this.yMove = 0.0f;
        this.isRotatingElement = false;
        this.angleMove = 0.0f;
        this.initComponents();
        this.setCenterPos(0.0f, 0.0f);
        this.setEditing(false);
        this.semaThread.start();
        String s = null;
        JOptionPane.setRootFrame(this);
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World m) {
        if (m == null) {
            return;
        }
        this.buttonaddEl.setEnabled(true);
        this.hasEnded = false;
        this.setPause(true);
        this.world = m;
        this.zGCarte.init(this.world);
        this.zoomMin = this.world.drawing.minZoom;
        this.zoomMax = this.world.drawing.maxZoom;
        this.setZoom(this.world.drawing.getZoom());
        this.setDefaultZoom(this.world.drawing.getZoom());
        this.facteurTemporelMin = this.world.drawing.minTfactor;
        this.facteurTemporelMax = this.world.drawing.maxTfactor;
        this.setTimeFactor(this.world.drawing.tFactor);
        this.setRealDisplayDelay(this.world.drawing.realDelay);
        this.setVirtualDisplayDelay(this.world.drawing.virtualDelay);
        this.checkActivateRDelay.setSelected(true);
        this.checkActivateVDelay.setSelected(false);
        this.lastRDelay = -1L;
        this.lastVDelay = this.world.drawing.virtualDelay;
        this.setCenterPos(this.world.drawing.centerX, this.world.drawing.centerY);
        this.setSelectedElement(null);
        this.zGCarte.setSelectedBox(null);
        this.selectedBox = null;
        this.iconTerrain.setIcon(null);
        this.refreshTableBox();
        this.choixIndiv.removeAllItems();
        this.labelAchievedTF.setText("");
        this.wasRunning = false;
        this.pause_temp = false;
        this.semaThread.init();
        this.repaint();
    }

    private boolean loadCurrentWorld() {
        try {
            this.currentfile = this.simChooser.getSelectedFile();
            this.setWorld(this.ioSIM.open(this.currentfile, this.boxFactor));
            if (this.world != null & this.currentfile != null) {
                this.setTitle("SEMA - " + this.world.getName() + " (" + this.currentfile + ")");
            } else {
                this.setTitle("SEMA");
            }
            return true;
        }
        catch (SimFileRW.InvalidSIMfile e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error in SEMA: invalid SIM file", 2);
            return false;
        }
    }

    private boolean selectWorld() {
        this.setPause(true);
        this.simChooser.setApproveButtonText("Open");
        if (this.simChooser.showOpenDialog(this) == 0) {
            this.boxFactor = 1;
            return this.loadCurrentWorld();
        }
        return false;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float z) {
        this.sliderZoom.setValue(this.zoomToSlider(z));
        Float value = new Float(z);
        this.fieldZoom.setValue(value);
        this.zoom = z;
        this.world.drawing.setZoom(z);
        this.resizeZonePreview();
        this.repaint();
    }

    public float getdefaultZoom() {
        return this.defaultZoom;
    }

    public void setDefaultZoom(float z) {
        this.defaultZoom = z;
    }

    private void resizeZonePreview() {
        float pbu = this.world.drawing.getPixelsByUnit();
        float widthu = (float)this.zGCarte.getWidth() / pbu;
        float heightu = (float)this.zGCarte.getHeight() / pbu;
        this.zGApercu.setZoneSize(widthu / this.world.map.xLength, heightu / this.world.map.yLength);
    }

    public float getCenterX() {
        return this.cxu;
    }

    public float getCenterY() {
        return this.cyu;
    }

    public void setCenterPos(float X, float Y) {
        float bl2 = this.world.map.boxLength / 2.0f;
        if (X < bl2) {
            X = bl2;
        } else if (X > this.world.map.xLength - bl2) {
            X = this.world.map.xLength - bl2;
        }
        if (Y < bl2) {
            Y = bl2;
        } else if (Y > this.world.map.yLength - bl2) {
            Y = this.world.map.yLength - bl2;
        }
        this.cxu = X;
        this.cyu = Y;
        float pbu = this.world.drawing.getPixelsByUnit();
        this.zGCarte.setCenterXu(this.cxu);
        this.zGCarte.setCenterYu(this.cyu);
        this.zGApercu.setCenterPosition(this.cxu / this.world.map.xLength, this.cyu / this.world.map.yLength);
    }

    public void centerSelectedElement() {
        if (this.selectedElement != null) {
            this.setCenterPos(this.selectedElement.getArea().getX(), this.selectedElement.getArea().getY());
            this.repaint();
        }
    }

    public void centerSelectedBox() {
        if (this.selectedBox != null) {
            float ubb = this.world.map.boxLength;
            this.setCenterPos((float)this.selectedBox.x * ubb + ubb / 2.0f, (float)this.selectedBox.y * ubb + ubb / 2.0f);
            this.repaint();
        }
    }

    private void changeTimeFactor(float f) {
        this.timeFactor = f;
        this.refreshDelaiVirtuelAffSynchronized();
        this.semaThread.interrupt();
    }

    public float getTimeFactor() {
        return this.timeFactor;
    }

    public void setTimeFactor(float z) {
        Float value = new Float(z);
        this.fieldFacteurTemporel.setValue(value);
        this.fieldZoomPropertyChange(new PropertyChangeEvent(this, "value", null, value));
    }

    private void displayRealTimeFactor(double d) {
        this.labelAchievedTF.setText(Double.toString(d));
        if (d < (double)this.timeFactor * 0.95) {
            this.labelAchievedTF.setForeground(Color.RED);
        } else {
            this.labelAchievedTF.setForeground(Color.BLACK);
        }
    }

    public long getRealDisplayDelay() {
        return this.RealDisplayDelay;
    }

    public double getVirtualDisplayDelay() {
        return this.VirtualDisplayDelay;
    }

    private void changeRealDisplayDelay(long t) {
        this.RealDisplayDelay = t;
        this.refreshDelaiVirtuelAffSynchronized();
        this.semaThread.interrupt();
    }

    public void setRealDisplayDelay(long t) {
        this.changeRealDisplayDelay(t);
        this.fieldDelaiReel.setValue(new Double(t));
    }

    private void changeVirtualDisplayDelay(double t) {
        this.VirtualDisplayDelay = t;
        this.refreshDelaiVirtuelAffSynchronized();
        this.semaThread.interrupt();
    }

    public void setVirtualDisplayDelay(double t) {
        this.changeVirtualDisplayDelay(t);
        this.fieldDelaiVirtuel.setValue(new Double(t));
    }

    private void refreshDelaiVirtuelAffSynchronized() {
        this.delaiVirtuelAffSynchronized = this.timeFactorEnabled ? Math.min(this.VirtualDisplayDelay, (double)((float)this.RealDisplayDelay * this.timeFactor)) : this.VirtualDisplayDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void next() {
        try {
            Object object = calcul;
            synchronized (object) {
                this.world.engine.next();
            }
        }
        catch (Engine.EndOfSimulation e) {
            JOptionPane.showMessageDialog(null, "END OF SIMULATION (no more events)", "The end...", 2);
            this.setPause(true);
            this.hasEnded = true;
        }
        catch (Engine.SimulationError e) {
            JOptionPane.showMessageDialog(null, "An error occured while treating the current event.\nSimulation was paused, but you can resume it." + e.toString(), "Simulation error", 2);
            this.setPause(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goToDate(double t) {
        try {
            Object object = calcul;
            synchronized (object) {
                this.world.engine.gotoDate(new Double(t));
            }
        }
        catch (Engine.EndOfSimulation e) {
            JOptionPane.showMessageDialog(null, "END OF SIMULATION (no more events)", "The end...", 2);
            this.hasEnded = true;
            this.setPause(true);
        }
        catch (Engine.SimulationError e) {
            JOptionPane.showMessageDialog(null, "An error occured while treating the current event.\nSimulation was paused, but you can resume it." + e.getMessage(), "Simulation error", 2);
            this.setPause(true);
        }
    }

    public void setPause(boolean pause) {
        if (pause) {
            this.isRunning = false;
            this.wasRunning = false;
            this.semaThread.interrupt();
            this.checkPause.setSelected(true);
            this.repaint();
        } else if (this.hasEnded) {
            this.checkPause.setSelected(true);
            JOptionPane.showMessageDialog(null, "END OF SIMULATION (no more events)", "The end...", 2);
        } else {
            this.resume();
            this.checkPause.setSelected(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume() {
        Object object = run;
        synchronized (object) {
            try {
                this.semaThread.init();
                this.isRunning = true;
                run.notifyAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void pause_temporaire() {
        if (this.isRunning) {
            this.wasRunning = true;
            this.isRunning = false;
            this.semaThread.interrupt();
        } else if (!this.pause_temp) {
            this.wasRunning = false;
        }
        this.pause_temp = true;
    }

    private void resume_temporaire() {
        if (this.wasRunning) {
            this.resume();
        }
        this.pause_temp = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(float x, float y) {
        Object object = run;
        synchronized (object) {
            this.setSelectedBox(this.world.map.boxes[(int)(x / this.world.map.boxLength)][(int)(y / this.world.map.boxLength)]);
            this.choixIndiv.removeAllItems();
            Iterator i = this.selectedBox.getContents().iterator();
            float bestDistance = this.world.map.xLength + this.world.map.yLength;
            Element element = null;
            ChoixObject selectedItem = new ChoixObject(null);
            this.choixIndiv.addItem(selectedItem);
            while (i.hasNext()) {
                Element currentEl = (Element)i.next();
                ChoixObject currentItem = new ChoixObject(currentEl);
                this.choixIndiv.addItem(currentItem);
                float currentD = (currentEl.getArea().getX() - x) * (currentEl.getArea().getX() - x) + (currentEl.getArea().getY() - y) * (currentEl.getArea().getY() - y);
                if (!(currentD <= bestDistance & currentEl.getArea().isIn(x, y))) continue;
                bestDistance = currentD;
                element = currentEl;
                selectedItem = currentItem;
            }
            this.choixIndiv.setSelectedItem(selectedItem);
            this.setSelectedElement(element);
        }
        this.repaint();
    }

    public void setSelectedBox(Box b) {
        if (b != null) {
            this.iconTerrain.setIcon(b.getIcon());
        } else {
            this.iconTerrain.setIcon(null);
        }
        this.selectedBox = b;
        this.zGCarte.setSelectedBox(this.selectedBox);
        this.refreshTableBox();
        this.repaint();
    }

    public void setSelectedElement(Element e) {
        this.selectedElement = e;
        if (e != null) {
            this.iconIndiv.setIcon(e.getIcon());
            this.checkMarked.setSelected(e.isMarked());
        } else {
            this.iconIndiv.setIcon(null);
        }
        this.zGCarte.setSelectedElement(e);
        this.refreshTableElement();
        this.repaint();
    }

    private void refreshTableElement() {
        if (this.selectedElement != null) {
            Object[] colonneNom = new Object[]{"Property", "Value"};
            this.tablePropIndiv.setModel(new DefaultTableModel(this.selectedElement.getProperties(), colonneNom));
            this.tablePropIndiv.getModel().addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    int row = e.getFirstRow();
                    String s1 = (String)Sema.this.tablePropIndiv.getModel().getValueAt(row, 0);
                    String s2 = (String)Sema.this.tablePropIndiv.getModel().getValueAt(row, 1);
                    Sema.this.selectedElement.setProperties(s1, s2);
                    Sema.this.ioSIM.elementChanged(Sema.this.selectedElement);
                    Sema.this.refreshTableElement();
                    Sema.this.repaint();
                }
            });
        } else {
            this.tablePropIndiv.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Properties", "Values"}));
        }
    }

    private void refreshTableBox() {
        if (this.selectedBox != null) {
            Object[] colonneNom = new Object[]{"Property", "Value"};
            this.tablePropTerrain.setModel(new DefaultTableModel(this.selectedBox.getProperties(), colonneNom));
            this.tablePropTerrain.getModel().addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    int row = e.getFirstRow();
                    String s1 = (String)Sema.this.tablePropTerrain.getModel().getValueAt(row, 0);
                    String s2 = (String)Sema.this.tablePropTerrain.getModel().getValueAt(row, 1);
                    Sema.this.selectedBox.setProperties(s1, s2);
                    Sema.this.ioSIM.boxChanged(Sema.this.selectedBox);
                    Sema.this.refreshTableBox();
                    Sema.this.repaint();
                }
            });
        } else {
            this.tablePropTerrain.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Properties", "Values"}));
        }
    }

    private void refreshTableMonde() {
        if (this.world != null && this.world != this.defaultWorld) {
            Object[] colonneNom = new Object[]{"Property", "Value"};
            this.tablePropMonde.setModel(new DefaultTableModel(this.world.getProperties(), colonneNom));
            this.tablePropMonde.getModel().addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    int row = e.getFirstRow();
                    String s1 = (String)Sema.this.tablePropMonde.getModel().getValueAt(row, 0);
                    String s2 = (String)Sema.this.tablePropMonde.getModel().getValueAt(row, 1);
                    Sema.this.world.setProperties(s1, s2);
                    Sema.this.refreshTableMonde();
                    Sema.this.repaint();
                }
            });
        } else {
            this.tablePropMonde.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Properties", "Values"}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Object object = calcul;
        synchronized (object) {
            if (this.isFollowing && this.selectedElement != null) {
                this.setCenterPos(this.selectedElement.getArea().getX(), this.selectedElement.getArea().getY());
            }
            if (this.fieldDate != null) {
                this.fieldDate.setValue(new Double(this.world.engine.getTime()));
            }
            this.refreshTableMonde();
            this.refreshTableElement();
            this.refreshTableBox();
            super.paint(g);
        }
    }

    public boolean getIsEditing() {
        return this.isEditing;
    }

    public void setEditing(boolean b) {
        this.isEditing = b;
        if (b) {
            ((CardLayout)this.barreDoutil.getLayout()).show(this.barreDoutil, "EditingCard");
            if (this.world != null & this.currentfile != null) {
                this.setTitle("SEMA - " + this.world.getName() + " (" + this.currentfile + ")" + " [EDITING]");
            } else {
                this.setTitle("SEMA");
            }
        } else {
            ((CardLayout)this.barreDoutil.getLayout()).show(this.barreDoutil, "SimulatingCard");
            if (this.world != null & this.currentfile != null) {
                this.setTitle("SEMA - " + this.world.getName() + " (" + this.currentfile + ")");
            } else {
                this.setTitle("SEMA");
            }
        }
        this.buttonaddEl.setVisible(!b);
        this.checkLock.setSelected(!b);
    }

    public void addEl() {
        if (this.world != null) {
            String s = JOptionPane.showInputDialog(null, "Give the code of the element: ", this.lastCodeEntered);
            if (s == null) {
                return;
            }
            try {
                this.setSelectedElement(this.ioSIM.addElement(s, this.world));
                this.centerSelectedElement();
                this.repaint();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Unable to add element : " + e.getMessage(), "Error while adding element", 0);
            }
        }
    }

    public void killSelected() {
        int r;
        if (this.selectedElement != null && (r = JOptionPane.showConfirmDialog(null, "Confirm kill of " + this.selectedElement.toString(), "Kill element", 0, 2)) == 0) {
            if (this.selectedElement.kill(null)) {
                this.setSelectedElement(null);
            } else {
                JOptionPane.showMessageDialog(null, "Impossible to kill " + this.selectedElement.toString(), "Kill element echec", 2);
            }
        }
    }

    private void save() {
        try {
            if (this.boxFactor != 1) {
                throw new Exception("boxfactor != 1 !! impossible de sauver");
            }
            this.simChooser.setApproveButtonText("Save");
            if (this.simChooser.showOpenDialog(this) == 0) {
                this.currentfile = this.simChooser.getSelectedFile();
                this.ioSIM.save(this.currentfile, this.world);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Unknown Error Occurred during save");
        }
    }

    private boolean confirmResetAction(String action) {
        int r;
        if (this.isEditing) {
            int r2 = JOptionPane.showConfirmDialog(null, "Do you want to save ?", "Save", 1);
            if (r2 == 0) {
                this.save();
            } else if (r2 != 1) {
                return false;
            }
        } else if (this.world != null && this.world != this.defaultWorld && (r = JOptionPane.showConfirmDialog(null, action + " will erase current state.", "Are you sure?", 0, 2)) != 0) {
            return false;
        }
        return true;
    }

    public void reset(boolean withBoxfactor) {
        if (this.confirmResetAction("Reseting the simulation") && this.currentfile != null) {
            if (withBoxfactor) {
                int i = -1;
                while (i < 0) {
                    try {
                        String s = JOptionPane.showInputDialog(null, "Box factor (a positive integer \nshouldn't be too high \n0 means sim default): ", "0");
                        if (s == null) {
                            return;
                        }
                        i = Integer.parseInt(s);
                    }
                    catch (Exception e) {
                        i = -1;
                    }
                }
                this.boxFactor = i;
            }
            this.loadCurrentWorld();
        }
    }

    public void open() {
        if (this.confirmResetAction("Opening another simulation") && this.selectWorld()) {
            this.setEditing(false);
        }
    }

    public void edit() {
        if (this.confirmResetAction("Editing a simulation")) {
            this.boxFactor = 1;
            if (this.selectWorld()) {
                this.setEditing(true);
            }
        }
    }

    public void run() {
        if (this.isEditing && this.confirmResetAction("Running the simulation")) {
            this.setEditing(false);
        }
    }

    public void newSim() {
        if (this.confirmResetAction("Creating a new simulation")) {
            String fileContent = "";
            String last = "";
            while (last.equals("")) {
                last = JOptionPane.showInputDialog(null, "Simulation name: ", "");
                if (last != null) continue;
                return;
            }
            fileContent = fileContent + "NAME=" + last + "\n";
            int r = JOptionPane.showConfirmDialog(null, "Set 1 :\nYou'll have to choose some parameters of the map :\n -number of boxes\n -dimensions\n -default box type \nPress NO to skip step.", "STEP 1 of 4", 1);
            if (r == 0) {
                last = JOptionPane.showInputDialog(null, "Number of boxes on X side: ", "10");
                fileContent = fileContent + "XMBOXES=" + last + "\n";
                last = JOptionPane.showInputDialog(null, "Number of boxes on Y side: ", "10");
                fileContent = fileContent + "YMBOXES=" + last + "\n";
                last = JOptionPane.showInputDialog(null, "Length of each square box (in simulated space units): ", "1");
                fileContent = fileContent + "MBOXLENGTH=" + last + "\n";
                last = JOptionPane.showInputDialog(null, "Number of pixels by box when zoom=1: ", "80");
                fileContent = fileContent + "PIXELSBYMBOX=" + last + "\n";
            }
            if (r == 2) {
                return;
            }
            r = JOptionPane.showConfirmDialog(null, "Step 2 :\nYou'll have to choose some parameters for the interface :\n -zoom\n -time factor,\n -delays \nPress NO to skip step.", "STEP 2 of 4", 1);
            if (r == 0) {
                last = JOptionPane.showInputDialog(null, "Minimal zoom possible for this simulation: ", "0");
                fileContent = fileContent + "MINZOOM=" + last + "\n";
                last = JOptionPane.showInputDialog(null, "Maximal zoom possible for this simulation: ", "50");
                fileContent = fileContent + "MAXZOOM=" + last + "\n";
                last = JOptionPane.showInputDialog(null, "Default zoom for this simulation: ", "1");
                fileContent = fileContent + "ZOOM=" + last + "\n";
                last = JOptionPane.showInputDialog(null, "Minimal time factor possible for this simulation: ", "0");
                fileContent = fileContent + "MINTFACTOR=" + last + "\n";
                last = JOptionPane.showInputDialog(null, "Maximal time factor possible for this simulation: ", "100");
                fileContent = fileContent + "MAXTFACTOR=" + last + "\n";
                last = JOptionPane.showInputDialog(null, "Default time factor for this simulation: ", "1");
                fileContent = fileContent + "TFACTOR=" + last + "\n";
                last = JOptionPane.showInputDialog(null, "Default virtual display delay for this simulation: ", "20000");
                fileContent = fileContent + "VIRTUALDISPLAYDELAY=" + last + "\n";
                last = JOptionPane.showInputDialog(null, "Default real display delay for this simulation: ", "200");
                fileContent = fileContent + "REALDISPLAYDELAY=" + last + "\n";
            }
            if (r == 2) {
                return;
            }
            r = JOptionPane.showConfirmDialog(null, "Step 3 :\nYou can share images and declare variables.\nPress NO to skip step.", "STEP 3 of 4", 1);
            if (r == 0) {
                last = "...";
                while (!last.equals("") && (last = JOptionPane.showInputDialog(null, "New variable or image? Syntax: imageName=imagefile or #variable=value", "")) != null) {
                    fileContent = fileContent + last + "\n";
                }
            }
            if (r == 2) {
                return;
            }
            r = JOptionPane.showConfirmDialog(null, "Step 4 :\nYou'll have to choose the classes to use for this simulation.\nThese classes must be accessible by Java (this means, in java/lib for example).\nThe default classes of Sema are always accessible.\nPress NO to skip step.", "STEP 4 of 4", 1);
            if (r == 0) {
                last = JOptionPane.showInputDialog(null, "Engine class: ", "sema.Engine");
                fileContent = fileContent + "ENGINE=" + last + "\n";
                last = JOptionPane.showInputDialog(null, "Map class: ", "sema.Map");
                fileContent = fileContent + "MAP=" + last + "\n";
                last = JOptionPane.showInputDialog(null, "Drawing class: ", "sema.Drawing");
                fileContent = fileContent + "DRAWING=" + last + "\n";
                last = JOptionPane.showInputDialog(null, "Nature class: ", "sema.Nature");
                fileContent = fileContent + "NATURE=" + last + "\n";
                last = JOptionPane.showInputDialog(null, "World class: ", "sema.World");
                fileContent = fileContent + "MODELISATION=" + last + "\n";
            }
            if (r == 2) {
                return;
            }
            this.simChooser.setApproveButtonText("Create");
            if (this.simChooser.showOpenDialog(this) == 0) {
                try {
                    this.currentfile = this.simChooser.getSelectedFile();
                    this.currentfile.delete();
                    this.currentfile.createNewFile();
                    RandomAccessFile ch = new RandomAccessFile(this.currentfile, "rw");
                    ch.writeBytes("//SIM file generated by Sema\n" + fileContent + "\n\nELEMENTS:\n");
                    ch.close();
                    if (this.loadCurrentWorld()) {
                        JOptionPane.showMessageDialog(null, "The new simulation has been created.", "Congratulations!", 1);
                        this.setEditing(true);
                    } else {
                        JOptionPane.showMessageDialog(null, "Cannot create the new simulation. Invalid parameters.", "Sorry!", 2);
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Cannot create file: " + this.currentfile, "Sorry!", 2);
                }
                this.setEditing(true);
            }
        }
    }

    private void initComponents() {
        this.simChooser = new JFileChooser();
        this.centerPanel = new JSplitPane();
        this.panelG_Carte = new JSplitPane();
        this.panelGauche = new JPanel();
        this.labelApercu = new JLabel();
        this.zGApercu = new ZGPreviewSEMA();
        this.sliderZoom = new JSlider();
        this.zoomOptions = new JPanel();
        this.fieldZoom = new JFormattedTextField(NumberFormat.getInstance());
        this.buttonFit = new JButton();
        this.Default = new JButton();
        this.jSeparator1 = new JSeparator();
        this.labelPropMonde = new JLabel();
        this.panelpropWorld = new Panel();
        this.jScrollPane1 = new JScrollPane();
        this.tablePropMonde = new JTable();
        this.zGCarte = new ZGCarteSEMA();
        this.PanelDroit = new JSplitPane();
        this.paneDroitHaut = new Panel();
        this.groundPanel = new JPanel();
        this.iconTerrain = new JLabel();
        this.GroundOptions = new JPanel();
        this.buttonCenterBox = new JButton();
        this.checkShow = new JCheckBox();
        this.jScrollPane2 = new JScrollPane();
        this.tablePropTerrain = new JTable();
        this.panelDroitBas = new JPanel();
        this.labelElementChoice = new JLabel();
        this.choixIndiv = new JComboBox();
        this.elementPanel = new JPanel();
        this.iconIndiv = new JLabel();
        this.elementOptions = new JPanel();
        this.buttonCenter = new JButton();
        this.checkFollow = new JCheckBox();
        this.checkMarked = new JCheckBox();
        this.buttonKill = new JButton();
        this.buttonaddEl = new JButton();
        this.checkLock = new JCheckBox();
        this.labelPropIndiv = new JLabel();
        this.elPropPanel = new Panel();
        this.jScrollPane3 = new JScrollPane();
        this.tablePropIndiv = new JTable();
        this.barreDoutil = new JPanel();
        this.barreDoutilEdition = new JPanel();
        this.buttonaddElbig = new JButton();
        this.buttonDuplicateEl = new JButton();
        this.buttonChangeBox = new JButton();
        this.buttonSave = new JButton();
        this.buttonRun = new JButton();
        this.barreDoutilSimulation = new JPanel();
        this.sliderTemporel = new JSlider();
        this.fieldFacteurTemporel = new JFormattedTextField(NumberFormat.getInstance());
        this.checkPause = new JCheckBox();
        this.checkBoost = new JCheckBox();
        this.fieldDate = new JFormattedTextField(NumberFormat.getInstance());
        this.fieldDelaiReel = new JFormattedTextField(NumberFormat.getInstance());
        this.buttonNext = new JButton();
        this.fieldPasNext = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.buttonDate = new JButton();
        this.labelAchievedTF = new JLabel();
        this.fieldDelaiVirtuel = new JFormattedTextField(NumberFormat.getInstance());
        this.checkActivateRDelay = new JCheckBox();
        this.checkActivateVDelay = new JCheckBox();
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuNewFile = new JMenuItem();
        this.menuOpenFile = new JMenuItem();
        this.menuEditFile = new JMenuItem();
        this.menuResetFile = new JMenuItem();
        this.menuResetWithBF = new JMenuItem();
        this.menuHelp = new JMenu();
        this.menuItemHelp = new JMenuItem();
        this.menuAbout = new JMenuItem();
        this.simChooser.setDialogTitle("Choose Simulation");
        this.simChooser.setFileFilter(new FileExtFilter("sim", "Simulation files"));
        this.setDefaultCloseOperation(3);
        this.setTitle("SEMA");
        this.setCursor(new Cursor(0));
        this.setName("frameMain");
        this.centerPanel.setDividerSize(3);
        this.centerPanel.setResizeWeight(0.9);
        this.panelG_Carte.setDividerSize(3);
        this.panelG_Carte.setResizeWeight(0.1);
        this.panelGauche.setLayout(new BoxLayout(this.panelGauche, 1));
        this.labelApercu.setText("Preview");
        this.labelApercu.setAlignmentX(0.5f);
        this.panelGauche.add(this.labelApercu);
        this.zGApercu.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.zGApercu.setOpaque(true);
        this.zGApercu.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                Sema.this.zGApercuMouseDragged(evt);
            }
        });
        this.zGApercu.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Sema.this.zGApercuMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                Sema.this.zGApercuMouseReleased(evt);
            }
        });
        this.panelGauche.add(this.zGApercu);
        this.sliderZoom.setMaximum(1000);
        this.sliderZoom.setValue(this.zoomToSlider(1.0f));
        this.sliderZoom.setMaximumSize(new Dimension(200, 24));
        this.sliderZoom.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Sema.this.sliderZoomStateChanged(evt);
            }
        });
        this.panelGauche.add(this.sliderZoom);
        this.zoomOptions.setMaximumSize(new Dimension(Short.MAX_VALUE, 43));
        this.fieldZoom.setBorder(new TitledBorder(null, "Zoom ( X )", 1, 2));
        this.fieldZoom.setHorizontalAlignment(0);
        this.fieldZoom.setAlignmentX(1.0f);
        this.fieldZoom.setMaximumSize(new Dimension(100, 43));
        this.fieldZoom.setMinimumSize(new Dimension(100, 43));
        this.fieldZoom.setPreferredSize(new Dimension(100, 43));
        this.fieldZoom.setValue(new Float(this.sliderToZoom(this.sliderZoom.getValue())));
        this.fieldZoom.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Sema.this.fieldZoomPropertyChange(evt);
            }
        });
        this.zoomOptions.add(this.fieldZoom);
        this.buttonFit.setText("Fit");
        this.buttonFit.setMargin(new Insets(2, 5, 2, 5));
        this.buttonFit.setMaximumSize(new Dimension(35, 25));
        this.buttonFit.setMinimumSize(new Dimension(35, 25));
        this.buttonFit.setPreferredSize(new Dimension(35, 25));
        this.buttonFit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.buttonFitActionPerformed(evt);
            }
        });
        this.zoomOptions.add(this.buttonFit);
        this.Default.setText("Default");
        this.Default.setMargin(new Insets(2, 5, 2, 5));
        this.Default.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.DefaultActionPerformed(evt);
            }
        });
        this.zoomOptions.add(this.Default);
        this.panelGauche.add(this.zoomOptions);
        this.jSeparator1.setMaximumSize(new Dimension(Short.MAX_VALUE, 100));
        this.panelGauche.add(this.jSeparator1);
        this.labelPropMonde.setText("World's Properties");
        this.labelPropMonde.setAlignmentX(0.5f);
        this.panelGauche.add(this.labelPropMonde);
        this.panelpropWorld.setLayout(new GridLayout(1, 0));
        this.jScrollPane1.setPreferredSize(new Dimension(200, 419));
        this.tablePropMonde.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.tablePropMonde.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Properties", "Values"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Sema.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Sema.class$("java.lang.String")) : class$java$lang$String};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tablePropMonde.setCellSelectionEnabled(true);
        this.tablePropMonde.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Properties", "Values"}));
        this.tablePropMonde.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                Sema.this.tablePropMondeFocusGained(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tablePropMonde);
        this.panelpropWorld.add(this.jScrollPane1);
        this.panelGauche.add(this.panelpropWorld);
        this.panelG_Carte.setLeftComponent(this.panelGauche);
        this.zGCarte.init(this.defaultWorld);
        this.zGCarte.setDoubleBuffered(true);
        this.zGCarte.setMinimumSize(new Dimension(200, 200));
        this.zGCarte.setOpaque(true);
        this.zGCarte.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.zGCarte.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                Sema.this.zGCarteComponentResized(evt);
            }
        });
        this.zGCarte.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                Sema.this.zGCarteMouseDragged(evt);
            }
        });
        this.zGCarte.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                Sema.this.zGCarteFocusGained(evt);
            }
        });
        this.zGCarte.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                Sema.this.zGCarteKeyPressed(evt);
            }

            public void keyTyped(KeyEvent evt) {
                Sema.this.zGCarteKeyTyped(evt);
            }
        });
        this.zGCarte.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Sema.this.zGCarteMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                Sema.this.zGCarteMouseReleased(evt);
            }
        });
        this.panelG_Carte.setRightComponent(this.zGCarte);
        this.centerPanel.setLeftComponent(this.panelG_Carte);
        this.PanelDroit.setDividerSize(3);
        this.PanelDroit.setOrientation(0);
        this.PanelDroit.setResizeWeight(0.5);
        this.paneDroitHaut.setLayout(new BoxLayout(this.paneDroitHaut, 1));
        this.groundPanel.setLayout(new GridBagLayout());
        this.iconTerrain.setIcon(new ImageIcon("C:\\Documents and Settings\\Moi\\Mes documents\\pititanglaise.png"));
        this.iconTerrain.setAlignmentX(0.5f);
        this.iconTerrain.setBorder(new TitledBorder("Ground"));
        this.iconTerrain.setDoubleBuffered(true);
        this.iconTerrain.setMaximumSize(new Dimension(112, 127));
        this.iconTerrain.setMinimumSize(new Dimension(112, 127));
        this.iconTerrain.setOpaque(true);
        this.iconTerrain.setPreferredSize(new Dimension(112, 127));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        this.groundPanel.add((Component)this.iconTerrain, gridBagConstraints);
        this.GroundOptions.setLayout(new BoxLayout(this.GroundOptions, 1));
        this.buttonCenterBox.setText("Center");
        this.buttonCenterBox.setAlignmentX(0.5f);
        this.buttonCenterBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.buttonCenterBoxActionPerformed(evt);
            }
        });
        this.GroundOptions.add(this.buttonCenterBox);
        this.checkShow.setText("Highlight");
        this.checkShow.setAlignmentX(0.5f);
        this.checkShow.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Sema.this.checkShowItemStateChanged(evt);
            }
        });
        this.GroundOptions.add(this.checkShow);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        this.groundPanel.add((Component)this.GroundOptions, gridBagConstraints);
        this.paneDroitHaut.add(this.groundPanel);
        this.jScrollPane2.setPreferredSize(new Dimension(100, 404));
        this.tablePropTerrain.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.tablePropTerrain.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Properties", "Values"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Sema.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Sema.class$("java.lang.String")) : class$java$lang$String};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tablePropTerrain.setCellSelectionEnabled(true);
        this.tablePropTerrain.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Properties", "Values"}));
        this.tablePropTerrain.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                Sema.this.tablePropTerrainFocusGained(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.tablePropTerrain);
        this.paneDroitHaut.add(this.jScrollPane2);
        this.PanelDroit.setTopComponent(this.paneDroitHaut);
        this.panelDroitBas.setLayout(new BoxLayout(this.panelDroitBas, 1));
        this.labelElementChoice.setText("Choose Element");
        this.labelElementChoice.setAlignmentX(0.5f);
        this.panelDroitBas.add(this.labelElementChoice);
        this.choixIndiv.setMaximumSize(new Dimension(1000, 30));
        this.choixIndiv.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.choixIndivActionPerformed(evt);
            }
        });
        this.panelDroitBas.add(this.choixIndiv);
        this.elementPanel.setLayout(new GridBagLayout());
        this.iconIndiv.setIcon(new ImageIcon("C:\\Documents and Settings\\Moi\\Mes documents\\pititanglaise.png"));
        this.iconIndiv.setAlignmentX(1.0f);
        this.iconIndiv.setBorder(new TitledBorder("Element's Icon"));
        this.iconIndiv.setDoubleBuffered(true);
        this.iconIndiv.setMaximumSize(new Dimension(112, 127));
        this.iconIndiv.setMinimumSize(new Dimension(112, 127));
        this.iconIndiv.setOpaque(true);
        this.iconIndiv.setPreferredSize(new Dimension(112, 127));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        this.elementPanel.add((Component)this.iconIndiv, gridBagConstraints);
        this.elementOptions.setLayout(new BoxLayout(this.elementOptions, 1));
        this.elementOptions.setMaximumSize(new Dimension(112, 127));
        this.elementOptions.setPreferredSize(new Dimension(73, 127));
        this.buttonCenter.setText("Center");
        this.buttonCenter.setAlignmentX(0.5f);
        this.buttonCenter.setMaximumSize(new Dimension(100, 100));
        this.buttonCenter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.buttonCenterActionPerformed(evt);
            }
        });
        this.elementOptions.add(this.buttonCenter);
        this.checkFollow.setText("Follow");
        this.checkFollow.setAlignmentX(0.5f);
        this.checkFollow.setMaximumSize(new Dimension(100, 100));
        this.checkFollow.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Sema.this.checkFollowItemStateChanged(evt);
            }
        });
        this.elementOptions.add(this.checkFollow);
        this.checkMarked.setText("Marked");
        this.checkMarked.setAlignmentX(0.5f);
        this.checkMarked.setMaximumSize(new Dimension(100, 100));
        this.checkMarked.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Sema.this.checkMarkedItemStateChanged(evt);
            }
        });
        this.elementOptions.add(this.checkMarked);
        this.buttonKill.setText("Kill");
        this.buttonKill.setAlignmentX(0.5f);
        this.buttonKill.setMaximumSize(new Dimension(100, 100));
        this.buttonKill.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.buttonKillActionPerformed(evt);
            }
        });
        this.elementOptions.add(this.buttonKill);
        this.buttonaddEl.setText("New...");
        this.buttonaddEl.setActionCommand("New El");
        this.buttonaddEl.setAlignmentX(0.5f);
        this.buttonaddEl.setEnabled(false);
        this.buttonaddEl.setMargin(new Insets(2, 8, 2, 8));
        this.buttonaddEl.setMaximumSize(new Dimension(100, 100));
        this.buttonaddEl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.buttonaddElActionPerformed(evt);
            }
        });
        this.elementOptions.add(this.buttonaddEl);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        this.elementPanel.add((Component)this.elementOptions, gridBagConstraints);
        this.panelDroitBas.add(this.elementPanel);
        this.checkLock.setSelected(true);
        this.checkLock.setText("Locked for Mouse");
        this.checkLock.setActionCommand("Lock Element");
        this.panelDroitBas.add(this.checkLock);
        this.labelPropIndiv.setText("Element's Properties");
        this.labelPropIndiv.setAlignmentX(0.5f);
        this.labelPropIndiv.setPreferredSize(new Dimension(97, 20));
        this.panelDroitBas.add(this.labelPropIndiv);
        this.labelPropIndiv.getAccessibleContext().setAccessibleName("Element Properties");
        this.elPropPanel.setLayout(new BoxLayout(this.elPropPanel, 1));
        this.jScrollPane3.setPreferredSize(new Dimension(100, 404));
        this.tablePropIndiv.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.tablePropIndiv.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Properties", "Values"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Sema.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Sema.class$("java.lang.String")) : class$java$lang$String};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tablePropIndiv.setCellSelectionEnabled(true);
        this.tablePropIndiv.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Properties", "Values"}));
        this.tablePropIndiv.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                Sema.this.tablePropIndivFocusGained(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.tablePropIndiv);
        this.elPropPanel.add(this.jScrollPane3);
        this.panelDroitBas.add(this.elPropPanel);
        this.PanelDroit.setBottomComponent(this.panelDroitBas);
        this.centerPanel.setRightComponent(this.PanelDroit);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.barreDoutil.setLayout(new CardLayout());
        this.barreDoutilEdition.setLayout(new GridLayout(1, 0));
        this.barreDoutilEdition.setBackground(new Color(255, 255, 255));
        this.buttonaddElbig.setText("Add Element");
        this.buttonaddElbig.setAlignmentX(0.5f);
        this.buttonaddElbig.setMargin(new Insets(2, 8, 2, 8));
        this.buttonaddElbig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.buttonaddElbigActionPerformed(evt);
            }
        });
        this.barreDoutilEdition.add(this.buttonaddElbig);
        this.buttonDuplicateEl.setText("Duplicate Selected Element");
        this.buttonDuplicateEl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.buttonDuplicateElActionPerformed(evt);
            }
        });
        this.barreDoutilEdition.add(this.buttonDuplicateEl);
        this.buttonChangeBox.setText("Modify Selected Box");
        this.buttonChangeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.buttonChangeBoxActionPerformed(evt);
            }
        });
        this.barreDoutilEdition.add(this.buttonChangeBox);
        this.buttonSave.setText("Save");
        this.buttonSave.setMargin(new Insets(2, 8, 2, 8));
        this.buttonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.buttonSaveActionPerformed(evt);
            }
        });
        this.barreDoutilEdition.add(this.buttonSave);
        this.buttonRun.setText("Run");
        this.buttonRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.buttonRunActionPerformed(evt);
            }
        });
        this.barreDoutilEdition.add(this.buttonRun);
        this.barreDoutil.add((Component)this.barreDoutilEdition, "EditingCard");
        this.barreDoutilSimulation.setLayout((LayoutManager)new AbsoluteLayout());
        this.sliderTemporel.setMaximum(10000);
        this.sliderTemporel.setValue(1000);
        this.sliderTemporel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Sema.this.sliderTemporelStateChanged(evt);
            }
        });
        this.barreDoutilSimulation.add((Component)this.sliderTemporel, new AbsoluteConstraints(10, 60, -1, -1));
        this.fieldFacteurTemporel.setBorder(new TitledBorder("Time factor"));
        this.fieldFacteurTemporel.setValue(new Float(this.sliderToFacteur(this.sliderTemporel.getValue())));
        this.fieldFacteurTemporel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Sema.this.fieldFacteurTemporelPropertyChange(evt);
            }
        });
        this.barreDoutilSimulation.add((Component)this.fieldFacteurTemporel, new AbsoluteConstraints(10, 10, 84, -1));
        this.checkPause.setSelected(true);
        this.checkPause.setText("Pause");
        this.checkPause.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Sema.this.checkPauseItemStateChanged(evt);
            }
        });
        this.barreDoutilSimulation.add((Component)this.checkPause, new AbsoluteConstraints(170, 10, -1, -1));
        this.checkBoost.setText("Boost");
        this.checkBoost.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Sema.this.checkBoostItemStateChanged(evt);
            }
        });
        this.barreDoutilSimulation.add((Component)this.checkBoost, new AbsoluteConstraints(170, 30, -1, -1));
        this.fieldDate.setBorder(new TitledBorder("Date"));
        this.fieldDate.setValue(new Double(0.0));
        this.fieldDate.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                Sema.this.fieldDateFocusGained(evt);
            }
        });
        this.barreDoutilSimulation.add((Component)this.fieldDate, new AbsoluteConstraints(240, 3, 120, -1));
        this.fieldDelaiReel.setBorder(new TitledBorder("Display real delay (ms)"));
        this.fieldDelaiReel.setValue(new Float(200.0f));
        this.fieldDelaiReel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Sema.this.fieldDelaiReelPropertyChange(evt);
            }
        });
        this.barreDoutilSimulation.add((Component)this.fieldDelaiReel, new AbsoluteConstraints(470, 3, 150, -1));
        this.buttonNext.setText("Next date");
        this.buttonNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.buttonNextActionPerformed(evt);
            }
        });
        this.barreDoutilSimulation.add((Component)this.buttonNext, new AbsoluteConstraints(370, 60, -1, -1));
        this.fieldPasNext.setBorder(new TitledBorder("Next's steps"));
        this.fieldPasNext.setValue(new Integer(1));
        this.barreDoutilSimulation.add((Component)this.fieldPasNext, new AbsoluteConstraints(250, 50, 100, 40));
        this.buttonDate.setText("Go to Date");
        this.buttonDate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.buttonDateActionPerformed(evt);
            }
        });
        this.barreDoutilSimulation.add((Component)this.buttonDate, new AbsoluteConstraints(370, 10, -1, -1));
        this.labelAchievedTF.setFont(new Font("MS Sans Serif", 0, 10));
        this.labelAchievedTF.setBorder(new TitledBorder("Achieved"));
        this.labelAchievedTF.setPreferredSize(new Dimension(12, 43));
        this.barreDoutilSimulation.add((Component)this.labelAchievedTF, new AbsoluteConstraints(94, 10, 76, -1));
        this.fieldDelaiVirtuel.setBorder(new TitledBorder("Display virtual delay (ms)"));
        this.fieldDelaiVirtuel.setEnabled(false);
        this.fieldDelaiVirtuel.setValue(new Float(5000.0f));
        this.fieldDelaiVirtuel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Sema.this.fieldDelaiVirtuelPropertyChange(evt);
            }
        });
        this.barreDoutilSimulation.add((Component)this.fieldDelaiVirtuel, new AbsoluteConstraints(470, 50, 150, -1));
        this.checkActivateRDelay.setSelected(true);
        this.checkActivateRDelay.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Sema.this.checkActivateRDelayItemStateChanged(evt);
            }
        });
        this.barreDoutilSimulation.add((Component)this.checkActivateRDelay, new AbsoluteConstraints(620, 10, -1, -1));
        this.checkActivateVDelay.setSelected(true);
        this.checkActivateVDelay.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Sema.this.checkActivateVDelayItemStateChanged(evt);
            }
        });
        this.barreDoutilSimulation.add((Component)this.checkActivateVDelay, new AbsoluteConstraints(620, 60, -1, -1));
        this.barreDoutil.add((Component)this.barreDoutilSimulation, "SimulatingCard");
        this.getContentPane().add((Component)this.barreDoutil, "South");
        this.menuFile.setText("File");
        this.menuNewFile.setText("New file...");
        this.menuNewFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.menuNewFileActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuNewFile);
        this.menuOpenFile.setText("Open file...");
        this.menuOpenFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.menuOpenFileActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuOpenFile);
        this.menuEditFile.setText("Edit file...");
        this.menuEditFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.menuEditFileActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuEditFile);
        this.menuResetFile.setText("Reset current file");
        this.menuResetFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.menuResetFileActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuResetFile);
        this.menuResetWithBF.setText("Reset with boxfactor");
        this.menuResetWithBF.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.menuResetWithBFActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuResetWithBF);
        this.menuBar.add(this.menuFile);
        this.menuHelp.setText("Help");
        this.menuItemHelp.setText("Help");
        this.menuItemHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.menuItemHelpActionPerformed(evt);
            }
        });
        this.menuHelp.add(this.menuItemHelp);
        this.menuAbout.setText("About");
        this.menuAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sema.this.menuAboutActionPerformed(evt);
            }
        });
        this.menuHelp.add(this.menuAbout);
        this.menuBar.add(this.menuHelp);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void checkShowItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.zGCarte.setHighlightSelectedBox(true);
        } else {
            this.zGCarte.setHighlightSelectedBox(false);
        }
        this.repaint();
    }

    private void zGApercuMouseDragged(MouseEvent evt) {
        this.isPreviewDragued = true;
        if (this.isPreviewMoving) {
            float f = evt.getX() - this.xMoveApercu;
            this.zGApercu.getClass();
            float f2 = f / 200.0f * this.world.map.xLength;
            float f3 = evt.getY() - this.yMoveApercu;
            this.zGApercu.getClass();
            this.setCenterPos(f2, f3 / 200.0f * this.world.map.yLength);
            this.repaint();
        }
    }

    private void zGApercuMousePressed(MouseEvent evt) {
        if (this.zGApercu.isInZone(evt.getX(), evt.getY())) {
            this.xMoveApercu = evt.getX() - this.zGApercu.getCenterX();
            this.yMoveApercu = evt.getY() - this.zGApercu.getCenterY();
            this.isPreviewMoving = true;
        } else {
            this.isPreviewMoving = false;
        }
    }

    private void checkMarkedItemStateChanged(ItemEvent evt) {
        if (this.selectedElement != null) {
            if (evt.getStateChange() == 1) {
                this.selectedElement.setMarked(true);
            } else {
                this.selectedElement.setMarked(false);
            }
            this.repaint();
        }
    }

    private void buttonRunActionPerformed(ActionEvent evt) {
        if (this.world != null) {
            if (this.currentfile != null) {
                this.setTitle("SEMA - " + this.world.getName() + " (" + this.currentfile + ")");
            } else {
                this.setTitle("SEMA - " + this.world.getName());
            }
        }
        this.run();
    }

    private void buttonaddElbigActionPerformed(ActionEvent evt) {
        this.addEl();
    }

    private void menuResetWithBFActionPerformed(ActionEvent evt) {
        this.reset(true);
    }

    private void menuItemHelpActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(null, "[GENERAL]\n---------\n Arrows or click on Preview to move the map\n SPACE to pause/resume the simulation\n + and - to zoom\n PgDwn and PgUp to change time factor\n Click on the map to select a box or an element\n\n[SELECTED ELEMENT]\n------------------\n L to lock/unlock\n F to follow,\n M to mark,\n DEL to kill,\n (and, when unlocked:)\n Left mouse drag on the map to move,\n Right mouse drag to rotate\n", "Help on Sema", 1);
    }

    private void menuAboutActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(null, "Syst\u00e8meExtensibleMultiAgents v1.04, by POOGL", "About SEMA", 1);
    }

    private void menuOpenFileActionPerformed(ActionEvent evt) {
        this.open();
    }

    private void menuNewFileActionPerformed(ActionEvent evt) {
        this.newSim();
    }

    private void menuEditFileActionPerformed(ActionEvent evt) {
        this.edit();
    }

    private void menuResetFileActionPerformed(ActionEvent evt) {
        this.reset(false);
    }

    private void buttonChangeBoxActionPerformed(ActionEvent evt) {
        if (this.selectedBox != null) {
            int x = this.selectedBox.x;
            int y = this.selectedBox.y;
            Box b = this.world.map.boxes[x][y];
            try {
                String oldBoxCode = this.ioSIM.codeOf(b);
                String boxCode = JOptionPane.showInputDialog(null, "New box code: ", oldBoxCode);
                if (boxCode != null && !boxCode.equals("") && !boxCode.equals(oldBoxCode)) {
                    this.ioSIM.changeBox(this.world, x, y, boxCode);
                    this.repaint();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "Invalid box.", 2);
            }
        }
    }

    private void buttonDuplicateElActionPerformed(ActionEvent evt) {
        if (this.selectedElement == null) {
            return;
        }
        this.lastCodeEntered = this.ioSIM.codeOf(this.selectedElement);
        this.addEl();
    }

    private void buttonaddElActionPerformed(ActionEvent evt) {
        this.addEl();
    }

    private void buttonSaveActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void buttonKillActionPerformed(ActionEvent evt) {
        this.killSelected();
    }

    private void zGCarteMouseReleased(MouseEvent evt) {
        if (this.isMouvingElement || this.isRotatingElement) {
            this.ioSIM.elementChanged(this.selectedElement);
            this.resume_temporaire();
            this.isMouvingElement = false;
            this.isRotatingElement = false;
        }
    }

    private void zGCarteMousePressed(MouseEvent evt) {
        if (!this.pause_temp || !this.wasRunning) {
            float pbu = this.world.drawing.getPixelsByUnit();
            float xClick = (float)evt.getX() / pbu + this.zGCarte.getXu();
            float yClick = (float)evt.getY() / pbu + this.zGCarte.getYu();
            try {
                this.setSelection(xClick, yClick);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            if (this.selectedElement != null) {
                this.xMove = xClick - this.selectedElement.getArea().getX();
                this.yMove = yClick - this.selectedElement.getArea().getY();
                this.angleMove = (float)Math.atan2(this.xMove, -this.yMove) - this.selectedElement.getArea().getAngle();
                if (!this.checkLock.isSelected() && this.selectedElement.getArea().isIn(xClick, yClick)) {
                    if (evt.getButton() == 1) {
                        this.isMouvingElement = true;
                    } else {
                        this.isRotatingElement = true;
                    }
                    this.pause_temporaire();
                }
            }
        }
    }

    private void zGCarteMouseDragged(MouseEvent evt) {
        float pbu = this.world.drawing.getPixelsByUnit();
        if (this.isMouvingElement) {
            this.selectedElement.getArea().setX((float)evt.getX() / pbu + this.zGCarte.getXu() - this.xMove);
            this.selectedElement.getArea().setY((float)evt.getY() / pbu + this.zGCarte.getYu() - this.yMove);
            this.repaint();
        } else if (this.isRotatingElement) {
            float xClick = (float)evt.getX() / pbu + this.zGCarte.getXu();
            float yClick = (float)evt.getY() / pbu + this.zGCarte.getYu();
            this.xMove = xClick - this.selectedElement.getArea().getX();
            this.yMove = yClick - this.selectedElement.getArea().getY();
            this.selectedElement.getArea().setAngle((float)Math.atan2(this.xMove, -this.yMove) - this.angleMove);
            this.repaint();
        }
    }

    private void zGCarteKeyPressed(KeyEvent evt) {
        switch (evt.getKeyCode()) {
            case 39: {
                this.setCenterPos(this.getCenterX() + this.zGCarte.getWidthu() / 25.0f, this.getCenterY());
                this.repaint();
                break;
            }
            case 37: {
                this.setCenterPos(this.getCenterX() - this.zGCarte.getWidthu() / 25.0f, this.getCenterY());
                this.repaint();
                break;
            }
            case 38: {
                this.setCenterPos(this.getCenterX(), this.getCenterY() - this.zGCarte.getHeightu() / 25.0f);
                this.repaint();
                break;
            }
            case 40: {
                this.setCenterPos(this.getCenterX(), this.getCenterY() + this.zGCarte.getHeightu() / 25.0f);
                this.repaint();
                break;
            }
            case 32: {
                this.setPause(!this.checkPause.isSelected());
                break;
            }
            case 33: {
                this.setTimeFactor(this.getTimeFactor() * 1.1f);
                break;
            }
            case 34: {
                this.setTimeFactor(this.getTimeFactor() / 1.1f);
                break;
            }
            case 127: {
                this.killSelected();
                break;
            }
            case 70: {
                this.checkFollow.setSelected(!this.checkFollow.isSelected());
                break;
            }
            case 76: {
                this.checkLock.setSelected(!this.checkLock.isSelected());
                break;
            }
            case 77: {
                this.checkMarked.setSelected(!this.checkMarked.isSelected());
            }
        }
    }

    private void zGCarteKeyTyped(KeyEvent evt) {
        switch (evt.getKeyChar()) {
            case '+': {
                this.setZoom(this.getZoom() * 1.1f);
                break;
            }
            case '-': {
                this.setZoom(this.getZoom() / 1.1f);
            }
        }
    }

    private void checkActivateVDelayItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            if (this.lastVDelay > -1.0) {
                this.setVirtualDisplayDelay(this.lastVDelay);
            }
            this.fieldDelaiVirtuel.setEnabled(true);
        } else {
            this.lastVDelay = this.getVirtualDisplayDelay();
            this.setVirtualDisplayDelay(Double.POSITIVE_INFINITY);
            this.fieldDelaiVirtuel.setValue(new Double(Double.POSITIVE_INFINITY));
            this.fieldDelaiVirtuel.setEnabled(false);
        }
    }

    private void checkActivateRDelayItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.setRealDisplayDelay(this.lastRDelay);
            this.fieldDelaiReel.setEnabled(true);
        } else {
            this.lastRDelay = this.getRealDisplayDelay();
            this.setRealDisplayDelay(Long.MAX_VALUE);
            this.fieldDelaiReel.setValue(new Double(Double.POSITIVE_INFINITY));
            this.fieldDelaiReel.setEnabled(false);
        }
    }

    private void buttonCenterBoxActionPerformed(ActionEvent evt) {
        this.centerSelectedBox();
    }

    private void checkFollowItemStateChanged(ItemEvent evt) {
        this.isFollowing = evt.getStateChange() == 1;
        this.repaint();
    }

    private void buttonCenterActionPerformed(ActionEvent evt) {
        this.centerSelectedElement();
    }

    private void DefaultActionPerformed(ActionEvent evt) {
        this.setZoom(this.defaultZoom);
    }

    private void checkBoostItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.timeFactorEnabled = false;
            this.fieldFacteurTemporel.setEnabled(false);
            this.sliderTemporel.setEnabled(false);
            this.delaiVirtuelAffSynchronized = this.VirtualDisplayDelay;
        } else {
            this.timeFactorEnabled = true;
            this.fieldFacteurTemporel.setEnabled(true);
            this.sliderTemporel.setEnabled(true);
            this.delaiVirtuelAffSynchronized = Math.min(this.VirtualDisplayDelay, (double)((float)this.RealDisplayDelay * this.timeFactor));
        }
        this.refreshDelaiVirtuelAffSynchronized();
    }

    private void tablePropTerrainFocusGained(FocusEvent evt) {
        this.pause_temporaire();
    }

    private void zGCarteFocusGained(FocusEvent evt) {
        this.resume_temporaire();
    }

    private void buttonFitActionPerformed(ActionEvent evt) {
        if (this.world != null) {
            float pbu1x = this.world.drawing.pixelsByUnitZoom1x;
            this.setZoom(1.0f / Math.max(pbu1x * this.world.map.xLength / (float)this.zGCarte.getWidth(), pbu1x * this.world.map.yLength / (float)this.zGCarte.getHeight()));
            this.setCenterPos(this.world.map.xLength / 2.0f, this.world.map.yLength / 2.0f);
            this.repaint();
        }
    }

    private void zGCarteComponentResized(ComponentEvent evt) {
        this.resizeZonePreview();
    }

    private void buttonDateActionPerformed(ActionEvent evt) {
        this.goToDate(((Number)this.fieldDate.getValue()).doubleValue());
        this.repaint();
    }

    private void fieldDateFocusGained(FocusEvent evt) {
        this.pause_temporaire();
    }

    private void tablePropMondeFocusGained(FocusEvent evt) {
        this.pause_temporaire();
    }

    private void tablePropIndivFocusGained(FocusEvent evt) {
        this.pause_temporaire();
    }

    private void choixIndivActionPerformed(ActionEvent evt) {
        if (this.choixIndiv.getSelectedItem() != null) {
            this.setSelectedElement(((ChoixObject)this.choixIndiv.getSelectedItem()).e);
            this.repaint();
        }
    }

    private void fieldDelaiVirtuelPropertyChange(PropertyChangeEvent evt) {
        this.changeVirtualDisplayDelay(((Number)this.fieldDelaiVirtuel.getValue()).doubleValue());
    }

    private void fieldDelaiReelPropertyChange(PropertyChangeEvent evt) {
        this.changeRealDisplayDelay(((Number)this.fieldDelaiReel.getValue()).longValue());
    }

    private void zGApercuMouseReleased(MouseEvent evt) {
        if (!this.isPreviewDragued) {
            float f = evt.getX();
            this.zGApercu.getClass();
            float f2 = f / 200.0f * this.world.map.xLength;
            float f3 = evt.getY();
            this.zGApercu.getClass();
            this.setCenterPos(f2, f3 / 200.0f * this.world.map.yLength);
            this.repaint();
        }
        this.isPreviewDragued = false;
    }

    private void buttonNextActionPerformed(ActionEvent evt) {
        if (this.world != null) {
            try {
                for (int i = 0; i < ((Number)this.fieldPasNext.getValue()).intValue(); ++i) {
                    this.world.engine.next();
                }
            }
            catch (Engine.EndOfSimulation e) {
                this.setPause(true);
                this.hasEnded = true;
            }
            catch (Engine.SimulationError e) {
                this.setPause(true);
                JOptionPane.showMessageDialog(null, "An error occured while treating the current event.\nSimulation was paused, but you can resume it." + e.getMessage(), "Simulation error", 2);
            }
        }
        this.repaint();
    }

    private void checkPauseItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.setPause(true);
        } else if (this.world != null) {
            this.setPause(false);
        }
    }

    private int zoomToSlider(float f) {
        float ff = Math.min(this.zoomMax, Math.max(this.zoomMin, f));
        return Math.round((ff - this.zoomMin) / (this.zoomMax - this.zoomMin) * (float)(this.sliderZoom.getMaximum() - this.sliderZoom.getMinimum()) + (float)this.sliderZoom.getMinimum());
    }

    private void fieldZoomPropertyChange(PropertyChangeEvent evt) {
        Number z = (Number)this.fieldZoom.getValue();
        if (this.sliderZoom != null && z != null) {
            float fz = z.floatValue();
            if (fz > this.zoomMax) {
                fz = this.zoomMax;
                this.fieldZoom.setValue(new Float(fz));
            }
            if (fz < this.zoomMin) {
                fz = this.zoomMin;
                this.fieldZoom.setValue(new Float(fz));
            }
            this.sliderZoom.setValue(this.zoomToSlider(fz));
            this.setZoom(fz);
            this.repaint();
        }
    }

    private float sliderToZoom(int i) {
        return (this.zoomMax - this.zoomMin) * (float)(i - this.sliderZoom.getMinimum()) / (float)(this.sliderZoom.getMaximum() - this.sliderZoom.getMinimum()) + this.zoomMin;
    }

    private void sliderZoomStateChanged(ChangeEvent evt) {
        float z = this.sliderToZoom(this.sliderZoom.getValue());
        if (!this.sliderZoom.getValueIsAdjusting()) {
            this.fieldZoom.setValue(new Float(z));
        } else {
            this.fieldZoom.setText(String.valueOf(z));
        }
    }

    private int facteurToSlider(float f) {
        float ff = Math.min(this.facteurTemporelMax, Math.max(this.facteurTemporelMin, f));
        return Math.round((ff - this.facteurTemporelMin) / (this.facteurTemporelMax - this.facteurTemporelMin) * (float)(this.sliderTemporel.getMaximum() - this.sliderTemporel.getMinimum()) + (float)this.sliderTemporel.getMinimum());
    }

    private void fieldFacteurTemporelPropertyChange(PropertyChangeEvent evt) {
        Number fxt = (Number)this.fieldFacteurTemporel.getValue();
        if (this.sliderTemporel != null && fxt != null) {
            float ffxt = fxt.floatValue();
            if (ffxt > this.facteurTemporelMax) {
                ffxt = this.facteurTemporelMax;
                this.fieldZoom.setValue(new Float(ffxt));
            }
            if (ffxt < this.facteurTemporelMin) {
                ffxt = this.facteurTemporelMin;
                this.fieldZoom.setValue(new Float(ffxt));
            }
            this.sliderTemporel.setValue(this.facteurToSlider(ffxt));
            this.changeTimeFactor(ffxt);
            this.repaint();
        }
    }

    private float sliderToFacteur(int i) {
        return (this.facteurTemporelMax - this.facteurTemporelMin) * (float)(i - this.sliderTemporel.getMinimum()) / (float)(this.sliderTemporel.getMaximum() - this.sliderTemporel.getMinimum()) + this.facteurTemporelMin;
    }

    private void sliderTemporelStateChanged(ChangeEvent evt) {
        float fxt = this.sliderToFacteur(this.sliderTemporel.getValue());
        if (!this.sliderTemporel.getValueIsAdjusting()) {
            this.fieldFacteurTemporel.setValue(new Float(fxt));
        } else {
            this.fieldFacteurTemporel.setText(String.valueOf(fxt));
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Sema f = new Sema();
                f.setExtendedState(6);
                f.pack();
                f.setVisible(true);
            }
        });
    }

    private class ChoixObject {
        public Element e;

        public ChoixObject(Element e) {
            this.e = e;
        }

        public String toString() {
            if (this.e == null) {
                return "(none)";
            }
            return this.e.getName();
        }
    }

    private class SEMAThread
    extends Thread {
        private double lastDrawVirtualDate;
        private double virtualDuration;
        private long lastDrawRealDate;
        private long realDuration;
        private long attente;

        private SEMAThread() {
        }

        public void init() {
            Sema.this.repaint();
            this.lastDrawVirtualDate = 1000.0 * ((Sema)Sema.this).world.engine.getTime();
            this.lastDrawRealDate = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void wait_run() {
            while (!Sema.this.isRunning) {
                try {
                    Object object = run;
                    synchronized (object) {
                        run.wait();
                    }
                }
                catch (Exception exception) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.wait_run();
            this.init();
            if (Sema.this.world != null) {
                while (true) {
                    this.wait_run();
                    Object object = run;
                    synchronized (object) {
                        Sema.this.next();
                    }
                    double currentVirtualDate = 1000.0 * ((Sema)Sema.this).world.engine.getTime();
                    this.virtualDuration = currentVirtualDate - this.lastDrawVirtualDate;
                    this.realDuration = System.currentTimeMillis() - this.lastDrawRealDate;
                    if (!(this.virtualDuration > Sema.this.delaiVirtuelAffSynchronized) && this.realDuration <= Sema.this.RealDisplayDelay) continue;
                    long attente = (long)(this.virtualDuration / (double)Sema.this.timeFactor) - this.realDuration;
                    if (attente > 0L && Sema.this.timeFactorEnabled) {
                        try {
                            Thread.sleep(attente);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    Sema.this.repaint();
                    long lastDrawRealDateTemp = System.currentTimeMillis();
                    Sema.this.displayRealTimeFactor(this.virtualDuration / (double)(lastDrawRealDateTemp - this.lastDrawRealDate));
                    this.lastDrawVirtualDate = currentVirtualDate;
                    this.lastDrawRealDate = lastDrawRealDateTemp;
                }
            }
        }
    }
}

